/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.EntryBits;

public enum SoplogToken {
    WILDCARD(102),
    TOMBSTONE(EntryBits.setTombstone((byte)0, true)),
    INVALID(EntryBits.setInvalid((byte)0, true)),
    REMOVED_PHASE2(EntryBits.setLocalInvalid((byte)0, true)),
    SERIALIZED(EntryBits.setSerialized((byte)0, true));

    private final byte val;

    private SoplogToken(byte val) {
        this.val = val;
    }

    public String toString() {
        return super.toString() + " byte:" + this.val;
    }

    public byte toByte() {
        return this.val;
    }

    public static boolean isWildcard(byte[] b1, int off1, byte[] b2, int off2) {
        return b1[off1] == 102 || b2[off2] == 102;
    }

    public static boolean isTombstone(byte b) {
        return EntryBits.isTombstone(b);
    }

    public static boolean isInvalid(byte b) {
        return EntryBits.isInvalid(b);
    }

    public static boolean isRemovedPhase2(byte b) {
        return EntryBits.isLocalInvalid(b);
    }

    public static boolean isSerialized(byte b) {
        return EntryBits.isSerialized(b);
    }
}

