/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.AbstractKeyValueIterator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.AbstractSortedReader;
import com.gemstone.gemfire.internal.cache.persistence.soplog.Compactor;
import com.gemstone.gemfire.internal.cache.persistence.soplog.ReversingSerializedComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedBuffer;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplog;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogFactory;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogSet;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.util.AbortableTaskService;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public class SortedOplogSetImpl
extends AbstractSortedReader
implements SortedOplogSet {
    private static final Logger logger = LogService.getLogger();
    private final SortedOplogFactory factory;
    private final AbortableTaskService flusher;
    private final Compactor compactor;
    private final AtomicReference<SortedBuffer<Integer>> current;
    private final AtomicInteger bufferCount;
    private final Deque<SortedBuffer<Integer>> unflushed;
    private final ReadWriteLock rwlock;
    volatile CountDownLatch testDelayDuringFlush;
    volatile boolean testErrorDuringFlush;
    private final String logPrefix;

    public SortedOplogSetImpl(SortedOplogFactory factory, Executor exec, Compactor ctor) throws IOException {
        this.factory = factory;
        this.flusher = new AbortableTaskService(exec);
        this.compactor = ctor;
        this.rwlock = new ReentrantReadWriteLock();
        this.bufferCount = new AtomicInteger(0);
        this.unflushed = new ArrayDeque<SortedBuffer<Integer>>();
        this.current = new AtomicReference<SortedBuffer<Integer>>(new SortedBuffer<Integer>(factory.getConfiguration(), 0));
        this.logPrefix = "<" + factory.getConfiguration().getName() + "> ";
        if (logger.isDebugEnabled()) {
            logger.debug("{}Creating soplog set", this.logPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mightContain(byte[] key2) throws IOException {
        Collection soplogs;
        ArrayList<SortedBuffer<Integer>> readers;
        if (this.getCurrent().mightContain(key2)) {
            return true;
        }
        this.rwlock.readLock().lock();
        try {
            readers = new ArrayList<SortedBuffer<Integer>>(this.unflushed);
            soplogs = this.compactor.getActiveReaders(key2, key2);
            for (TrackedReference<SortedOplog.SortedOplogReader> trackedReference : soplogs) {
                readers.add((SortedBuffer<Integer>)((Object)trackedReference.get()));
            }
        }
        finally {
            this.rwlock.readLock().unlock();
        }
        try {
            for (SortedReader sortedReader : readers) {
                if (!sortedReader.mightContain(key2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            TrackedReference.decrementAll(soplogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(byte[] key2) throws IOException {
        Collection soplogs;
        ArrayList<SortedBuffer<Integer>> readers;
        ByteBuffer val = this.getCurrent().read(key2);
        if (val != null) {
            return val;
        }
        this.rwlock.readLock().lock();
        try {
            readers = new ArrayList<SortedBuffer<Integer>>(this.unflushed);
            soplogs = this.compactor.getActiveReaders(key2, key2);
            for (TrackedReference<SortedOplog.SortedOplogReader> trackedReference : soplogs) {
                readers.add((SortedBuffer<Integer>)((Object)trackedReference.get()));
            }
        }
        finally {
            this.rwlock.readLock().unlock();
        }
        try {
            for (SortedReader sortedReader : readers) {
                if (!sortedReader.mightContain(key2) || (val = (ByteBuffer)sortedReader.read(key2)) == null) continue;
                ByteBuffer byteBuffer = val;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            TrackedReference.decrementAll(soplogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedReader.SortedIterator<ByteBuffer> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive, boolean ascending, SortedReader.MetadataFilter filter) throws IOException {
        Collection<TrackedReference<SortedOplog.SortedOplogReader>> soplogs;
        SortedReader.SerializedComparator sc = this.factory.getConfiguration().getComparator();
        sc = ascending ? sc : ReversingSerializedComparator.reverse(sc);
        ArrayList<SortedReader.SortedIterator<ByteBuffer>> scans = new ArrayList<SortedReader.SortedIterator<ByteBuffer>>();
        this.rwlock.readLock().lock();
        try {
            scans.add(this.getCurrent().scan(from, fromInclusive, to, toInclusive, ascending, filter));
            for (SortedBuffer<Integer> sortedBuffer : this.unflushed) {
                scans.add(sortedBuffer.scan(from, fromInclusive, to, toInclusive, ascending, filter));
            }
            soplogs = this.compactor.getActiveReaders(from, to);
        }
        finally {
            this.rwlock.readLock().unlock();
        }
        for (TrackedReference trackedReference : soplogs) {
            scans.add(((SortedOplog.SortedOplogReader)trackedReference.get()).scan(from, fromInclusive, to, toInclusive, ascending, filter));
        }
        return new MergedIterator(sc, soplogs, scans);
    }

    @Override
    public void put(byte[] key2, byte[] value2) {
        assert (key2 != null);
        assert (value2 != null);
        long start = this.factory.getConfiguration().getStatistics().getPut().begin();
        this.getCurrent().put(key2, value2);
        this.factory.getConfiguration().getStatistics().getPut().end(value2.length, start);
    }

    @Override
    public long bufferSize() {
        return this.getCurrent().dataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long unflushedSize() {
        long size2 = 0L;
        this.rwlock.readLock().lock();
        try {
            for (SortedBuffer<Integer> sb : this.unflushed) {
                size2 += sb.dataSize();
            }
        }
        finally {
            this.rwlock.readLock().unlock();
        }
        return size2;
    }

    @Override
    public void flushAndClose(EnumMap<SortedReader.Metadata, byte[]> metadata) throws IOException {
        final AtomicReference<Object> err = new AtomicReference<Object>(null);
        this.flush(metadata, new SortedOplogSet.FlushHandler(){

            @Override
            public void complete() {
            }

            @Override
            public void error(Throwable t) {
                err.set(t);
            }
        });
        this.close();
        Throwable t = err.get();
        if (t != null) {
            throw new IOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(EnumMap<SortedReader.Metadata, byte[]> metadata, SortedOplogSet.FlushHandler handler) {
        assert (handler != null);
        long start = this.factory.getConfiguration().getStatistics().getFlush().begin();
        this.rwlock.writeLock().lock();
        try {
            if (this.isClosed()) {
                handler.complete();
                this.factory.getConfiguration().getStatistics().getFlush().end(0L, start);
                return;
            }
            SortedBuffer<Integer> sb = this.flipBuffer();
            if (sb.count() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Skipping flush of empty buffer {}", this.logPrefix, sb);
                }
                handler.complete();
                return;
            }
            sb.setMetadata(metadata);
            this.unflushed.addFirst(sb);
            this.flusher.execute(new FlushTask(handler, sb, start));
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    @Override
    public void clear() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Clearing soplog set", this.logPrefix);
        }
        long start = this.factory.getConfiguration().getStatistics().getClear().begin();
        this.rwlock.writeLock().lock();
        try {
            SortedBuffer<Integer> tmp = this.current.get();
            if (tmp != null) {
                tmp.clear();
            }
            this.flusher.abortAll();
            for (SortedBuffer<Integer> sb : this.unflushed) {
                sb.clear();
            }
            this.unflushed.clear();
            this.compactor.clear();
            this.releaseTestDelay();
            this.flusher.waitForCompletion();
            this.factory.getConfiguration().getStatistics().getClear().end(start);
        }
        catch (IOException e) {
            this.factory.getConfiguration().getStatistics().getClear().error(start);
            throw (IOException)e.fillInStackTrace();
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    @Override
    public void destroy() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Destroying soplog set", this.logPrefix);
        }
        long start = this.factory.getConfiguration().getStatistics().getDestroy().begin();
        try {
            this.unsetCurrent();
            this.clear();
            this.close();
            this.factory.getConfiguration().getStatistics().getDestroy().end(start);
        }
        catch (IOException e) {
            this.factory.getConfiguration().getStatistics().getDestroy().error(start);
            throw (IOException)e.fillInStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Closing soplog set", this.logPrefix);
        }
        this.unsetCurrent();
        this.releaseTestDelay();
        this.flusher.waitForCompletion();
        this.compactor.close();
    }

    @Override
    public SortedReader.SerializedComparator getComparator() {
        return this.factory.getConfiguration().getComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedReader.SortedStatistics getStatistics() throws IOException {
        Collection<TrackedReference<SortedOplog.SortedOplogReader>> soplogs;
        ArrayList<SortedReader.SortedStatistics> stats = new ArrayList<SortedReader.SortedStatistics>();
        this.rwlock.readLock().lock();
        try {
            stats.add(this.getCurrent().getStatistics());
            for (SortedBuffer<Integer> sortedBuffer : this.unflushed) {
                stats.add(sortedBuffer.getStatistics());
            }
            soplogs = this.compactor.getActiveReaders(null, null);
        }
        finally {
            this.rwlock.readLock().unlock();
        }
        for (TrackedReference trackedReference : soplogs) {
            stats.add(((SortedOplog.SortedOplogReader)trackedReference.get()).getStatistics());
        }
        return new MergedStatistics(stats, soplogs);
    }

    @Override
    public Compactor getCompactor() {
        return this.compactor;
    }

    @Override
    public boolean isClosed() {
        return this.current.get() == null;
    }

    @Override
    public SortedOplogFactory getFactory() {
        return this.factory;
    }

    private SortedBuffer<Integer> flipBuffer() {
        SortedBuffer<Integer> sb = this.getCurrent();
        SortedBuffer<Integer> next2 = new SortedBuffer<Integer>(this.factory.getConfiguration(), this.bufferCount.incrementAndGet());
        this.current.set(next2);
        if (logger.isDebugEnabled()) {
            logger.debug("{}Switching from buffer {} to {}", this.logPrefix, sb, next2);
        }
        return sb;
    }

    private SortedBuffer<Integer> getCurrent() {
        SortedBuffer<Integer> tmp = this.current.get();
        if (tmp == null) {
            throw new IllegalStateException("Closed");
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetCurrent() {
        this.rwlock.writeLock().lock();
        try {
            SortedBuffer tmp = this.current.getAndSet(null);
            if (tmp != null) {
                tmp.clear();
            }
        }
        finally {
            this.rwlock.writeLock().unlock();
        }
    }

    private void releaseTestDelay() {
        if (this.testDelayDuringFlush != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Releasing testDelayDuringFlush", this.logPrefix);
            }
            this.testDelayDuringFlush.countDown();
        }
    }

    public static class MergedIterator
    extends AbstractKeyValueIterator<ByteBuffer, ByteBuffer>
    implements SortedReader.SortedIterator<ByteBuffer> {
        private final SortedReader.SerializedComparator comparator;
        private final Collection<TrackedReference<SortedOplog.SortedOplogReader>> soplogs;
        private final List<SortedReader.SortedIterator<ByteBuffer>> iters;
        private ByteBuffer key;
        private ByteBuffer value;

        public MergedIterator(SortedReader.SerializedComparator comparator, Collection<TrackedReference<SortedOplog.SortedOplogReader>> soplogs, List<SortedReader.SortedIterator<ByteBuffer>> iters) {
            this.comparator = comparator;
            this.soplogs = soplogs;
            this.iters = iters;
            int i = 0;
            while (i < iters.size()) {
                i = this.advance(i);
            }
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public ByteBuffer value() {
            return this.value;
        }

        @Override
        protected boolean step() {
            if (this.iters.isEmpty() || this.readerIsClosed()) {
                return false;
            }
            int cursor = 0;
            this.key = (ByteBuffer)this.iters.get(cursor).key();
            int i = 1;
            while (i < this.iters.size()) {
                ByteBuffer tmp = (ByteBuffer)this.iters.get(i).key();
                int diff = this.comparator.compare(tmp.array(), tmp.arrayOffset(), tmp.remaining(), this.key.array(), this.key.arrayOffset(), this.key.remaining());
                if (diff < 0) {
                    cursor = i++;
                    this.key = tmp;
                    continue;
                }
                if (diff == 0) {
                    i = this.advance(i);
                    continue;
                }
                ++i;
            }
            this.value = (ByteBuffer)this.iters.get(cursor).value();
            this.advance(cursor);
            return true;
        }

        @Override
        public void close() {
            for (SortedReader.SortedIterator<ByteBuffer> iter : this.iters) {
                iter.close();
            }
            TrackedReference.decrementAll(this.soplogs);
        }

        private int advance(int idx) {
            if (!this.iters.get(idx).hasNext()) {
                this.iters.remove(idx).close();
                return idx;
            }
            this.iters.get(idx).next();
            return idx + 1;
        }

        private boolean readerIsClosed() {
            for (TrackedReference<SortedOplog.SortedOplogReader> tr : this.soplogs) {
                if (!tr.get().isClosed()) continue;
                return true;
            }
            return false;
        }
    }

    private class MergedStatistics
    implements SortedReader.SortedStatistics {
        private final List<SortedReader.SortedStatistics> stats;
        private final Collection<TrackedReference<SortedOplog.SortedOplogReader>> soplogs;

        public MergedStatistics(List<SortedReader.SortedStatistics> stats, Collection<TrackedReference<SortedOplog.SortedOplogReader>> soplogs) {
            this.stats = stats;
            this.soplogs = soplogs;
        }

        @Override
        public long keyCount() {
            long keys = 0L;
            for (SortedReader.SortedStatistics ss : this.stats) {
                keys += ss.keyCount();
            }
            return keys;
        }

        @Override
        public byte[] firstKey() {
            byte[] first = this.stats.get(0).firstKey();
            for (int i = 1; i < this.stats.size(); ++i) {
                byte[] tmp = this.stats.get(i).firstKey();
                if (SortedOplogSetImpl.this.getComparator().compare(first, tmp) <= 0) continue;
                first = tmp;
            }
            return first;
        }

        @Override
        public byte[] lastKey() {
            byte[] last = this.stats.get(0).lastKey();
            for (int i = 1; i < this.stats.size(); ++i) {
                byte[] tmp = this.stats.get(i).lastKey();
                if (SortedOplogSetImpl.this.getComparator().compare(last, tmp) >= 0) continue;
                last = tmp;
            }
            return last;
        }

        @Override
        public double avgKeySize() {
            double avg = 0.0;
            for (SortedReader.SortedStatistics ss : this.stats) {
                avg += ss.avgKeySize();
            }
            return avg / (double)this.stats.size();
        }

        @Override
        public double avgValueSize() {
            double avg = 0.0;
            for (SortedReader.SortedStatistics ss : this.stats) {
                avg += ss.avgValueSize();
            }
            return avg / (double)this.stats.size();
        }

        @Override
        public void close() {
            TrackedReference.decrementAll(this.soplogs);
        }
    }

    private class FlushTask
    implements AbortableTaskService.AbortableTask {
        private final SortedOplogSet.FlushHandler handler;
        private final SortedBuffer<Integer> buffer;
        private final long start;

        public FlushTask(SortedOplogSet.FlushHandler handler, SortedBuffer<Integer> buffer, long start) {
            this.handler = handler;
            this.buffer = buffer;
            this.start = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runOrAbort(final AtomicBoolean aborted) {
            try {
                final SortedOplog soplog = this.writeBuffer(this.buffer, aborted);
                if (soplog == null || !this.lockOrAbort(aborted)) {
                    this.handler.complete();
                    return;
                }
                try {
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SortedOplogSetImpl.this.compactor.add(soplog);
                                SortedOplogSetImpl.this.compactor.compact(false, null);
                                SortedOplogSetImpl.this.unflushed.removeFirstOccurrence(FlushTask.this.buffer);
                                FlushTask.this.handler.complete();
                                SortedOplogSetImpl.this.factory.getConfiguration().getStatistics().getFlush().end(FlushTask.this.buffer.dataSize(), FlushTask.this.start);
                            }
                            catch (Exception e) {
                                FlushTask.this.handleError(e, aborted);
                                return;
                            }
                        }
                    };
                    if (this.buffer == SortedOplogSetImpl.this.unflushed.peekLast()) {
                        action.run();
                        SortedBuffer tail = (SortedBuffer)SortedOplogSetImpl.this.unflushed.peekLast();
                        while (tail != null && tail.isDeferred() && !aborted.get()) {
                            tail.complete();
                            tail = (SortedBuffer)SortedOplogSetImpl.this.unflushed.peekLast();
                        }
                    } else {
                        this.buffer.defer(action);
                    }
                }
                finally {
                    SortedOplogSetImpl.this.rwlock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                this.handleError(e, aborted);
            }
        }

        @Override
        public void abortBeforeRun() {
            this.handler.complete();
            SortedOplogSetImpl.this.factory.getConfiguration().getStatistics().getFlush().end(this.start);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleError(Exception e, AtomicBoolean aborted) {
            if (this.lockOrAbort(aborted)) {
                try {
                    SortedOplogSetImpl.this.unflushed.removeFirstOccurrence(this.buffer);
                }
                finally {
                    SortedOplogSetImpl.this.rwlock.writeLock().unlock();
                }
            }
            this.handler.error(e);
            SortedOplogSetImpl.this.factory.getConfiguration().getStatistics().getFlush().error(this.start);
        }

        private SortedOplog writeBuffer(SortedBuffer<Integer> sb, AtomicBoolean aborted) throws IOException {
            File f = SortedOplogSetImpl.this.compactor.getFileset().getNextFilename();
            if (logger.isDebugEnabled()) {
                logger.debug("{}Flushing buffer {} to {}", SortedOplogSetImpl.this.logPrefix, sb, f);
            }
            SortedOplog so = SortedOplogSetImpl.this.factory.createSortedOplog(f);
            SortedOplog.SortedOplogWriter writer = so.createWriter();
            try {
                if (SortedOplogSetImpl.this.testErrorDuringFlush) {
                    throw new IOException("Flush error due to testErrorDuringFlush=true");
                }
                for (Map.Entry<byte[], byte[]> entry : sb.entries()) {
                    if (aborted.get()) {
                        writer.closeAndDelete();
                        return null;
                    }
                    writer.append(entry.getKey(), entry.getValue());
                }
                this.checkTestDelay();
                writer.close(this.buffer.getMetadata());
                return so;
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Encountered error while flushing buffer {}", SortedOplogSetImpl.this.logPrefix, sb, e);
                }
                writer.closeAndDelete();
                throw e;
            }
        }

        private void checkTestDelay() {
            if (SortedOplogSetImpl.this.testDelayDuringFlush != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}Waiting for testDelayDuringFlush", SortedOplogSetImpl.this.logPrefix);
                    }
                    SortedOplogSetImpl.this.testDelayDuringFlush.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private boolean lockOrAbort(AtomicBoolean abort) {
            try {
                while (!abort.get()) {
                    if (!SortedOplogSetImpl.this.rwlock.writeLock().tryLock(10L, TimeUnit.MILLISECONDS)) continue;
                    return true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
    }
}

