/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import java.util.concurrent.atomic.AtomicInteger;

public class TrackedReference<T> {
    private final T ref;
    private final AtomicInteger uses;

    public static <T> void decrementAll(Iterable<TrackedReference<T>> refs) {
        for (TrackedReference<T> tr : refs) {
            tr.decrement();
        }
    }

    public TrackedReference(T ref) {
        this.ref = ref;
        this.uses = new AtomicInteger(0);
    }

    public T get() {
        return this.ref;
    }

    public int uses() {
        return this.uses.get();
    }

    public boolean inUse() {
        return this.uses() > 0;
    }

    public T getAndIncrement() {
        this.increment();
        return this.ref;
    }

    public int increment() {
        int val = this.uses.incrementAndGet();
        assert (val >= 1);
        return val;
    }

    public int decrement() {
        int val = this.uses.decrementAndGet();
        assert (val >= 0);
        return val;
    }

    public String toString() {
        return this.uses() + ": " + this.ref.toString();
    }
}

