/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog.nofile;

import com.gemstone.gemfire.internal.cache.persistence.soplog.AbstractSortedReader;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedBuffer;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplog;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogFactory;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;

public class NoFileSortedOplog
implements SortedOplog {
    private final SortedOplogFactory.SortedOplogConfiguration config;
    private final AtomicReference<NavigableMap<byte[], byte[]>> data;
    private final EnumMap<SortedReader.Metadata, byte[]> metadata;
    private final NoFileStatistics stats;

    public NoFileSortedOplog(SortedOplogFactory.SortedOplogConfiguration config) {
        this.config = config;
        this.data = new AtomicReference();
        this.metadata = new EnumMap(SortedReader.Metadata.class);
        this.stats = new NoFileStatistics();
    }

    @Override
    public SortedOplog.SortedOplogReader createReader() throws IOException {
        return new NoFileReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedOplog.SortedOplogWriter createWriter() throws IOException {
        EnumMap<SortedReader.Metadata, byte[]> enumMap = this.metadata;
        synchronized (enumMap) {
            this.metadata.clear();
        }
        this.data.set(new ConcurrentSkipListMap(this.config.getComparator()));
        return new NoFileWriter();
    }

    private class NoFileStatistics
    implements SortedReader.SortedStatistics {
        private long keys;
        private double avgKeySize;
        private double avgValueSize;

        private NoFileStatistics() {
        }

        private synchronized void add(int keyLength, int valueLength) {
            this.avgKeySize = ((double)keyLength + (double)this.keys * this.avgKeySize) / (double)(this.keys + 1L);
            this.avgValueSize = ((double)keyLength + (double)this.keys * this.avgValueSize) / (double)(this.keys + 1L);
            ++this.keys;
        }

        @Override
        public synchronized long keyCount() {
            return this.keys;
        }

        @Override
        public byte[] firstKey() {
            return (byte[])((NavigableMap)NoFileSortedOplog.this.data.get()).firstKey();
        }

        @Override
        public byte[] lastKey() {
            return (byte[])((NavigableMap)NoFileSortedOplog.this.data.get()).lastKey();
        }

        @Override
        public synchronized double avgKeySize() {
            return this.avgKeySize;
        }

        @Override
        public synchronized double avgValueSize() {
            return this.avgValueSize;
        }

        @Override
        public void close() {
        }
    }

    private class NoFileReader
    extends AbstractSortedReader
    implements SortedOplog.SortedOplogReader {
        private final SortedOplog.BloomFilter bloom;
        private volatile boolean closed = false;

        public NoFileReader() {
            this.bloom = new SortedOplog.BloomFilter(){

                @Override
                public boolean mightContain(byte[] key2) {
                    return ((NavigableMap)NoFileSortedOplog.this.data.get()).containsKey(key2);
                }
            };
        }

        @Override
        public boolean mightContain(byte[] key2) throws IOException {
            return this.bloom.mightContain(key2);
        }

        @Override
        public ByteBuffer read(byte[] key2) throws IOException {
            return ByteBuffer.wrap((byte[])((NavigableMap)NoFileSortedOplog.this.data.get()).get(key2));
        }

        @Override
        public SortedReader.SortedIterator<ByteBuffer> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive, boolean ascending, SortedReader.MetadataFilter filter) {
            if (filter == null || filter.accept((byte[])NoFileSortedOplog.this.metadata.get((Object)filter.getName()))) {
                NavigableMap subset;
                NavigableMap navigableMap = subset = ascending ? (NavigableMap)NoFileSortedOplog.this.data.get() : ((NavigableMap)NoFileSortedOplog.this.data.get()).descendingMap();
                if (from != null || to != null) {
                    subset = from == null ? subset.headMap(to, toInclusive) : (to == null ? subset.tailMap(from, fromInclusive) : subset.subMap(from, fromInclusive, to, toInclusive));
                }
                return new SortedBuffer.BufferIterator(subset.entrySet().iterator());
            }
            return new SortedBuffer.BufferIterator(Collections.emptyMap().entrySet().iterator());
        }

        @Override
        public SortedReader.SerializedComparator getComparator() {
            return (SortedReader.SerializedComparator)((NavigableMap)NoFileSortedOplog.this.data.get()).comparator();
        }

        @Override
        public SortedReader.SortedStatistics getStatistics() {
            return NoFileSortedOplog.this.stats;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public SortedOplog.BloomFilter getBloomFilter() {
            return this.bloom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getMetadata(SortedReader.Metadata name) {
            EnumMap enumMap = NoFileSortedOplog.this.metadata;
            synchronized (enumMap) {
                return (byte[])NoFileSortedOplog.this.metadata.get((Object)name);
            }
        }

        @Override
        public File getFile() {
            return new File(".");
        }

        @Override
        public String getFileName() {
            return "name";
        }

        @Override
        public long getModificationTimeStamp() throws IOException {
            return 0L;
        }

        @Override
        public void rename(String name) throws IOException {
        }

        @Override
        public void delete() throws IOException {
        }
    }

    private class NoFileWriter
    implements SortedOplog.SortedOplogWriter {
        private NoFileWriter() {
        }

        @Override
        public void append(byte[] key2, byte[] value2) throws IOException {
            if (((NavigableMap)NoFileSortedOplog.this.data.get()).put(key2, value2) == null) {
                NoFileSortedOplog.this.stats.add(key2.length, value2.length);
            }
        }

        @Override
        public void append(ByteBuffer key2, ByteBuffer value2) throws IOException {
            byte[] k = new byte[key2.remaining()];
            byte[] v = new byte[value2.remaining()];
            key2.get(k);
            value2.get(v);
            this.append(k, v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(EnumMap<SortedReader.Metadata, byte[]> meta) throws IOException {
            if (meta != null) {
                EnumMap enumMap = NoFileSortedOplog.this.metadata;
                synchronized (enumMap) {
                    NoFileSortedOplog.this.metadata.putAll(meta);
                }
            }
        }

        @Override
        public void closeAndDelete() throws IOException {
            ((NavigableMap)NoFileSortedOplog.this.data.get()).clear();
            NoFileSortedOplog.this.data.set(null);
        }
    }
}

