/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.snapshot;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ExportedRegistry {
    private final Map<Integer, PdxType> types;
    private final Map<Integer, EnumInfo> enums;

    public ExportedRegistry() {
        this.types = new HashMap<Integer, PdxType>();
        this.enums = new HashMap<Integer, EnumInfo>();
    }

    public ExportedRegistry(TypeRegistry tr) {
        this.types = new HashMap<Integer, PdxType>(tr.typeMap());
        this.enums = new HashMap<Integer, EnumInfo>(tr.enumMap());
    }

    public Map<Integer, PdxType> types() {
        return this.types;
    }

    public Map<Integer, EnumInfo> enums() {
        return this.enums;
    }

    public void addType(int id, PdxType type) {
        this.types.put(id, type);
    }

    public void addEnum(int id, EnumInfo info) {
        this.enums.put(id, info);
    }

    public PdxType getType(int id) {
        return this.types.get(id);
    }

    public EnumInfo getEnum(int id) {
        return this.enums.get(id);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.types.size());
        for (Map.Entry<Integer, PdxType> entry : this.types.entrySet()) {
            DataSerializer.writeObject(entry.getValue(), out);
        }
        out.writeInt(this.enums.size());
        for (Map.Entry<Integer, Object> entry : this.enums.entrySet()) {
            out.writeInt(entry.getKey());
            DataSerializer.writeObject(entry.getValue(), out);
        }
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int typeCount = in.readInt();
        for (int i = 0; i < typeCount; ++i) {
            PdxType type = (PdxType)DataSerializer.readObject(in);
            this.types.put(type.getTypeId(), type);
        }
        int enumCount = in.readInt();
        for (int i = 0; i < enumCount; ++i) {
            int id = in.readInt();
            EnumInfo ei = (EnumInfo)DataSerializer.readObject(in);
            this.enums.put(id, ei);
        }
    }
}

