/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.snapshot;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionMembershipListener;
import com.gemstone.gemfire.cache.util.RegionMembershipListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ProcessorKeeper21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public class FlowController {
    private static final int MAX_PERMITS = 0x3FFFFFFF;
    private static final FlowController instance = new FlowController();
    private final ProcessorKeeper21 processors = new ProcessorKeeper21();

    public static FlowController getInstance() {
        return instance;
    }

    private FlowController() {
    }

    public <K, V> Window create(Region<K, V> region, DistributedMember sink, int windowSize) {
        WindowImpl<K, V> w = new WindowImpl<K, V>(region, sink, windowSize);
        int id = this.processors.put(w);
        ((WindowImpl)w).setWindowId(id);
        return w;
    }

    public void sendAck(DM dmgr, DistributedMember member, int windowId, String packetId) {
        if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
            InternalDistributedSystem.getLoggerI18n().fine("SNP: Sending ACK for packet " + packetId + " on window " + windowId + " to member " + member);
        }
        if (dmgr.getDistributionManagerId().equals(member)) {
            WindowImpl win = (WindowImpl)this.processors.retrieve(windowId);
            if (win != null) {
                win.ack(packetId);
            }
        } else {
            FlowControlAckMessage ack = new FlowControlAckMessage(windowId, packetId);
            ack.setRecipient((InternalDistributedMember)member);
            dmgr.putOutgoing(ack);
        }
    }

    public void sendAbort(DM dmgr, int windowId, DistributedMember member) {
        if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
            InternalDistributedSystem.getLoggerI18n().fine("SNP: Sending ABORT to member " + member + " for window " + windowId);
        }
        if (dmgr.getDistributionManagerId().equals(member)) {
            WindowImpl win = (WindowImpl)this.processors.retrieve(windowId);
            if (win != null) {
                win.abort();
            }
        } else {
            FlowControlAbortMessage abort = new FlowControlAbortMessage(windowId);
            abort.setRecipient((InternalDistributedMember)member);
            dmgr.putOutgoing(abort);
        }
    }

    public static class FlowControlAckMessage
    extends DistributionMessage {
        private int windowId;
        private String packetId;

        public FlowControlAckMessage(int windowId, String packetId) {
            this.windowId = windowId;
            this.packetId = packetId;
        }

        public FlowControlAckMessage() {
        }

        @Override
        public int getDSFID() {
            return 2136;
        }

        @Override
        public int getProcessorType() {
            return 73;
        }

        @Override
        protected void process(DistributionManager dm) {
            WindowImpl win;
            if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
                InternalDistributedSystem.getLoggerI18n().fine("SNP: Received ACK for packet " + this.packetId + " on window " + this.windowId + " from member " + this.getSender());
            }
            if ((win = (WindowImpl)FlowController.getInstance().processors.retrieve(this.windowId)) != null) {
                win.ack(this.packetId);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.windowId = in.readInt();
            this.packetId = InternalDataSerializer.readString(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.windowId);
            InternalDataSerializer.writeString(this.packetId, out);
        }
    }

    public static class FlowControlAbortMessage
    extends DistributionMessage {
        private int windowId;

        public FlowControlAbortMessage(int windowId) {
            this.windowId = windowId;
        }

        public FlowControlAbortMessage() {
        }

        @Override
        public int getDSFID() {
            return 2136;
        }

        @Override
        public int getProcessorType() {
            return 73;
        }

        @Override
        protected void process(DistributionManager dm) {
            WindowImpl win;
            if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
                InternalDistributedSystem.getLoggerI18n().fine("SNP: Received ABORT on window " + this.windowId + " from member " + this.getSender());
            }
            if ((win = (WindowImpl)FlowController.getInstance().processors.retrieve(this.windowId)) != null) {
                win.abort();
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.windowId = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.windowId);
        }
    }

    private static class WindowImpl<K, V>
    implements Window {
        private final Semaphore permits;
        private final AtomicBoolean abort;
        private final Region<K, V> region;
        private final RegionMembershipListener<K, V> crash;
        private volatile int windowId;

        public WindowImpl(Region<K, V> region, final DistributedMember sink, int size2) {
            this.permits = new Semaphore(size2);
            this.abort = new AtomicBoolean(false);
            this.region = region;
            this.crash = new RegionMembershipListenerAdapter<K, V>(){

                @Override
                public void afterRemoteRegionCrash(RegionEvent<K, V> event) {
                    if (event.getDistributedMember().equals(sink)) {
                        if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
                            InternalDistributedSystem.getLoggerI18n().fine("SNP: " + sink + " has crashed, closing window");
                        }
                        WindowImpl.this.abort();
                    }
                }
            };
            region.getAttributesMutator().addCacheListener(this.crash);
        }

        @Override
        public void close() {
            instance.processors.remove(this.windowId);
            this.region.getAttributesMutator().removeCacheListener(this.crash);
            this.permits.release(0x3FFFFFFF);
        }

        @Override
        public int getWindowId() {
            return this.windowId;
        }

        @Override
        public boolean isAborted() {
            return this.abort.get();
        }

        @Override
        public boolean isOpen() {
            return this.permits.availablePermits() > 0;
        }

        @Override
        public void waitForOpening() throws InterruptedException {
            this.permits.acquire();
        }

        private void ack(String packetId) {
            this.permits.release();
        }

        private void abort() {
            this.abort.set(true);
            this.permits.release(0x3FFFFFFF);
        }

        private void setWindowId(int id) {
            this.windowId = id;
        }
    }

    public static interface Window {
        public int getWindowId();

        public boolean isAborted();

        public boolean isOpen();

        public void waitForOpening() throws InterruptedException;

        public void close();
    }
}

