/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.snapshot;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ProxyRegion;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.snapshot.ClientExporter;
import com.gemstone.gemfire.internal.cache.snapshot.GFSnapshot;
import com.gemstone.gemfire.internal.cache.snapshot.LocalExporter;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotFileMapper;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotOptionsImpl;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotPacket;
import com.gemstone.gemfire.internal.cache.snapshot.WindowedExporter;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class RegionSnapshotServiceImpl<K, V>
implements RegionSnapshotService<K, V> {
    private static final int IMPORT_CONCURRENCY = Integer.getInteger("gemfire.RegionSnapshotServiceImpl.IMPORT_CONCURRENCY", 10);
    static final int BUFFER_SIZE = Integer.getInteger("gemfire.RegionSnapshotServiceImpl.BUFFER_SIZE", 0x100000);
    static final SnapshotFileMapper LOCAL_MAPPER = new SnapshotFileMapper(){
        private static final long serialVersionUID = 1L;

        @Override
        public File mapExportPath(DistributedMember member, File snapshot) {
            return snapshot;
        }

        @Override
        public File[] mapImportPath(DistributedMember member, File snapshot) {
            if (!snapshot.isDirectory()) {
                return new File[]{snapshot};
            }
            return snapshot.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.isDirectory();
                }
            });
        }
    };
    private final Region<K, V> region;

    public RegionSnapshotServiceImpl(Region<K, V> region) {
        this.region = region;
    }

    @Override
    public SnapshotOptions<K, V> createOptions() {
        return new SnapshotOptionsImpl();
    }

    @Override
    public void save(File snapshot, SnapshotOptions.SnapshotFormat format) throws IOException {
        this.save(snapshot, format, this.createOptions());
    }

    @Override
    public void save(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException {
        if (this.region.getCache().getCacheTransactionManager().exists()) {
            throw new IllegalStateException("Unable to save snapshot during a transaction");
        }
        if (this.shouldRunInParallel(options)) {
            this.snapshotInParallel(new ParallelArgs<K, V>(snapshot, format, options), new ParallelExportFunction());
            return;
        }
        this.exportOnMember(snapshot, format, options);
    }

    @Override
    public void load(File snapshot, SnapshotOptions.SnapshotFormat format) throws IOException, ClassNotFoundException {
        this.load(snapshot, format, this.createOptions());
    }

    @Override
    public void load(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException, ClassNotFoundException {
        if (this.shouldRunInParallel(options)) {
            this.snapshotInParallel(new ParallelArgs<K, V>(snapshot, format, options), new ParallelImportFunction());
            return;
        }
        this.importOnMember(snapshot, format, options);
    }

    private boolean shouldRunInParallel(SnapshotOptions<K, V> options) {
        return ((SnapshotOptionsImpl)options).isParallelMode() && this.region.getAttributes().getDataPolicy().withPartitioning() && !(this.region instanceof LocalDataSet);
    }

    private void snapshotInParallel(ParallelArgs<K, V> args, Function fn) throws IOException {
        try {
            ResultCollector<?, ?> rc = FunctionService.onRegion(this.region).withArgs(args).execute(fn);
            List result = (List)rc.getResult();
            for (Object obj : result) {
                if (!(obj instanceof Exception)) continue;
                throw new IOException((Exception)obj);
            }
            return;
        }
        catch (FunctionException e) {
            throw new IOException(e);
        }
    }

    private void importOnMember(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException, ClassNotFoundException {
        final LocalRegion local2 = RegionSnapshotServiceImpl.getLocalRegion(this.region);
        if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
            InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_IMPORT_BEGIN_0, this.region.getName());
        }
        long count = 0L;
        long bytes = 0L;
        long start = CachePerfStats.getStatTime();
        LinkedList puts = new LinkedList();
        GFSnapshot.GFSnapshotImporter in = new GFSnapshot.GFSnapshotImporter(snapshot);
        try {
            SnapshotPacket.SnapshotRecord record;
            int bufferSize = 0;
            HashMap buffer = new HashMap();
            while ((record = in.readSnapshotRecord()) != null) {
                bytes += (long)record.getSize();
                Object key2 = record.getKeyObject();
                Object val = Token.INVALID;
                if (record.hasValue()) {
                    byte[] data = record.getValue();
                    val = data.length > 0 && data[0] == 46 ? record.getValueObject() : CachedDeserializableFactory.create(record.getValue());
                }
                if (!this.includeEntry(options, key2, val)) continue;
                buffer.put(key2, (Token.Invalid)val);
                ++count;
                if ((bufferSize += record.getSize()) <= BUFFER_SIZE) continue;
                if (puts.size() == IMPORT_CONCURRENCY) {
                    ((Future)puts.removeFirst()).get();
                }
                final HashMap copy = new HashMap(buffer);
                Future<?> f = GemFireCacheImpl.getExisting("Importing region from snapshot").getDistributionManager().getWaitingThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        local2.basicImportPutAll(copy, true);
                    }
                });
                puts.addLast(f);
                buffer.clear();
                bufferSize = 0;
            }
            if (!buffer.isEmpty()) {
                local2.basicImportPutAll(buffer, true);
            }
            while (!puts.isEmpty()) {
                ((Future)puts.removeFirst()).get();
            }
            if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
                InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_IMPORT_END_0_1_2_3, new Object[]{count, bytes, this.region.getName(), snapshot});
            }
        }
        catch (InterruptedException e) {
            while (!puts.isEmpty()) {
                ((Future)puts.removeFirst()).cancel(true);
            }
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            while (!puts.isEmpty()) {
                ((Future)puts.removeFirst()).cancel(true);
            }
            throw new IOException(e);
        }
        finally {
            in.close();
            local2.getCachePerfStats().endImport(count, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOnMember(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) throws IOException {
        LocalRegion local2 = RegionSnapshotServiceImpl.getLocalRegion(this.region);
        Exporter<K, V> exp = RegionSnapshotServiceImpl.createExporter(this.region, options);
        if (InternalDistributedSystem.getLoggerI18n().fineEnabled()) {
            InternalDistributedSystem.getLoggerI18n().fine("Writing to snapshot " + snapshot.getAbsolutePath());
        }
        long count = 0L;
        long start = CachePerfStats.getStatTime();
        GFSnapshot.SnapshotWriter writer = GFSnapshot.create(snapshot, this.region.getFullPath());
        try {
            if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
                InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_EXPORT_BEGIN_0, this.region.getName());
            }
            SnapshotWriterSink sink = new SnapshotWriterSink(writer);
            count = exp.export(this.region, sink, options);
            if (InternalDistributedSystem.getLoggerI18n().infoEnabled()) {
                InternalDistributedSystem.getLoggerI18n().info(LocalizedStrings.Snapshot_EXPORT_END_0_1_2_3, new Object[]{count, sink.getBytesWritten(), this.region.getName(), snapshot});
            }
        }
        finally {
            writer.snapshotComplete();
            local2.getCachePerfStats().endExport(count, start);
        }
    }

    private boolean includeEntry(SnapshotOptions<K, V> options, final K key2, final V val) {
        if (options.getFilter() != null) {
            Map.Entry entry = new Map.Entry<K, V>(){

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public K getKey() {
                    return key2;
                }

                @Override
                public V getValue() {
                    if (val instanceof CachedDeserializable) {
                        return ((CachedDeserializable)val).getDeserializedForReading();
                    }
                    return null;
                }
            };
            return options.getFilter().accept(entry);
        }
        return true;
    }

    static <K, V> Exporter<K, V> createExporter(Region<?, ?> region, SnapshotOptions<K, V> options) {
        String pool = region.getAttributes().getPoolName();
        if (pool != null) {
            return new ClientExporter(PoolManager.find(pool));
        }
        if (InternalDistributedSystem.getAnyInstance().isLoner() || region.getAttributes().getDataPolicy().equals(DataPolicy.NORMAL) || region.getAttributes().getDataPolicy().equals(DataPolicy.PRELOADED) || region instanceof LocalDataSet || ((SnapshotOptionsImpl)options).isParallelMode() && region.getAttributes().getDataPolicy().withPartitioning()) {
            return new LocalExporter();
        }
        return new WindowedExporter();
    }

    static LocalRegion getLocalRegion(Region<?, ?> region) {
        if (region instanceof LocalDataSet) {
            return ((LocalDataSet)region).getProxy();
        }
        if (region instanceof ProxyRegion) {
            return (LocalRegion)((ProxyRegion)region).getRealRegion();
        }
        return (LocalRegion)region;
    }

    private static class ParallelImportFunction<K, V>
    implements Function {
        private ParallelImportFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public void execute(FunctionContext context) {
            try {
                Region local2 = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)context);
                ParallelArgs args = (ParallelArgs)context.getArguments();
                File[] files = args.getOptions().getMapper().mapImportPath(local2.getCache().getDistributedSystem().getDistributedMember(), args.getFile());
                if (files != null) {
                    for (File f : files) {
                        if (f.isDirectory() || !f.exists()) {
                            throw new IOException(LocalizedStrings.Snapshot_INVALID_IMPORT_FILE.toLocalizedString(f));
                        }
                        local2.getSnapshotService().load(f, args.getFormat(), args.getOptions());
                    }
                }
                context.getResultSender().lastResult(Boolean.TRUE);
            }
            catch (Exception e) {
                context.getResultSender().sendException(e);
            }
        }

        @Override
        public String getId() {
            return "com.gemstone.gemfire.cache.snapshot.ParallelImport";
        }

        @Override
        public boolean optimizeForWrite() {
            return true;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }

    private static class ParallelExportFunction<K, V>
    implements Function {
        private ParallelExportFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public void execute(FunctionContext context) {
            try {
                Region local2 = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)context);
                ParallelArgs args = (ParallelArgs)context.getArguments();
                File f = args.getOptions().getMapper().mapExportPath(local2.getCache().getDistributedSystem().getDistributedMember(), args.getFile());
                if (f == null || f.isDirectory()) {
                    throw new IOException(LocalizedStrings.Snapshot_INVALID_EXPORT_FILE.toLocalizedString(f));
                }
                local2.getSnapshotService().save(f, args.getFormat(), args.getOptions());
                context.getResultSender().lastResult(Boolean.TRUE);
            }
            catch (Exception e) {
                context.getResultSender().sendException(e);
            }
        }

        @Override
        public String getId() {
            return "com.gemstone.gemfire.cache.snapshot.ParallelExport";
        }

        @Override
        public boolean optimizeForWrite() {
            return true;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }

    private static class ParallelArgs<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final File file;
        private final SnapshotOptions.SnapshotFormat format;
        private final SnapshotOptionsImpl<K, V> options;

        public ParallelArgs(File f, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) {
            this.file = f;
            this.format = format;
            this.options = (SnapshotOptionsImpl)options;
        }

        public File getFile() {
            return this.file;
        }

        public SnapshotOptions.SnapshotFormat getFormat() {
            return this.format;
        }

        public SnapshotOptionsImpl<K, V> getOptions() {
            return this.options;
        }
    }

    static final class ResultSenderSink
    implements ExportSink {
        private final ResultSender<SnapshotPacket.SnapshotRecord[]> sender;

        public ResultSenderSink(ResultSender<SnapshotPacket.SnapshotRecord[]> sender) {
            this.sender = sender;
        }

        @Override
        public void write(SnapshotPacket.SnapshotRecord ... records) throws IOException {
            this.sender.sendResult(records);
        }
    }

    static final class SnapshotWriterSink
    implements ExportSink {
        private final GFSnapshot.SnapshotWriter writer;
        private long bytes;

        public SnapshotWriterSink(GFSnapshot.SnapshotWriter writer) {
            this.writer = writer;
        }

        @Override
        public void write(SnapshotPacket.SnapshotRecord ... records) throws IOException {
            for (SnapshotPacket.SnapshotRecord rec : records) {
                this.writer.snapshotEntry(rec);
                this.bytes += (long)rec.getSize();
            }
        }

        public long getBytesWritten() {
            return this.bytes;
        }
    }

    public static interface Exporter<K, V> {
        public long export(Region<K, V> var1, ExportSink var2, SnapshotOptions<K, V> var3) throws IOException;
    }

    public static interface ExportSink {
        public void write(SnapshotPacket.SnapshotRecord ... var1) throws IOException;
    }
}

