/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.CopyException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.operations.QueryOperationContext;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.CqEntry;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FindVersionTagOperation;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.internal.sequencelog.EntryLogger;
import com.gemstone.gemfire.security.GemFireSecurityException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public abstract class BaseCommand
implements Command {
    protected static final Logger logger = LogService.getLogger();
    protected static final boolean zipValues = false;
    protected static final boolean APPLY_RETRIES = Boolean.getBoolean("gemfire.gateway.ApplyRetries");
    public static final byte[] OK_BYTES = new byte[]{0};
    public static final int maximumChunkSize = Integer.getInteger("BridgeServer.MAXIMUM_CHUNK_SIZE", 100);
    private static boolean suppressIOExceptionLogging = Boolean.getBoolean("gemfire.bridge.suppressIOExceptionLogging");
    private static final int MAX_INCOMING_DATA = Integer.getInteger("BridgeServer.MAX_INCOMING_DATA", -1);
    private static final int MAX_INCOMING_MSGS = Integer.getInteger("BridgeServer.MAX_INCOMING_MSGS", -1);
    private static final Semaphore incomingDataLimiter;
    private static final Semaphore incomingMsgLimiter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(Message msg, ServerConnection servConn) {
        block32: {
            long start = DistributionStats.getStatTime();
            if (EntryLogger.isEnabled() && servConn != null) {
                EntryLogger.setSource(servConn.getMembershipID(), "c2s");
            }
            boolean shouldMasquerade = this.shouldMasqueradeForTx(msg, servConn);
            try {
                if (shouldMasquerade) {
                    GemFireCacheImpl cache = (GemFireCacheImpl)servConn.getCache();
                    InternalDistributedMember member = (InternalDistributedMember)servConn.getProxyID().getDistributedMember();
                    TXManagerImpl txMgr = cache.getTxManager();
                    TXStateProxy tx = null;
                    try {
                        tx = txMgr.masqueradeAs(msg, member, false);
                        this.cmdExecute(msg, servConn, start);
                        txMgr.unmasquerade(tx);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        txMgr.unmasquerade(tx);
                        throw throwable;
                    }
                }
                this.cmdExecute(msg, servConn, start);
            }
            catch (EOFException eof) {
                BaseCommand.handleEOFException(msg, servConn, eof);
                return;
            }
            catch (InterruptedIOException e) {
                BaseCommand.handleInterruptedIOException(msg, servConn, e);
                return;
            }
            catch (IOException e) {
                BaseCommand.handleIOException(msg, servConn, e);
                return;
            }
            catch (DistributedSystemDisconnectedException e) {
                BaseCommand.handleShutdownException(msg, servConn, e);
                return;
            }
            catch (PartitionOfflineException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (GemFireSecurityException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (CacheLoaderException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (CacheWriterException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (SerializationException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (CopyException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (TransactionException e) {
                BaseCommand.handleExceptionNoDisconnect(msg, servConn, e);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                BaseCommand.handleThrowable(msg, servConn, e);
            }
            finally {
                EntryLogger.clearSource();
            }
        }
    }

    protected boolean shouldMasqueradeForTx(Message msg, ServerConnection servConn) {
        return servConn.getClientVersion().compareTo(Version.GFE_66) >= 0 && msg.getTransactionId() > -1;
    }

    public boolean recoverVersionTagForRetriedOperation(EntryEventImpl clientEvent) {
        LocalRegion r = clientEvent.getRegion();
        VersionTag tag = r.findVersionTagForClientEvent(clientEvent.getEventId());
        if (tag == null && (r instanceof DistributedRegion || r instanceof PartitionedRegion)) {
            tag = FindVersionTagOperation.findVersionTag(r, clientEvent.getEventId(), false);
        }
        if (tag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("recovered version tag {} for replayed operation {}", tag, clientEvent.getEventId());
            }
            clientEvent.setVersionTag(tag);
        }
        return tag != null;
    }

    protected VersionTag findVersionTagsForRetriedBulkOp(LocalRegion r, EventID eventID) {
        VersionTag tag = r.findVersionTagForClientBulkOp(eventID);
        if (tag != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("recovered version tag {} for replayed bulk operation {}", tag, eventID);
            }
            return tag;
        }
        if (r instanceof DistributedRegion || r instanceof PartitionedRegion) {
            tag = FindVersionTagOperation.findVersionTag(r, eventID, true);
        }
        if (tag != null && logger.isDebugEnabled()) {
            logger.debug("recovered version tag {} for replayed bulk operation {}", tag, eventID);
        }
        return tag;
    }

    public abstract void cmdExecute(Message var1, ServerConnection var2, long var3) throws IOException, ClassNotFoundException, InterruptedException;

    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", servConn.getName(), origMsg.getTransactionId());
        }
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr2, byte nwHop) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr2.getMetadataVersion(), nwHop});
        replyMsg.send(servConn);
        pr2.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", servConn.getName(), origMsg.getTransactionId());
        }
    }

    private static void handleEOFException(Message msg, ServerConnection servConn, Exception eof) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        boolean potentialModification = servConn.getPotentialModification();
        if (!crHelper.isShutdown()) {
            if (potentialModification) {
                stats.incAbandonedWriteRequests();
            } else {
                stats.incAbandonedReadRequests();
            }
            if (!suppressIOExceptionLogging) {
                if (potentialModification) {
                    int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_EOFEXCEPTION_DURING_A_WRITE_OPERATION_ON_REGION__1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}));
                } else {
                    logger.info(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_CONNECTION_DISCONNECT_DETECTED_BY_EOF, servConn.getName()));
                }
            }
        }
        servConn.setFlagProcessMessagesAsFalse();
    }

    private static void handleInterruptedIOException(Message msg, ServerConnection servConn, Exception e) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        if (!crHelper.isShutdown() && servConn.isOpen() && !suppressIOExceptionLogging && logger.isDebugEnabled()) {
            logger.debug("Aborted message due to interrupt: {}", e.getMessage(), e);
        }
        servConn.setFlagProcessMessagesAsFalse();
    }

    private static void handleIOException(Message msg, ServerConnection servConn, Exception e) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        boolean potentialModification = servConn.getPotentialModification();
        if (!crHelper.isShutdown() && servConn.isOpen() && !suppressIOExceptionLogging) {
            if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_IOEXCEPTION_DURING_OPERATION_FOR_REGION_1_KEY_2_MESSID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), (Throwable)e);
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_IOEXCEPTION, servConn.getName()), (Throwable)e);
            }
        }
        servConn.setFlagProcessMessagesAsFalse();
    }

    private static void handleShutdownException(Message msg, ServerConnection servConn, Exception e) {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        boolean potentialModification = servConn.getPotentialModification();
        if (!crHelper.isShutdown()) {
            if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_SHUTDOWNEXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), (Throwable)e);
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_SHUTDOWNEXCEPTION, servConn.getName()), (Throwable)e);
            }
        }
        servConn.setFlagProcessMessagesAsFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleExceptionNoDisconnect(Message msg, ServerConnection servConn, Exception e) {
        block22: {
            boolean requiresResponse = servConn.getTransientFlag(2);
            boolean responded = servConn.getTransientFlag(1);
            boolean requiresChunkedResponse = servConn.getTransientFlag(3);
            boolean potentialModification = servConn.getPotentialModification();
            boolean wroteExceptionResponse = false;
            try {
                block21: {
                    int transId;
                    try {
                        if (requiresResponse && !responded) {
                            if (requiresChunkedResponse) {
                                BaseCommand.writeChunkedException(msg, e, false, servConn);
                            } else {
                                BaseCommand.writeException(msg, e, false, servConn);
                            }
                            wroteExceptionResponse = true;
                            servConn.setAsTrue(1);
                        }
                        if (!potentialModification) break block21;
                        int n = transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                    }
                    catch (Throwable throwable) {
                        if (potentialModification) {
                            int transId2;
                            int n = transId2 = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                            if (!wroteExceptionResponse) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId2}), (Throwable)e);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("{}: Exception during operation on region: {} key: {} messageId: {}", servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId2, e);
                            }
                        } else if (!wroteExceptionResponse) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("{}: Exception: {}", servConn.getName(), e.getMessage(), e);
                        }
                        throw throwable;
                    }
                    if (!wroteExceptionResponse) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), (Throwable)e);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("{}: Exception during operation on region: {} key: {} messageId: {}", servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId, e);
                    }
                    break block22;
                }
                if (!wroteExceptionResponse) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("{}: Exception: {}", servConn.getName(), e.getMessage(), e);
                }
            }
            catch (IOException ioe) {
                if (!logger.isDebugEnabled()) break block22;
                logger.debug("{}: Unexpected IOException writing exception: {}", servConn.getName(), ioe.getMessage(), ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleThrowable(Message msg, ServerConnection servConn, Throwable th) {
        boolean requiresResponse = servConn.getTransientFlag(2);
        boolean responded = servConn.getTransientFlag(1);
        boolean requiresChunkedResponse = servConn.getTransientFlag(3);
        boolean potentialModification = servConn.getPotentialModification();
        try {
            block20: {
                try {
                    if (th instanceof Error) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_ERROR_ON_SERVER, servConn.getName()), th);
                    }
                    if (!requiresResponse || responded) break block20;
                    if (requiresChunkedResponse) {
                        BaseCommand.writeChunkedException(msg, th, false, servConn);
                    } else {
                        BaseCommand.writeException(msg, th, false, servConn);
                    }
                    servConn.setAsTrue(1);
                }
                catch (Throwable throwable) {
                    if (!(th instanceof Error) && !(th instanceof CancelException)) {
                        if (potentialModification) {
                            int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), th);
                        } else {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), th);
                        }
                    }
                    throw throwable;
                }
            }
            if (th instanceof Error) {
            } else if (th instanceof CancelException) {
            } else if (potentialModification) {
                int transId = msg != null ? msg.getTransactionId() : Integer.MIN_VALUE;
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION_DURING_OPERATION_ON_REGION_1_KEY_2_MESSAGEID_3, new Object[]{servConn.getName(), servConn.getModRegion(), servConn.getModKey(), transId}), th);
            } else {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), th);
            }
        }
        catch (IOException ioe) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Unexpected IOException writing exception: {}", servConn.getName(), ioe.getMessage(), ioe);
            }
        }
        finally {
            servConn.setFlagProcessMessagesAsFalse();
        }
    }

    protected static void writeChunkedException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn) throws IOException {
        BaseCommand.writeChunkedException(origMsg, e, isSevere, servConn, servConn.getChunkedResponseMessage());
    }

    protected static void writeChunkedException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn, ChunkedMessage originalReponse) throws IOException {
        BaseCommand.writeChunkedException(origMsg, e, isSevere, servConn, originalReponse, 2);
    }

    protected static void writeChunkedException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn, ChunkedMessage originalReponse, int numOfParts) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setServerConnection(servConn);
        if (originalReponse.headerHasBeenSent()) {
            chunkedResponseMsg.setNumberOfParts(numOfParts);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numOfParts);
            chunkedResponseMsg.addObjPart(e);
            if (numOfParts == 2) {
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", servConn.getName(), e.getMessage(), e);
            }
        } else {
            chunkedResponseMsg.setMessageType(2);
            chunkedResponseMsg.setNumberOfParts(numOfParts);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numOfParts);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            if (numOfParts == 2) {
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", servConn.getName(), e.getMessage(), e);
            }
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    public static String getExceptionTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    protected static void writeException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn) throws IOException {
        BaseCommand.writeException(origMsg, 2, e, isSevere, servConn);
    }

    protected static void writeException(Message origMsg, int msgType, Throwable e, boolean isSevere, ServerConnection servConn) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(msgType);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        if (isSevere) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            logger.fatal(LocalizedMessage.create(LocalizedStrings.BaseCommand_SEVERE_CACHE_EXCEPTION_0, msg));
        }
        errorMsg.addObjPart(e);
        errorMsg.addStringPart(BaseCommand.getExceptionTrace(e));
        errorMsg.send(servConn);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Wrote exception: {}", servConn.getName(), e.getMessage(), e);
        }
    }

    protected static void writeErrorResponse(Message origMsg, int messageType, ServerConnection servConn) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(messageType);
        errorMsg.setNumberOfParts(1);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addStringPart(LocalizedStrings.BaseCommand_INVALID_DATA_RECEIVED_PLEASE_SEE_THE_CACHE_SERVER_LOG_FILE_FOR_ADDITIONAL_DETAILS.toLocalizedString());
        errorMsg.send(servConn);
    }

    protected static void writeErrorResponse(Message origMsg, int messageType, String msg, ServerConnection servConn) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(messageType);
        errorMsg.setNumberOfParts(1);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addStringPart(msg);
        errorMsg.send(servConn);
    }

    protected static void writeRegionDestroyedEx(Message msg, String regionName, String title, ServerConnection servConn) throws IOException {
        String reason = servConn.getName() + ": Region named " + regionName + title;
        RegionDestroyedException ex = new RegionDestroyedException(reason, regionName);
        if (servConn.getTransientFlag(3)) {
            BaseCommand.writeChunkedException(msg, ex, false, servConn);
        } else {
            BaseCommand.writeException(msg, ex, false, servConn);
        }
    }

    protected static void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        if (callbackArg == null) {
            responseMsg.setNumberOfParts(1);
        } else {
            responseMsg.setNumberOfParts(2);
        }
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.flush();
    }

    protected static void writeResponseWithRefreshMetadata(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn, PartitionedRegion pr2, byte nwHop) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        if (callbackArg == null) {
            responseMsg.setNumberOfParts(2);
        } else {
            responseMsg.setNumberOfParts(3);
        }
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        responseMsg.addBytesPart(new byte[]{pr2.getMetadataVersion(), nwHop});
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.flush();
    }

    protected static void writeResponseWithFunctionAttribute(byte[] data, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.setNumberOfParts(1);
        responseMsg.addBytesPart(data);
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.flush();
    }

    protected static void checkForInterrupt(ServerConnection servConn, Exception e) throws InterruptedException, InterruptedIOException {
        servConn.getCachedRegionHelper().checkCancelInProgress(e);
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof InterruptedIOException) {
            throw (InterruptedIOException)e;
        }
    }

    protected static void writeQueryResponseChunk(Object queryResponseChunk, CollectionType collectionType, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage queryResponseMsg = servConn.getQueryResponseMessage();
        queryResponseMsg.setNumberOfParts(2);
        queryResponseMsg.setLastChunk(lastChunk);
        queryResponseMsg.addObjPart(collectionType, false);
        queryResponseMsg.addObjPart(queryResponseChunk, false);
        queryResponseMsg.sendChunk(servConn);
    }

    protected static void writeQueryResponseException(Message origMsg, Throwable e, boolean isSevere, ServerConnection servConn) throws IOException {
        ChunkedMessage queryResponseMsg = servConn.getQueryResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (queryResponseMsg.headerHasBeenSent()) {
            queryResponseMsg.setServerConnection(servConn);
            queryResponseMsg.setNumberOfParts(2);
            queryResponseMsg.setLastChunkAndNumParts(true, 2);
            queryResponseMsg.addObjPart(e);
            queryResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", servConn.getName(), e.getMessage(), e);
            }
            queryResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setServerConnection(servConn);
            chunkedResponseMsg.setMessageType(2);
            chunkedResponseMsg.setNumberOfParts(2);
            chunkedResponseMsg.setLastChunkAndNumParts(true, 2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", servConn.getName(), e.getMessage(), e);
            }
            chunkedResponseMsg.sendChunk(servConn);
        }
    }

    protected static void writeChunkedErrorResponse(Message origMsg, int messageType, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug(servConn.getName() + ": Sending error message header type: " + messageType + " transaction: " + origMsg.getTransactionId());
        }
        chunkedResponseMsg.setMessageType(messageType);
        chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
        chunkedResponseMsg.sendHeader();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message chunk: {}", servConn.getName(), message);
        }
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(true);
        chunkedResponseMsg.addStringPart(message);
        chunkedResponseMsg.sendChunk(servConn);
    }

    protected static void writeFunctionResponseException(Message origMsg, int messageType, String message, ServerConnection servConn, Throwable e) throws IOException {
        ChunkedMessage functionResponseMsg = servConn.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (functionResponseMsg.headerHasBeenSent()) {
            functionResponseMsg.setServerConnection(servConn);
            functionResponseMsg.setNumberOfParts(2);
            functionResponseMsg.setLastChunkAndNumParts(true, 2);
            functionResponseMsg.addObjPart(e);
            functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: {}", servConn.getName(), e.getMessage(), e);
            }
            functionResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setServerConnection(servConn);
            chunkedResponseMsg.setMessageType(messageType);
            chunkedResponseMsg.setNumberOfParts(2);
            chunkedResponseMsg.setLastChunkAndNumParts(true, 2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addObjPart(e);
            chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: {}", servConn.getName(), e.getMessage(), e);
            }
            chunkedResponseMsg.sendChunk(servConn);
        }
    }

    protected static void writeFunctionResponseError(Message origMsg, int messageType, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage functionResponseMsg = servConn.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        if (functionResponseMsg.headerHasBeenSent()) {
            functionResponseMsg.setNumberOfParts(1);
            functionResponseMsg.setLastChunk(true);
            functionResponseMsg.addStringPart(message);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending Error chunk while reply in progress: {}", servConn.getName(), message);
            }
            functionResponseMsg.sendChunk(servConn);
        } else {
            chunkedResponseMsg.setMessageType(messageType);
            chunkedResponseMsg.setNumberOfParts(1);
            chunkedResponseMsg.setLastChunk(true);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            chunkedResponseMsg.addStringPart(message);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending Error chunk: {}", servConn.getName(), message);
            }
            chunkedResponseMsg.sendChunk(servConn);
        }
    }

    protected static void writeKeySetErrorResponse(Message origMsg, int messageType, String message, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getKeySetResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message header type: {} transaction: {}", servConn.getName(), messageType, origMsg.getTransactionId());
        }
        chunkedResponseMsg.setMessageType(messageType);
        chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
        chunkedResponseMsg.sendHeader();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending error message chunk: {}", servConn.getName(), message);
        }
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(true);
        chunkedResponseMsg.addStringPart(message);
        chunkedResponseMsg.sendChunk(servConn);
    }

    static Message readRequest(ServerConnection servConn) {
        Message requestMsg = null;
        try {
            requestMsg = servConn.getRequestMessage();
            requestMsg.recv(servConn, MAX_INCOMING_DATA, incomingDataLimiter, MAX_INCOMING_MSGS, incomingMsgLimiter);
            return requestMsg;
        }
        catch (EOFException eof) {
            BaseCommand.handleEOFException(null, servConn, eof);
        }
        catch (InterruptedIOException e) {
            BaseCommand.handleInterruptedIOException(null, servConn, e);
        }
        catch (IOException e) {
            BaseCommand.handleIOException(null, servConn, e);
        }
        catch (DistributedSystemDisconnectedException e) {
            BaseCommand.handleShutdownException(null, servConn, e);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            BaseCommand.handleThrowable(null, servConn, e);
        }
        return requestMsg;
    }

    protected static void fillAndSendRegisterInterestResponseChunks(LocalRegion region, Object riKey, int interestType2, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        BaseCommand.fillAndSendRegisterInterestResponseChunks(region, riKey, interestType2, false, policy, servConn);
    }

    protected static void fillAndSendRegisterInterestResponseChunks(LocalRegion region, Object riKey, int interestType2, boolean serializeValues, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (policy.isNone()) {
            BaseCommand.sendRegisterInterestResponseChunk(region, riKey, new ArrayList(), true, servConn);
            return;
        }
        if (policy.isKeysValues() && servConn.getClientVersion().compareTo(Version.GFE_80) >= 0) {
            BaseCommand.handleKeysValuesPolicy(region, riKey, interestType2, serializeValues, servConn);
            return;
        }
        if (riKey instanceof List) {
            BaseCommand.handleList(region, (List)riKey, policy, servConn);
            return;
        }
        if (!(riKey instanceof String)) {
            BaseCommand.handleSingleton(region, riKey, policy, servConn);
            return;
        }
        switch (interestType2) {
            case 3: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 2: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 1: {
                String regEx = (String)riKey;
                if (regEx.equals(".*")) {
                    BaseCommand.handleAllKeys(region, policy, servConn);
                    break;
                }
                BaseCommand.handleRegEx(region, regEx, policy, servConn);
                break;
            }
            case 0: {
                if (riKey.equals("ALL_KEYS")) {
                    BaseCommand.handleAllKeys(region, policy, servConn);
                    break;
                }
                BaseCommand.handleSingleton(region, riKey, policy, servConn);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_UNKNOWN_INTEREST_TYPE.toLocalizedString());
            }
        }
    }

    private static void handleKeysValuesPolicy(LocalRegion region, Object riKey, int interestType2, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (riKey instanceof List) {
            BaseCommand.handleKVList(region, (List)riKey, serializeValues, servConn);
            return;
        }
        if (!(riKey instanceof String)) {
            BaseCommand.handleKVSingleton(region, riKey, serializeValues, servConn);
            return;
        }
        switch (interestType2) {
            case 3: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 2: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_NOT_YET_SUPPORTED.toLocalizedString());
            }
            case 1: {
                String regEx = (String)riKey;
                if (regEx.equals(".*")) {
                    BaseCommand.handleKVAllKeys(region, null, serializeValues, servConn);
                    break;
                }
                BaseCommand.handleKVAllKeys(region, regEx, serializeValues, servConn);
                break;
            }
            case 0: {
                if (riKey.equals("ALL_KEYS")) {
                    BaseCommand.handleKVAllKeys(region, null, serializeValues, servConn);
                    break;
                }
                BaseCommand.handleKVSingleton(region, riKey, serializeValues, servConn);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.BaseCommand_UNKNOWN_INTEREST_TYPE.toLocalizedString());
            }
        }
    }

    protected static void sendRegisterInterestResponseChunk(Region region, Object riKey, ArrayList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        String regionName;
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        String string = regionName = region == null ? " null " : region.getFullPath();
        if (logger.isDebugEnabled()) {
            String str = servConn.getName() + ": Sending" + (lastChunk ? " last " : " ") + "register interest response chunk for region: " + regionName + " for keys: " + riKey + " chunk=<" + chunkedResponseMsg + ">";
            logger.debug(str);
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    private static boolean sendTombstonesInRIResults(ServerConnection servConn, InterestResultPolicy policy) {
        return policy == InterestResultPolicy.KEYS_VALUES && servConn.getClientVersion().compareTo(Version.GFE_80) >= 0;
    }

    private static void handleList(LocalRegion region, List keyList, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleListPR((PartitionedRegion)region, keyList, policy, servConn);
            return;
        }
        ArrayList newKeyList = new ArrayList(maximumChunkSize);
        if (region != null) {
            for (Object entryKey : keyList) {
                if (!region.containsKey(entryKey) && (!BaseCommand.sendTombstonesInRIResults(servConn, policy) || !region.containsTombstone(entryKey))) continue;
                BaseCommand.appendInterestResponseKey(region, keyList, entryKey, newKeyList, "list", servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, keyList, newKeyList, true, servConn);
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="Null value handled in sendNewRegisterInterestResponseChunk()")
    private static void handleKVSingleton(LocalRegion region, Object entryKey, boolean serializeValues, ServerConnection servConn) throws IOException {
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region == null ? true : region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null && (region.containsKey(entryKey) || region.containsTombstone(entryKey))) {
            EntryEventImpl versionHolder = EntryEventImpl.createVersionTagHolder();
            ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
            Object data = region.get(entryKey, null, true, true, true, id, versionHolder, true);
            VersionTag vt = versionHolder.getVersionTag();
            BaseCommand.updateValues(values, entryKey, data, vt);
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, entryKey, values, true, servConn);
    }

    private static void handleSingleton(LocalRegion region, Object entryKey, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        ArrayList keyList = new ArrayList(1);
        if (region != null && (region.containsKey(entryKey) || BaseCommand.sendTombstonesInRIResults(servConn, policy) && region.containsTombstone(entryKey))) {
            BaseCommand.appendInterestResponseKey(region, entryKey, entryKey, keyList, "individual", servConn);
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, entryKey, keyList, true, servConn);
    }

    private static void handleAllKeys(LocalRegion region, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        ArrayList keyList = new ArrayList(maximumChunkSize);
        if (region != null) {
            Iterator it = region.keySet(BaseCommand.sendTombstonesInRIResults(servConn, policy)).iterator();
            while (it.hasNext()) {
                BaseCommand.appendInterestResponseKey(region, "ALL_KEYS", it.next(), keyList, "ALL_KEYS", servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, "ALL_KEYS", keyList, true, servConn);
    }

    private static void handleKVAllKeys(LocalRegion region, String regex, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (region != null && region instanceof PartitionedRegion) {
            BaseCommand.handleKVKeysPR((PartitionedRegion)region, regex, serializeValues, servConn);
            return;
        }
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region == null ? true : region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null) {
            VersionTag versionTag = null;
            Object data = null;
            Pattern keyPattern = null;
            if (regex != null) {
                keyPattern = Pattern.compile(regex);
            }
            for (Object key2 : region.keySet(true)) {
                EntryEventImpl versionHolder = EntryEventImpl.createVersionTagHolder();
                if (keyPattern != null && (!(key2 instanceof String) || !keyPattern.matcher((String)key2).matches())) continue;
                ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
                data = region.get(key2, null, true, true, true, id, versionHolder, true);
                versionTag = versionHolder.getVersionTag();
                BaseCommand.updateValues(values, key2, data, versionTag);
                if (values.size() != maximumChunkSize) continue;
                BaseCommand.sendNewRegisterInterestResponseChunk(region, regex != null ? regex : "ALL_KEYS", values, false, servConn);
                values.clear();
            }
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, regex != null ? regex : "ALL_KEYS", values, true, servConn);
    }

    private static void handleKVKeysPR(PartitionedRegion region, Object keyInfo, boolean serializeValues, ServerConnection servConn) throws IOException {
        int id = 0;
        HashMap<Integer, HashSet> bucketKeys = null;
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region.getConcurrencyChecksEnabled(), serializeValues);
        if (keyInfo != null && keyInfo instanceof List) {
            bucketKeys = new HashMap<Integer, HashSet>();
            for (Object key2 : (List)keyInfo) {
                id = PartitionedRegionHelper.getHashKey(region, null, key2, null, null);
                if (bucketKeys.containsKey(id)) {
                    bucketKeys.get(id).add(key2);
                    continue;
                }
                HashSet keys = new HashSet();
                keys.add(key2);
                bucketKeys.put(id, keys);
            }
            region.fetchEntries(bucketKeys, values, servConn);
        } else {
            region.fetchEntries((String)keyInfo, values, servConn);
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, keyInfo != null ? keyInfo : "ALL_KEYS", values, true, servConn);
    }

    private static void updateValues(VersionedObjectList values, Object key2, Object value2, VersionTag versionTag) {
        boolean keyNotPresent;
        boolean isObject = true;
        boolean wasInvalid = false;
        if (value2 instanceof CachedDeserializable) {
            value2 = ((CachedDeserializable)value2).getValue();
        } else if (value2 == Token.REMOVED_PHASE1 || value2 == Token.REMOVED_PHASE2 || value2 == Token.DESTROYED || value2 == Token.TOMBSTONE) {
            value2 = null;
        } else if (value2 == Token.INVALID || value2 == Token.LOCAL_INVALID) {
            value2 = null;
            wasInvalid = true;
        } else if (value2 instanceof byte[]) {
            isObject = false;
        }
        boolean bl = keyNotPresent = !wasInvalid && (value2 == null || value2 == Token.TOMBSTONE);
        if (keyNotPresent) {
            values.addObjectPartForAbsentKey(key2, value2, versionTag);
        } else {
            values.addObjectPart(key2, value2, isObject, versionTag);
        }
    }

    public static void appendNewRegisterInterestResponseChunkFromLocal(LocalRegion region, VersionedObjectList values, Object riKeys, Set keySet, ServerConnection servConn) throws IOException {
        Object key22 = null;
        EntryEventImpl versionHolder = null;
        ClientProxyMembershipID requestingClient = servConn == null ? null : servConn.getProxyID();
        for (Object key22 : keySet) {
            versionHolder = EntryEventImpl.createVersionTagHolder();
            Object value2 = region.get(key22, null, true, true, true, requestingClient, versionHolder, true);
            BaseCommand.updateValues(values, key22, value2, versionHolder.getVersionTag());
            if (values.size() != maximumChunkSize) continue;
            BaseCommand.sendNewRegisterInterestResponseChunk(region, riKeys != null ? riKeys : "ALL_KEYS", values, false, servConn);
            values.clear();
        }
    }

    public static void appendNewRegisterInterestResponseChunk(LocalRegion region, VersionedObjectList values, Object riKeys, Set set, ServerConnection servConn) throws IOException {
        for (Map.Entry entry : set) {
            if (entry instanceof Region.Entry) {
                VersionTag vt = null;
                Object key2 = null;
                Object value2 = null;
                if (entry instanceof EntrySnapshot) {
                    vt = ((EntrySnapshot)entry).getVersionTag();
                    key2 = ((EntrySnapshot)entry).getRegionEntry().getKey();
                    value2 = ((EntrySnapshot)entry).getRegionEntry().getValue(null);
                } else {
                    VersionStamp vs = ((LocalRegion.NonTXEntry)entry).getRegionEntry().getVersionStamp();
                    vt = vs == null ? null : vs.asVersionTag();
                    key2 = entry.getKey();
                    value2 = ((LocalRegion.NonTXEntry)entry).getRegionEntry()._getValue();
                }
                BaseCommand.updateValues(values, key2, value2, vt);
            } else {
                ArrayList list = (ArrayList)entry.getValue();
                Object value3 = list.get(0);
                VersionTag tag = (VersionTag)list.get(1);
                BaseCommand.updateValues(values, entry.getKey(), value3, tag);
            }
            if (values.size() != maximumChunkSize) continue;
            BaseCommand.sendNewRegisterInterestResponseChunk(region, riKeys != null ? riKeys : "ALL_KEYS", values, false, servConn);
            values.clear();
        }
    }

    public static void sendNewRegisterInterestResponseChunk(LocalRegion region, Object riKey, VersionedObjectList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        String regionName;
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        String string = regionName = region == null ? " null " : region.getFullPath();
        if (logger.isDebugEnabled()) {
            String str = servConn.getName() + ": Sending" + (lastChunk ? " last " : " ") + "register interest response chunk for region: " + regionName + " for keys: " + riKey + " chunk=<" + chunkedResponseMsg + ">";
            logger.debug(str);
        }
        chunkedResponseMsg.sendChunk(servConn);
    }

    private static void handleRegEx(LocalRegion region, String regex, InterestResultPolicy policy, ServerConnection servConn) throws IOException {
        if (region instanceof PartitionedRegion) {
            BaseCommand.handleRegExPR((PartitionedRegion)region, regex, policy, servConn);
            return;
        }
        ArrayList keyList = new ArrayList(maximumChunkSize);
        Pattern keyPattern = Pattern.compile(regex);
        if (region != null) {
            for (Object entryKey : region.keySet(BaseCommand.sendTombstonesInRIResults(servConn, policy))) {
                if (!(entryKey instanceof String) || !keyPattern.matcher((String)entryKey).matches()) continue;
                BaseCommand.appendInterestResponseKey(region, regex, entryKey, keyList, "regex", servConn);
            }
        }
        BaseCommand.sendRegisterInterestResponseChunk(region, regex, keyList, true, servConn);
    }

    private static void handleRegExPR(final PartitionedRegion region, final String regex, InterestResultPolicy policy, final ServerConnection servConn) throws IOException {
        final ArrayList keyList = new ArrayList(maximumChunkSize);
        region.getKeysWithRegEx(regex, BaseCommand.sendTombstonesInRIResults(servConn, policy), new PartitionedRegion.SetCollector(){

            @Override
            public void receiveSet(Set theSet) throws IOException {
                BaseCommand.appendInterestResponseKeys(region, regex, theSet, keyList, "regex", servConn);
            }
        });
        BaseCommand.sendRegisterInterestResponseChunk(region, regex, keyList, true, servConn);
    }

    private static void handleListPR(final PartitionedRegion region, final List keyList, InterestResultPolicy policy, final ServerConnection servConn) throws IOException {
        final ArrayList newKeyList = new ArrayList(maximumChunkSize);
        region.getKeysWithList(keyList, BaseCommand.sendTombstonesInRIResults(servConn, policy), new PartitionedRegion.SetCollector(){

            @Override
            public void receiveSet(Set theSet) throws IOException {
                BaseCommand.appendInterestResponseKeys(region, keyList, theSet, newKeyList, "list", servConn);
            }
        });
        BaseCommand.sendRegisterInterestResponseChunk(region, keyList, newKeyList, true, servConn);
    }

    private static void handleKVList(LocalRegion region, List keyList, boolean serializeValues, ServerConnection servConn) throws IOException {
        if (region != null && region instanceof PartitionedRegion) {
            BaseCommand.handleKVKeysPR((PartitionedRegion)region, keyList, serializeValues, servConn);
            return;
        }
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, true, region == null ? true : region.getAttributes().getConcurrencyChecksEnabled(), serializeValues);
        if (region != null) {
            VersionTag versionTag = null;
            Object data = null;
            for (Object key2 : keyList) {
                if (!region.containsKey(key2) && !region.containsTombstone(key2)) continue;
                EntryEventImpl versionHolder = EntryEventImpl.createVersionTagHolder();
                ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
                data = region.get(key2, null, true, true, true, id, versionHolder, true);
                versionTag = versionHolder.getVersionTag();
                BaseCommand.updateValues(values, key2, data, versionTag);
                if (values.size() != maximumChunkSize) continue;
                BaseCommand.sendNewRegisterInterestResponseChunk(region, keyList, values, false, servConn);
                values.clear();
            }
        }
        BaseCommand.sendNewRegisterInterestResponseChunk(region, keyList, values, true, servConn);
    }

    private static void appendInterestResponseKey(LocalRegion region, Object riKey, Object entryKey, ArrayList list, String kind, ServerConnection servConn) throws IOException {
        list.add(entryKey);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: appendInterestResponseKey <{}>; list size was {}; region: {}", servConn.getName(), entryKey, list.size(), region.getFullPath());
        }
        if (list.size() == maximumChunkSize) {
            BaseCommand.sendRegisterInterestResponseChunk(region, riKey, list, false, servConn);
            list.clear();
        }
    }

    protected static void appendInterestResponseKeys(LocalRegion region, Object riKey, Collection entryKeys, ArrayList collector, String riDescr, ServerConnection servConn) throws IOException {
        Iterator it = entryKeys.iterator();
        while (it.hasNext()) {
            BaseCommand.appendInterestResponseKey(region, riKey, it.next(), collector, riDescr, servConn);
        }
    }

    protected static boolean processQuery(Message msg, Query query, String queryString, Set regionNames, long start, CqQueryImpl cqQuery, QueryOperationContext queryContext, ServerConnection servConn, boolean sendResults) throws IOException, InterruptedException {
        return BaseCommand.processQueryUsingParams(msg, query, queryString, regionNames, start, cqQuery, queryContext, servConn, sendResults, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean processQueryUsingParams(Message msg, Query query, String queryString, Set regionNames, long start, CqQueryImpl cqQuery, QueryOperationContext queryContext, ServerConnection servConn, boolean sendResults, Object[] params) throws IOException, InterruptedException {
        ChunkedMessage queryResponseMsg = servConn.getQueryResponseMessage();
        CacheServerStats stats = servConn.getCacheServerStats();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadQueryRequestTime(start - oldStart);
        if (servConn.getClientVersion().compareTo(Version.GFE_70) >= 0) {
            ((DefaultQuery)query).setRemoteQuery(true);
        }
        try {
            Object result = null;
            result = params != null ? query.execute(params) : query.execute();
            for (String regionName : regionNames) {
                if (crHelper.getRegion(regionName) != null) continue;
                throw new RegionDestroyedException(LocalizedStrings.BaseCommand_REGION_DESTROYED_DURING_THE_EXECUTION_OF_THE_QUERY.toLocalizedString(), regionName);
            }
            AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
            if (postAuthzRequest != null) {
                queryContext = cqQuery == null ? postAuthzRequest.queryAuthorize(queryString, regionNames, result, queryContext, params) : postAuthzRequest.executeCQAuthorize(cqQuery.getName(), queryString, regionNames, result, queryContext);
                result = queryContext.getQueryResult();
            }
            if (result instanceof SelectResults) {
                SelectResults selectResults = (SelectResults)result;
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Result size for : {} is {}", query.getQueryString(), selectResults.size());
                }
                CollectionType collectionType = null;
                boolean sendCqResultsWithKey = true;
                boolean isStructs = false;
                boolean hasSerializedObjects = ((DefaultQuery)query).isKeepSerialized();
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Result for :{} has serialized objects: {}", query.getQueryString(), hasSerializedObjects);
                }
                collectionType = selectResults.getCollectionType();
                isStructs = collectionType.getElementType().isStructType();
                if (cqQuery != null && (sendCqResultsWithKey = BaseCommand.sendCqResultsWithKey(servConn))) {
                    collectionType = new CollectionTypeImpl(Collection.class, (ObjectType)new StructTypeImpl(new String[]{"key", "value"}));
                    isStructs = collectionType.getElementType().isStructType();
                }
                int numberOfChunks = (int)Math.ceil((double)selectResults.size() * 1.0 / (double)maximumChunkSize);
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Query results size: {}: Entries in chunk: {}: Number of chunks: {}", servConn.getName(), selectResults.size(), maximumChunkSize, numberOfChunks);
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessQueryTime(start - oldStart2);
                if (sendResults) {
                    queryResponseMsg.setMessageType(1);
                    queryResponseMsg.setTransactionId(msg.getTransactionId());
                    queryResponseMsg.sendHeader();
                }
                if (sendResults && numberOfChunks == 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("{}: Creating chunk: 0", servConn.getName());
                    }
                    BaseCommand.writeQueryResponseChunk(new Object[0], collectionType, true, servConn);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Sent chunk (1 of 1) of query response for query {}", servConn.getName(), queryString);
                    }
                } else if (hasSerializedObjects) {
                    BaseCommand.sendResultsAsObjectPartList(numberOfChunks, servConn, selectResults.asList(), isStructs, collectionType, queryString, cqQuery, sendCqResultsWithKey, sendResults);
                } else {
                    BaseCommand.sendResultsAsObjectArray(selectResults, numberOfChunks, servConn, isStructs, collectionType, queryString, cqQuery, sendCqResultsWithKey, sendResults);
                }
                if (cqQuery != null) {
                    cqQuery.setCqResultsCacheInitialized();
                }
            } else {
                if (!(result instanceof Integer)) {
                    throw new QueryInvalidException(LocalizedStrings.BaseCommand_UNKNOWN_RESULT_TYPE_0.toLocalizedString(result.getClass()));
                }
                if (sendResults) {
                    queryResponseMsg.setMessageType(1);
                    queryResponseMsg.setTransactionId(msg.getTransactionId());
                    queryResponseMsg.sendHeader();
                    BaseCommand.writeQueryResponseChunk(result, null, true, servConn);
                }
            }
            msg.flush();
        }
        catch (QueryInvalidException e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_UNEXPECTED_QUERYINVALIDEXCEPTION_WHILE_PROCESSING_QUERY_0, queryString), (Throwable)e);
            QueryInvalidException qie = new QueryInvalidException(LocalizedStrings.BaseCommand_0_QUERYSTRING_IS_1.toLocalizedString(e.getLocalizedMessage(), queryString));
            BaseCommand.writeQueryResponseException(msg, qie, false, servConn);
            return false;
        }
        catch (DistributedSystemDisconnectedException se) {
            if (msg != null && logger.isDebugEnabled()) {
                logger.debug("{}: ignoring message of type {} from client {} because shutdown occurred during message processing.", servConn.getName(), MessageType.getString(msg.getMessageType()), servConn.getProxyID());
            }
            servConn.setFlagProcessMessagesAsFalse();
            return false;
        }
        catch (Exception e2222) {
            QueryException e2222;
            BaseCommand.checkForInterrupt(servConn, e2222);
            DefaultQuery defaultQuery = (DefaultQuery)query;
            if (defaultQuery.isCanceled()) {
                e2222 = new QueryException(defaultQuery.getQueryCanceledException().getMessage(), e2222.getCause());
            }
            BaseCommand.writeQueryResponseException(msg, e2222, false, servConn);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent query response for query {}", servConn.getName(), queryString);
        }
        stats.incWriteQueryResponseTime(DistributionStats.getStatTime() - start);
        return true;
    }

    private static boolean sendCqResultsWithKey(ServerConnection servConn) {
        Version clientVersion = servConn.getClientVersion();
        return clientVersion.compareTo(Version.GFE_65) >= 0;
    }

    protected static void sendCqResponse(int msgType, String msgStr, int txId, Throwable e, ServerConnection servConn) throws IOException {
        ChunkedMessage cqMsg = servConn.getChunkedResponseMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("CQ Response message :{}", msgStr);
        }
        switch (msgType) {
            case 6: {
                cqMsg.setNumberOfParts(1);
                break;
            }
            case 47: {
                logger.warn(msgStr);
                cqMsg.setNumberOfParts(1);
                break;
            }
            case 50: {
                String exMsg = "";
                if (e != null) {
                    exMsg = e.getLocalizedMessage();
                }
                logger.info(msgStr + exMsg, e);
                msgStr = msgStr + exMsg;
                cqMsg.setNumberOfParts(1);
                break;
            }
            default: {
                msgType = 50;
                cqMsg.setNumberOfParts(1);
                msgStr = msgStr + LocalizedStrings.BaseCommand_UNKNOWN_QUERY_EXCEPTION.toLocalizedString();
            }
        }
        cqMsg.setMessageType(msgType);
        cqMsg.setTransactionId(txId);
        cqMsg.sendHeader();
        cqMsg.addStringPart(msgStr);
        cqMsg.setLastChunk(true);
        cqMsg.sendChunk(servConn);
        cqMsg.setLastChunk(true);
        if (logger.isDebugEnabled()) {
            logger.debug("CQ Response sent successfully");
        }
    }

    private static void sendResultsAsObjectArray(SelectResults selectResults, int numberOfChunks, ServerConnection servConn, boolean isStructs, CollectionType collectionType, String queryString, CqQueryImpl cqQuery, boolean sendCqResultsWithKey, boolean sendResults) throws IOException {
        int resultIndex = 0;
        int cqResultIndex = 0;
        Object[] objs = selectResults.toArray();
        for (int j = 0; j < numberOfChunks; ++j) {
            boolean incompleteArray = false;
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Creating chunk: {}", servConn.getName(), j);
            }
            Object[] results = new Object[maximumChunkSize];
            for (int i = 0; i < maximumChunkSize; ++i) {
                if (resultIndex == selectResults.size()) {
                    incompleteArray = true;
                    break;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Adding entry [{}] to query results: {}", servConn.getName(), resultIndex, objs[resultIndex]);
                }
                if (cqQuery != null) {
                    CqEntry e = (CqEntry)objs[resultIndex];
                    if (e.getValue() == null) {
                        ++resultIndex;
                        --i;
                        continue;
                    }
                    if (!cqQuery.isPR) {
                        cqQuery.addToCqResultKeys(e.getKey());
                    }
                    results[i] = sendCqResultsWithKey ? e.getKeyValuePair() : e.getValue();
                } else {
                    results[i] = isStructs && objs[resultIndex] instanceof Struct ? ((Struct)objs[resultIndex]).getFieldValues() : objs[resultIndex];
                }
                ++resultIndex;
                ++cqResultIndex;
            }
            if (incompleteArray) {
                Object[] newResults = cqQuery != null ? new Object[cqResultIndex % maximumChunkSize] : new Object[resultIndex % maximumChunkSize];
                for (int i = 0; i < newResults.length; ++i) {
                    newResults[i] = results[i];
                }
                results = newResults;
            }
            if (sendResults) {
                BaseCommand.writeQueryResponseChunk(results, collectionType, resultIndex == selectResults.size(), servConn);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent chunk ({} of {}) of query response for query: {}", servConn.getName(), j + 1, numberOfChunks, queryString);
                }
            }
            if (resultIndex == selectResults.size()) break;
        }
    }

    private static void sendResultsAsObjectPartList(int numberOfChunks, ServerConnection servConn, List objs, boolean isStructs, CollectionType collectionType, String queryString, CqQueryImpl cqQuery, boolean sendCqResultsWithKey, boolean sendResults) throws IOException {
        int resultIndex = 0;
        Object result = null;
        for (int j = 0; j < numberOfChunks; ++j) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Creating chunk: {}", servConn.getName(), j);
            }
            ObjectPartList serializedObjs = new ObjectPartList(maximumChunkSize, false);
            for (int i = 0; i < maximumChunkSize && resultIndex != objs.size(); ++i) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}: Adding entry [{}] to query results: {}", servConn.getName(), resultIndex, objs.get(resultIndex));
                }
                if (cqQuery != null) {
                    CqEntry e = (CqEntry)objs.get(resultIndex);
                    if (e.getValue() == null) {
                        ++resultIndex;
                        continue;
                    }
                    if (!cqQuery.isPR) {
                        cqQuery.addToCqResultKeys(e.getKey());
                    }
                    result = sendCqResultsWithKey ? e.getKeyValuePair() : e.getValue();
                } else {
                    result = objs.get(resultIndex);
                }
                if (sendResults) {
                    BaseCommand.addToObjectPartList(serializedObjs, result, collectionType, false, servConn, isStructs);
                }
                ++resultIndex;
            }
            if (!sendResults) continue;
            BaseCommand.writeQueryResponseChunk(serializedObjs, collectionType, j + 1 == numberOfChunks, servConn);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("{}: Sent chunk ({} of {}) of query response for query: {}", servConn.getName(), j + 1, numberOfChunks, queryString);
        }
    }

    private static void addToObjectPartList(ObjectPartList serializedObjs, Object res, CollectionType collectionType, boolean lastChunk, ServerConnection servConn, boolean isStructs) throws IOException {
        if (isStructs && res instanceof Struct) {
            Object[] values = ((Struct)res).getFieldValues();
            ObjectPartList serializedValueObjs = new ObjectPartList(values.length, false);
            for (Object value2 : values) {
                if (value2 instanceof CachedDeserializable) {
                    serializedValueObjs.addPart(null, ((CachedDeserializable)value2).getSerializedValue(), (byte)1, null);
                    continue;
                }
                BaseCommand.addDeSerializedObjectToObjectPartList(serializedValueObjs, value2);
            }
            serializedObjs.addPart(null, serializedValueObjs, (byte)1, null);
        } else if (res instanceof Object[]) {
            Object[] values = (Object[])res;
            ObjectPartList serializedValueObjs = new ObjectPartList(values.length, false);
            for (Object value3 : values) {
                if (value3 instanceof CachedDeserializable) {
                    serializedValueObjs.addPart(null, ((CachedDeserializable)value3).getSerializedValue(), (byte)1, null);
                    continue;
                }
                BaseCommand.addDeSerializedObjectToObjectPartList(serializedValueObjs, value3);
            }
            serializedObjs.addPart(null, serializedValueObjs, (byte)1, null);
        } else if (res instanceof CachedDeserializable) {
            serializedObjs.addPart(null, ((CachedDeserializable)res).getSerializedValue(), (byte)1, null);
        } else {
            BaseCommand.addDeSerializedObjectToObjectPartList(serializedObjs, res);
        }
    }

    private static void addDeSerializedObjectToObjectPartList(ObjectPartList objPartList, Object obj) {
        if (obj instanceof byte[]) {
            objPartList.addPart(null, obj, (byte)0, null);
        } else {
            objPartList.addPart(null, obj, (byte)1, null);
        }
    }

    static {
        Semaphore tmp = MAX_INCOMING_DATA > 0 ? new Semaphore(MAX_INCOMING_DATA, true) : null;
        incomingDataLimiter = tmp;
        tmp = MAX_INCOMING_MSGS > 0 ? new Semaphore(MAX_INCOMING_MSGS, false) : null;
        incomingMsgLimiter = tmp;
    }
}

