/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.client.ServerRefusedConnectionException;
import com.gemstone.gemfire.cache.client.internal.ClientUpdater;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.GetEventValueOp;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.QueueManager;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SocketUtils;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.MessageStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerQueueStatus;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerResponseMatrix;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.sequencelog.EntryLogger;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.Logger;

public class CacheClientUpdater
extends Thread
implements ClientUpdater,
InternalDistributedSystem.DisconnectListener {
    private static final Logger logger = LogService.getLogger();
    private final boolean connected;
    private final InternalDistributedSystem system;
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;
    private volatile ClientUpdater failedUpdater;
    private final ByteBuffer commBuffer;
    private final CCUStats stats;
    private GemFireCacheImpl cache;
    private CachedRegionHelper cacheHelper;
    private final AtomicBoolean continueProcessing = new AtomicBoolean(true);
    private final boolean isDurableClient;
    private final InternalDistributedMember serverId;
    private final boolean isPrimary;
    private boolean isOpCompleted;
    public static final String CLIENT_UPDATER_THREAD_NAME = "Cache Client Updater Thread ";
    public static boolean isUsedByTest;
    public static boolean fullValueRequested;
    private final ServerLocation location;
    private QueueManager qManager = null;
    private EndpointManager eManager = null;
    private Endpoint endpoint = null;
    private static final long MAX_CACHE_WAIT;
    private volatile boolean endPointDied = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForCache() {
        long tilt = System.currentTimeMillis() + MAX_CACHE_WAIT * 1000L;
        while (true) {
            if (this.quitting()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_ABANDONED_WAIT_DUE_TO_CANCELLATION, this));
                return false;
            }
            if (!this.connected) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_ABANDONED_WAIT_BECAUSE_IT_IS_NO_LONGER_CONNECTED, this));
                return false;
            }
            if (System.currentTimeMillis() > tilt) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_WAIT_TIMED_OUT_MORE_THAN_1_SECONDS, new Object[]{this, MAX_CACHE_WAIT}));
                return false;
            }
            GemFireCacheImpl c = GemFireCacheImpl.getInstance();
            if (c != null && !c.isClosed()) {
                this.cache = c;
                this.cacheHelper = new CachedRegionHelper(c);
                return true;
            }
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheClientUpdater(String name, ServerLocation location, boolean primary, DistributedSystem ids, HandShake handshake, QueueManager qManager, EndpointManager eManager, Endpoint endpoint, int handshakeTimeout) throws AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException {
        super((ThreadGroup)LoggingThreadGroup.createThreadGroup("Client update thread"), name);
        this.setDaemon(true);
        this.system = (InternalDistributedSystem)ids;
        this.isDurableClient = handshake.getMembership().isDurable();
        this.isPrimary = primary;
        this.location = location;
        this.qManager = qManager;
        this.eManager = eManager;
        this.endpoint = endpoint;
        this.stats = new CCUStats(this.system, this.location);
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Creating asynchronous update connection");
        }
        boolean success = false;
        Socket mySock = null;
        InternalDistributedMember sid = null;
        ByteBuffer cb = null;
        OutputStream tmpOut = null;
        InputStream tmpIn = null;
        try {
            PoolImpl pool;
            ServerQueueStatus sqs;
            int socketBufferSize = Integer.getInteger("BridgeServer.SOCKET_BUFFER_SIZE", 32768);
            if (!SocketCreator.getDefaultInstance().isHostReachable(InetAddress.getByName(location.getHostName()))) {
                throw new NoRouteToHostException("Server is not reachable: " + location.getHostName());
            }
            mySock = SocketCreator.getDefaultInstance().connectForClient(location.getHostName(), location.getPort(), handshakeTimeout, socketBufferSize);
            mySock.setTcpNoDelay(true);
            mySock.setSendBufferSize(socketBufferSize);
            this.verifySocketBufferSize(socketBufferSize, mySock.getReceiveBufferSize(), "receive");
            this.verifySocketBufferSize(socketBufferSize, mySock.getSendBufferSize(), "send");
            mySock.setSoTimeout(handshakeTimeout);
            tmpOut = SocketUtils.getOutputStream(mySock);
            tmpIn = SocketUtils.getInputStream(mySock);
            if (isDebugEnabled) {
                logger.debug("Initialized server-to-client socket with send buffer size: {} bytes and receive buffer size: {} bytes", mySock.getSendBufferSize(), mySock.getReceiveBufferSize());
            }
            if (isDebugEnabled) {
                logger.debug("Created connection from {}:{} to CacheClientNotifier on port {} for server-to-client communication", mySock.getInetAddress().getHostAddress(), mySock.getLocalPort(), mySock.getPort());
            }
            if (((sqs = handshake.greetNotifier(mySock, this.isPrimary, location)).isPrimary() || sqs.isNonRedundant()) && !(pool = (PoolImpl)this.qManager.getPool()).getReadyForEventsCalled()) {
                pool.setPendingEventCount(sqs.getServerQueueSize());
            }
            int bufSize = 1024;
            try {
                bufSize = mySock.getSendBufferSize();
                if (bufSize < 1024) {
                    bufSize = 1024;
                }
            }
            catch (SocketException ignore) {
                // empty catch block
            }
            cb = ServerConnection.allocateCommBuffer(bufSize);
            MemberAttributes ma = new MemberAttributes(0, -1, 10, -1, null, null, null);
            sid = new InternalDistributedMember(mySock.getInetAddress(), mySock.getPort(), false, true, ma);
            success = true;
        }
        catch (ConnectException e) {
            if (!this.quitting()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_CONNECTION_WAS_REFUSED, this));
            }
        }
        catch (SSLException ex) {
            if (!this.quitting()) {
                this.getSecurityLogger().warning(LocalizedStrings.CacheClientUpdater_0_SSL_NEGOTIATION_FAILED_1, new Object[]{this, ex});
                throw new AuthenticationFailedException(LocalizedStrings.CacheClientUpdater_SSL_NEGOTIATION_FAILED_WITH_ENDPOINT_0.toLocalizedString(location), ex);
            }
        }
        catch (GemFireSecurityException ex) {
            if (!this.quitting()) {
                this.getSecurityLogger().warning(LocalizedStrings.CacheClientUpdater_0_SECURITY_EXCEPTION_WHEN_CREATING_SERVERTOCLIENT_COMMUNICATION_SOCKET_1, new Object[]{this, ex});
                throw ex;
            }
        }
        catch (IOException e) {
            if (!this.quitting()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_CAUGHT_FOLLOWING_EXECPTION_WHILE_ATTEMPTING_TO_CREATE_A_SERVER_TO_CLIENT_COMMUNICATION_SOCKET_AND_WILL_EXIT_1, new Object[]{this, e}), (Throwable)(logger.isDebugEnabled() ? e : null));
            }
            eManager.serverCrashed(this.endpoint);
        }
        catch (ClassNotFoundException e) {
            if (!this.quitting()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_CLASS_NOT_FOUND, e.getMessage()));
            }
        }
        finally {
            this.connected = success;
            if (mySock != null) {
                try {
                    mySock.setSoTimeout(0);
                }
                catch (SocketException e) {}
            }
            if (this.connected) {
                this.socket = mySock;
                this.out = tmpOut;
                this.in = tmpIn;
                this.serverId = sid;
                this.commBuffer = cb;
                if (mySock != null) {
                    try {
                        mySock.setSoTimeout(0);
                    }
                    catch (SocketException ignore) {}
                }
            } else {
                this.socket = null;
                this.serverId = null;
                this.commBuffer = null;
                this.out = null;
                this.in = null;
                if (mySock != null) {
                    try {
                        mySock.close();
                    }
                    catch (IOException ioe) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_CLOSING_SOCKET_IN_0_FAILED, this), (Throwable)ioe);
                    }
                }
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isPrimary() {
        return this.isPrimary;
    }

    public InternalLogWriter getSecurityLogger() {
        return this.qManager.getSecurityLogger();
    }

    @Override
    public void setFailedUpdater(ClientUpdater failedUpdater) {
        this.failedUpdater = failedUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean addedListener = false;
        EntryLogger.setSource(this.serverId, "RI");
        try {
            this.system.addDisconnectListener(this);
            addedListener = true;
            if (!this.waitForCache()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_NO_CACHE_EXITING, this));
                return;
            }
            this.processMessages();
        }
        catch (CancelException e) {
            return;
        }
        finally {
            if (addedListener) {
                this.system.removeDisconnectListener(this);
            }
            this.close();
            EntryLogger.clearSource();
        }
    }

    protected void stopProcessing() {
        this.continueProcessing.set(false);
    }

    public void stopUpdater() {
        block7: {
            boolean isSelfDestroying = Thread.currentThread() == this;
            this.stopProcessing();
            if (this.isAlive()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Stopping {}", this.location, this);
                }
                if (!isSelfDestroying) {
                    this.interrupt();
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug(t.getMessage(), t);
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        this.continueProcessing.set(false);
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.stats.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.cacheHelper != null) {
                this.cacheHelper.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Message initializeMessage() {
        Message _message;
        block3: {
            _message = new Message(2, Version.CURRENT);
            try {
                _message.setComms(this.socket, this.in, this.out, this.commBuffer, this.stats);
            }
            catch (IOException e) {
                if (this.quitting()) break block3;
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Caught following exception while attempting to initialize a server-to-client communication socket and will exit", this, e);
                }
                this.stopProcessing();
            }
        }
        return _message;
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.location.getHostName() + ":" + this.location.getPort() + ")";
    }

    private void handleMarker(Message m) {
        try {
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("Received marker message of length ({} bytes)", m.getPayloadLength());
            }
            this.qManager.getState().processMarker();
            if (isDebugEnabled) {
                logger.debug("Processed marker message");
            }
        }
        catch (Exception e) {
            String message = LocalizedStrings.CacheClientUpdater_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_ATTEMPTING_TO_HANDLE_A_MARKER.toLocalizedString();
            this.handleException(message, e);
        }
    }

    private void handleUpdate(Message m) {
        String regionName = null;
        Object key2 = null;
        Part valuePart = null;
        Object newValue = null;
        byte[] deltaBytes = null;
        Object fullValue = null;
        boolean isValueObject = false;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            boolean isCreate;
            VersionTag versionTag;
            this.isOpCompleted = false;
            if (isDebugEnabled) {
                logger.debug("Received put message of length ({} bytes)", m.getPayloadLength());
            }
            Part regionNamePart = m.getPart(partCnt++);
            Part keyPart = m.getPart(partCnt++);
            boolean isDeltaSent = (Boolean)m.getPart(partCnt++).getObject();
            valuePart = m.getPart(partCnt++);
            Part callbackArgumentPart = m.getPart(partCnt++);
            if ((versionTag = (VersionTag)m.getPart(partCnt++).getObject()) != null) {
                versionTag.replaceNullIDs((InternalDistributedMember)this.endpoint.getMemberId());
            }
            Part isInterestListPassedPart = m.getPart(partCnt++);
            Part hasCqsPart = m.getPart(partCnt++);
            EventID eventId = (EventID)m.getPart(m.getNumberOfParts() - 1).getObject();
            boolean withInterest = (Boolean)isInterestListPassedPart.getObject();
            boolean withCQs = (Boolean)hasCqsPart.getObject();
            regionName = regionNamePart.getString();
            key2 = keyPart.getStringOrObject();
            Object callbackArgument = callbackArgumentPart.getObject();
            boolean bl = isCreate = m.getMessageType() == 27;
            if (isDebugEnabled) {
                logger.debug("Putting entry for region: {} key: {} create: {}{} callbackArgument: {} withInterest={} withCQs={} eventID={} version={}", regionName, key2, isCreate, valuePart.isObject() ? new StringBuilder(" value: ").append(this.deserialize(valuePart.getSerializedForm())) : "", callbackArgument, withInterest, withCQs, eventId, versionTag);
            }
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            if (!isDeltaSent) {
                byte[] serializedForm = valuePart.getSerializedForm();
                if (!isCreate || !InternalDataSerializer.isSerializedNull(serializedForm)) {
                    newValue = valuePart.getSerializedForm();
                }
                if (withCQs) {
                    fullValue = valuePart.getObject();
                }
                isValueObject = valuePart.isObject();
            } else {
                deltaBytes = valuePart.getSerializedForm();
                isValueObject = true;
            }
            if (region == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("{}: Region named {} does not exist", this, regionName);
                }
            } else if (region.hasServerProxy() && ServerResponseMatrix.checkForValidStateAfterNotification(region, key2, m.getMessageType()) && (withInterest || !withCQs)) {
                EntryEventImpl newEvent = null;
                try {
                    newEvent = new EntryEventImpl(region, m.getMessageType() == 27 ? Operation.CREATE : Operation.UPDATE, key2, null, callbackArgument, true, eventId.getDistributedMember());
                    newEvent.setVersionTag(versionTag);
                    newEvent.setFromServer(true);
                    region.basicBridgeClientUpdate(eventId.getDistributedMember(), key2, newValue, deltaBytes, isValueObject, callbackArgument, m.getMessageType() == 27, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, newEvent, eventId);
                    this.isOpCompleted = true;
                    if (withCQs && isDeltaSent) {
                        fullValue = newEvent.getNewValue();
                    }
                }
                catch (InvalidDeltaException ide) {
                    Part fullValuePart = this.requestFullValue(eventId, "Caught InvalidDeltaException.");
                    region.getCachePerfStats().incDeltaFullValuesRequested();
                    Object object = fullValuePart.getObject();
                    newValue = object;
                    fullValue = object;
                    isValueObject = fullValuePart.isObject();
                    region.basicBridgeClientUpdate(eventId.getDistributedMember(), key2, newValue, null, isValueObject, callbackArgument, m.getMessageType() == 27, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, newEvent, eventId);
                    this.isOpCompleted = true;
                }
                if (isDebugEnabled) {
                    logger.debug("Put entry for region: {} key: {} callbackArgument: {}", regionName, key2, callbackArgument);
                }
            }
            if (withCQs) {
                Part numCqsPart = m.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", numCqsPart.getInt() / 2);
                }
                partCnt = this.processCqs(m, partCnt, numCqsPart.getInt(), m.getMessageType(), key2, fullValue, deltaBytes, eventId);
                this.isOpCompleted = true;
            }
        }
        catch (Exception e) {
            String message = LocalizedStrings.CacheClientUpdater_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_ATTEMPTING_TO_PUT_ENTRY_REGION_0_KEY_1_VALUE_2.toLocalizedString(regionName, key2, this.deserialize(valuePart.getSerializedForm()));
            this.handleException(message, e);
        }
    }

    private Part requestFullValue(EventID eventId, String reason) throws Exception {
        Part result;
        boolean isDebugEnabled;
        if (isUsedByTest) {
            fullValueRequested = true;
        }
        if (isDebugEnabled = logger.isDebugEnabled()) {
            logger.debug("{} Requesting full value...", reason);
        }
        if ((result = (Part)GetEventValueOp.executeOnPrimary(this.qManager.getPool(), eventId, null)) == null) {
            throw new Exception("Could not retrieve full value for " + eventId);
        }
        if (isDebugEnabled) {
            logger.debug("Full value received.");
        }
        return result;
    }

    private void handleInvalidate(Message m) {
        String regionName = null;
        Object key2 = null;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            VersionTag versionTag;
            this.isOpCompleted = false;
            if (isDebugEnabled) {
                logger.debug("Received invalidate message of length ({} bytes)", m.getPayloadLength());
            }
            Part regionNamePart = m.getPart(partCnt++);
            Part keyPart = m.getPart(partCnt++);
            Part callbackArgumentPart = m.getPart(partCnt++);
            if ((versionTag = (VersionTag)m.getPart(partCnt++).getObject()) != null) {
                versionTag.replaceNullIDs((InternalDistributedMember)this.endpoint.getMemberId());
            }
            Part isInterestListPassedPart = m.getPart(partCnt++);
            Part hasCqsPart = m.getPart(partCnt++);
            regionName = regionNamePart.getString();
            key2 = keyPart.getStringOrObject();
            Object callbackArgument = callbackArgumentPart.getObject();
            boolean withInterest = (Boolean)isInterestListPassedPart.getObject();
            boolean withCQs = (Boolean)hasCqsPart.getObject();
            if (isDebugEnabled) {
                logger.debug("Invalidating entry for region: {} key: {} callbackArgument: {} withInterest={} withCQs={} version={}", regionName, key2, callbackArgument, withInterest, withCQs, versionTag);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", regionName);
                }
            } else if (region.hasServerProxy() && (withInterest || !withCQs)) {
                try {
                    Part eid = m.getPart(m.getNumberOfParts() - 1);
                    EventID eventId = (EventID)eid.getObject();
                    try {
                        region.basicBridgeClientInvalidate(eventId.getDistributedMember(), key2, callbackArgument, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, eventId, versionTag);
                    }
                    catch (ConcurrentCacheModificationException e) {
                        // empty catch block
                    }
                    this.isOpCompleted = true;
                    this.qManager.getState().incrementInvalidatedStats();
                    if (isDebugEnabled) {
                        logger.debug("Invalidated entry for region: {} key: {} callbackArgument: {}", regionName, key2, callbackArgument);
                    }
                }
                catch (EntryNotFoundException e) {
                    if (isDebugEnabled && !this.quitting()) {
                        logger.debug("Already invalidated entry for region: {} key: {} callbackArgument: {}", regionName, key2, callbackArgument);
                    }
                    this.isOpCompleted = true;
                }
            }
            if (withCQs) {
                Part regionOpType = m.getPart(partCnt++);
                Part numCqsPart = m.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", numCqsPart.getInt() / 2);
                }
                partCnt = this.processCqs(m, partCnt, numCqsPart.getInt(), regionOpType.getInt(), key2, null);
                this.isOpCompleted = true;
            }
        }
        catch (Exception e) {
            String message = LocalizedStrings.CacheClientUpdater_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_ATTEMPTING_TO_INVALIDATE_ENTRY_REGION_0_KEY_1.toLocalizedString(regionName, key2);
            this.handleException(message, e);
        }
    }

    private void handleDestroy(Message m) {
        String regionName = null;
        Object key2 = null;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            VersionTag versionTag;
            this.isOpCompleted = false;
            if (isDebugEnabled) {
                logger.debug("Received destroy message of length ({} bytes)", m.getPayloadLength());
            }
            Part regionNamePart = m.getPart(partCnt++);
            Part keyPart = m.getPart(partCnt++);
            Part callbackArgumentPart = m.getPart(partCnt++);
            if ((versionTag = (VersionTag)m.getPart(partCnt++).getObject()) != null) {
                versionTag.replaceNullIDs((InternalDistributedMember)this.endpoint.getMemberId());
            }
            regionName = regionNamePart.getString();
            key2 = keyPart.getStringOrObject();
            Part isInterestListPassedPart = m.getPart(partCnt++);
            Part hasCqsPart = m.getPart(partCnt++);
            boolean withInterest = (Boolean)isInterestListPassedPart.getObject();
            boolean withCQs = (Boolean)hasCqsPart.getObject();
            Object callbackArgument = callbackArgumentPart.getObject();
            if (isDebugEnabled) {
                logger.debug("Destroying entry for region: {} key: {} callbackArgument: {} withInterest={} withCQs={} version={}", regionName, key2, callbackArgument, withInterest, withCQs, versionTag);
            }
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            EventID eventId = null;
            if (region == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", regionName);
                }
            } else if (region.hasServerProxy() && (withInterest || !withCQs)) {
                try {
                    Part eid = m.getPart(m.getNumberOfParts() - 1);
                    eventId = (EventID)eid.getObject();
                    try {
                        region.basicBridgeClientDestroy(eventId.getDistributedMember(), key2, callbackArgument, this.qManager.getState().getProcessedMarker() || !this.isDurableClient, eventId, versionTag);
                    }
                    catch (ConcurrentCacheModificationException e) {
                        // empty catch block
                    }
                    this.isOpCompleted = true;
                    if (isDebugEnabled) {
                        logger.debug("Destroyed entry for region: {} key: {} callbackArgument: {}", regionName, key2, callbackArgument);
                    }
                }
                catch (EntryNotFoundException e) {
                    if (isDebugEnabled && !this.quitting()) {
                        logger.debug("Already destroyed entry for region: {} key: {} callbackArgument: {} eventId={}", regionName, key2, callbackArgument, eventId.expensiveToString());
                    }
                    this.isOpCompleted = true;
                }
            }
            if (withCQs) {
                Part numCqsPart = m.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", numCqsPart.getInt() / 2);
                }
                partCnt = this.processCqs(m, partCnt, numCqsPart.getInt(), m.getMessageType(), key2, null);
                this.isOpCompleted = true;
            }
        }
        catch (Exception e) {
            String message = LocalizedStrings.CacheClientUpdater_THE_FOLLOWING_EXCEPTION_OCCURRED_WHILE_ATTEMPTING_TO_DESTROY_ENTRY_REGION_0_KEY_1.toLocalizedString(regionName, key2);
            this.handleException(message, e);
        }
    }

    private void handleDestroyRegion(Message m) {
        Part regionNamePart = null;
        Part callbackArgumentPart = null;
        String regionName = null;
        Object callbackArgument = null;
        LocalRegion region = null;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            if (isDebugEnabled) {
                logger.debug("Received destroy region message of length ({} bytes)", m.getPayloadLength());
            }
            regionNamePart = m.getPart(partCnt++);
            callbackArgumentPart = m.getPart(partCnt++);
            regionName = regionNamePart.getString();
            callbackArgument = callbackArgumentPart.getObject();
            Part hasCqsPart = m.getPart(partCnt++);
            if (isDebugEnabled) {
                logger.debug("Destroying region: {} callbackArgument: {}", regionName, callbackArgument);
            }
            if (((Boolean)hasCqsPart.getObject()).booleanValue()) {
                Part numCqsPart = m.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", numCqsPart.getInt() / 2);
                }
                partCnt = this.processCqs(m, partCnt, numCqsPart.getInt(), m.getMessageType(), null, null);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", regionName);
                }
                return;
            }
            if (region.hasServerProxy()) {
                region.localDestroyRegion(callbackArgument);
                if (isDebugEnabled) {
                    logger.debug("Destroyed region: {} callbackArgument: {}", regionName, callbackArgument);
                }
            }
        }
        catch (RegionDestroyedException e) {
            if (isDebugEnabled) {
                logger.debug("region already destroyed: {}", regionName);
            }
        }
        catch (Exception e) {
            String message = LocalizedStrings.CacheClientUpdater_CAUGHT_AN_EXCEPTION_WHILE_ATTEMPTING_TO_DESTROY_REGION_0.toLocalizedString(regionName);
            this.handleException(message, e);
        }
    }

    private void handleClearRegion(Message m) {
        String regionName = null;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            if (isDebugEnabled) {
                logger.debug("{}: Received clear region message of length ({} bytes)", this, m.getPayloadLength());
            }
            Part regionNamePart = m.getPart(partCnt++);
            Part callbackArgumentPart = m.getPart(partCnt++);
            Part hasCqsPart = m.getPart(partCnt++);
            regionName = regionNamePart.getString();
            Object callbackArgument = callbackArgumentPart.getObject();
            if (isDebugEnabled) {
                logger.debug("Clearing region: {} callbackArgument: {}", regionName, callbackArgument);
            }
            if (((Boolean)hasCqsPart.getObject()).booleanValue()) {
                Part numCqsPart = m.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", numCqsPart.getInt() / 2);
                }
                partCnt = this.processCqs(m, partCnt, numCqsPart.getInt(), m.getMessageType(), null, null);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", regionName);
                }
                return;
            }
            if (region.hasServerProxy()) {
                region.basicBridgeClientClear(callbackArgument, this.qManager.getState().getProcessedMarker() || !this.isDurableClient);
                if (isDebugEnabled) {
                    logger.debug("Cleared region: {} callbackArgument: {}", regionName, callbackArgument);
                }
            }
        }
        catch (Exception e) {
            String message = LocalizedStrings.CacheClientUpdater_CAUGHT_THE_FOLLOWING_EXCEPTION_WHILE_ATTEMPTING_TO_CLEAR_REGION_0.toLocalizedString(regionName);
            this.handleException(message, e);
        }
    }

    private void handleInvalidateRegion(Message m) {
        String regionName = null;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            LocalRegion region;
            if (isDebugEnabled) {
                logger.debug("{}: Received invalidate region message of length ({} bytes)", this, m.getPayloadLength());
            }
            Part regionNamePart = m.getPart(partCnt++);
            int n = ++partCnt;
            ++partCnt;
            Part hasCqsPart = m.getPart(n);
            regionName = regionNamePart.getString();
            if (((Boolean)hasCqsPart.getObject()).booleanValue()) {
                Part numCqsPart = m.getPart(partCnt++);
                if (isDebugEnabled) {
                    logger.debug("Received message has CQ Event. Number of cqs interested in the event : {}", numCqsPart.getInt() / 2);
                }
                partCnt = this.processCqs(m, partCnt, numCqsPart.getInt(), m.getMessageType(), null, null);
            }
            if ((region = (LocalRegion)this.cacheHelper.getRegion(regionName)) == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("Region named {} does not exist", regionName);
                }
                return;
            }
            if (region.hasServerProxy()) {
                return;
            }
        }
        catch (Exception e) {
            String message = LocalizedStrings.CacheClientUpdater_CAUGHT_THE_FOLLOWING_EXCEPTION_WHILE_ATTEMPTING_TO_INVALIDATE_REGION_0.toLocalizedString(regionName);
            this.handleException(message, e);
        }
    }

    private void handleRegisterInstantiator(Message msg, EventID eventId) {
        block5: {
            String instantiatorClassName = null;
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                int noOfParts = msg.getNumberOfParts();
                if (isDebugEnabled) {
                    logger.debug("{}: Received register instantiators message of parts {}", this.getName(), noOfParts);
                }
                Assert.assertTrue((noOfParts - 1) % 3 == 0);
                for (int i = 0; i < noOfParts - 1; i += 3) {
                    instantiatorClassName = (String)CacheServerHelper.deserialize(msg.getPart(i).getSerializedForm());
                    String instantiatedClassName = (String)CacheServerHelper.deserialize(msg.getPart(i + 1).getSerializedForm());
                    int id = msg.getPart(i + 2).getInt();
                    InternalInstantiator.register(instantiatorClassName, instantiatedClassName, id, false, eventId, null);
                }
                if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                    BridgeObserver bo = BridgeObserverHolder.getInstance();
                    bo.afterReceivingFromServer(eventId);
                }
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block5;
                logger.debug("{}: Caught following exception while attempting to read Instantiator : {}", this, instantiatorClassName, e);
            }
        }
    }

    private void handleRegisterDataSerializer(Message msg, EventID eventId) {
        block8: {
            Object dataSerializerClass = null;
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                int noOfParts = msg.getNumberOfParts();
                if (isDebugEnabled) {
                    logger.debug("{}: Received register dataserializer message of parts {}", this.getName(), noOfParts);
                }
                int i = 0;
                while (i < noOfParts - 1) {
                    try {
                        int j;
                        String dataSerializerClassName = (String)CacheServerHelper.deserialize(msg.getPart(i).getSerializedForm());
                        int id = msg.getPart(i + 1).getInt();
                        InternalDataSerializer.register(dataSerializerClassName, false, eventId, null, id);
                        int numOfClasses = msg.getPart(i + 2).getInt();
                        for (j = 0; j < numOfClasses; ++j) {
                            String className = (String)CacheServerHelper.deserialize(msg.getPart(i + 3 + j).getSerializedForm());
                            InternalDataSerializer.updateSupportedClassesMap(dataSerializerClassName, className);
                        }
                        i = i + 3 + j;
                    }
                    catch (ClassNotFoundException e) {
                        if (!isDebugEnabled) continue;
                        logger.debug("{}: Caught following exception while attempting to read DataSerializer : {}", this, dataSerializerClass, e);
                    }
                }
                if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                    BridgeObserver bo = BridgeObserverHolder.getInstance();
                    bo.afterReceivingFromServer(eventId);
                }
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block8;
                logger.debug("{}: Caught following exception while attempting to read DataSerializer : {}", this, dataSerializerClass, e);
            }
        }
    }

    private int processCqs(Message m, int startMessagePart, int numCqParts, int messageType, Object key2, Object value2) {
        return this.processCqs(m, startMessagePart, numCqParts, messageType, key2, value2, null, null);
    }

    private int processCqs(Message m, int startMessagePart, int numCqParts, int messageType, Object key2, Object value2, byte[] delta, EventID eventId) {
        block7: {
            HashMap<String, Integer> cqs = new HashMap<String, Integer>();
            boolean isDebugEnabled = logger.isDebugEnabled();
            int cqCnt = 0;
            while (cqCnt < numCqParts) {
                StringBuilder str = null;
                if (isDebugEnabled) {
                    str = new StringBuilder(100);
                    str.append("found these queries: ");
                }
                try {
                    Part cqNamePart = m.getPart(startMessagePart + cqCnt++);
                    Part cqOpPart = m.getPart(startMessagePart + cqCnt++);
                    cqs.put(cqNamePart.getString(), cqOpPart.getInt());
                    if (str != null) {
                        str.append(cqNamePart.getString()).append(" op=").append(cqOpPart.getInt()).append("  ");
                    }
                }
                catch (Exception ex) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_ERROR_WHILE_PROCESSING_THE_CQ_MESSAGE_PROBLEM_WITH_READING_MESSAGE_FOR_CQ_0, cqCnt));
                }
                if (!isDebugEnabled || str == null) continue;
                logger.debug(str);
            }
            CqService cqService = CqService.getCqService(this.cacheHelper.getCache());
            try {
                cqService.dispatchCqListeners(cqs, messageType, key2, value2, delta, this.qManager, eventId);
            }
            catch (Exception ex) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_FAILED_TO_INVOKE_CQ_DISPATCHER_ERROR___0, ex.getMessage()));
                if (!isDebugEnabled) break block7;
                logger.debug("Failed to invoke CQ Dispatcher.", (Throwable)ex);
            }
        }
        return startMessagePart + numCqParts;
    }

    private void handleRegisterInterest(Message m) {
        String regionName = null;
        Object key2 = null;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            if (isDebugEnabled) {
                logger.debug("{}: Received add interest message of length ({} bytes)", this, m.getPayloadLength());
            }
            Part regionNamePart = m.getPart(partCnt++);
            Part keyPart = m.getPart(partCnt++);
            Part interestTypePart = m.getPart(partCnt++);
            Part interestResultPolicyPart = m.getPart(partCnt++);
            Part isDurablePart = m.getPart(partCnt++);
            Part receiveUpdatesAsInvalidatesPart = m.getPart(partCnt++);
            regionName = regionNamePart.getString();
            key2 = keyPart.getStringOrObject();
            int interestType2 = (Integer)interestTypePart.getObject();
            byte interestResultPolicy = (Byte)interestResultPolicyPart.getObject();
            boolean isDurable = (Boolean)isDurablePart.getObject();
            boolean receiveUpdatesAsInvalidates = (Boolean)receiveUpdatesAsInvalidatesPart.getObject();
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            if (region == null) {
                if (isDebugEnabled && !this.quitting()) {
                    logger.debug("{}: Region named {} does not exist", this, regionName);
                }
                return;
            }
            if (!region.hasServerProxy()) {
                return;
            }
            if (key2 instanceof List) {
                region.getServerProxy().addListInterest((List)key2, InterestResultPolicy.fromOrdinal(interestResultPolicy), isDurable, receiveUpdatesAsInvalidates);
            } else {
                region.getServerProxy().addSingleInterest(key2, interestType2, InterestResultPolicy.fromOrdinal(interestResultPolicy), isDurable, receiveUpdatesAsInvalidates);
            }
        }
        catch (Exception e) {
            String message = ": The following exception occurred while attempting to add interest (region: " + regionName + " key: " + key2 + "): ";
            this.handleException(message, e);
        }
    }

    private void handleUnregisterInterest(Message m) {
        String regionName = null;
        Object key2 = null;
        int partCnt = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            if (isDebugEnabled) {
                logger.debug("{}: Received remove interest message of length ({} bytes)", this, m.getPayloadLength());
            }
            Part regionNamePart = m.getPart(partCnt++);
            Part keyPart = m.getPart(partCnt++);
            Part interestTypePart = m.getPart(partCnt++);
            Part isDurablePart = m.getPart(partCnt++);
            Part receiveUpdatesAsInvalidatesPart = m.getPart(partCnt++);
            regionName = regionNamePart.getString();
            key2 = keyPart.getStringOrObject();
            int interestType2 = (Integer)interestTypePart.getObject();
            boolean isDurable = (Boolean)isDurablePart.getObject();
            boolean receiveUpdatesAsInvalidates = (Boolean)receiveUpdatesAsInvalidatesPart.getObject();
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            if (region == null) {
                if (isDebugEnabled) {
                    logger.debug("{}: Region named {} does not exist", this, regionName);
                }
                return;
            }
            if (!region.hasServerProxy()) {
                return;
            }
            if (key2 instanceof List) {
                region.getServerProxy().removeListInterest((List)key2, isDurable, receiveUpdatesAsInvalidates);
            } else {
                region.getServerProxy().removeSingleInterest(key2, interestType2, isDurable, receiveUpdatesAsInvalidates);
            }
        }
        catch (Exception e) {
            String message = ": The following exception occurred while attempting to add interest (region: " + regionName + " key: " + key2 + "): ";
            this.handleException(message, e);
        }
    }

    private void handleTombstoneOperation(Message msg) {
        String regionName = "unknown";
        try {
            int partIdx = 0;
            regionName = msg.getPart(partIdx++).getString();
            int op = msg.getPart(partIdx++).getInt();
            LocalRegion region = (LocalRegion)this.cacheHelper.getRegion(regionName);
            if (region == null) {
                if (!this.quitting() && logger.isDebugEnabled()) {
                    logger.debug("{}: Region named {} does not exist", this, regionName);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received tombstone operation for region {} with operation={}", this, region, op);
            }
            if (!region.getConcurrencyChecksEnabled()) {
                return;
            }
            switch (op) {
                case 0: {
                    Map regionGCVersions = (Map)msg.getPart(partIdx++).getObject();
                    EventID eventID = (EventID)msg.getPart(partIdx++).getObject();
                    region.expireTombstones(regionGCVersions, eventID, null);
                    break;
                }
                case 1: {
                    Set removedKeys = (Set)msg.getPart(partIdx++).getObject();
                    region.expireTombstoneKeys(removedKeys);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown operation type " + op);
                }
            }
        }
        catch (Exception e) {
            this.handleException(": exception while removing tombstones from " + regionName, e);
        }
    }

    private boolean quitting() {
        if (this.isInterrupted()) {
            return true;
        }
        if (!this.continueProcessing.get()) {
            return true;
        }
        if (this.cache != null && this.cache.getCancelCriterion().cancelInProgress() != null) {
            return true;
        }
        return this.system.getCancelCriterion().cancelInProgress() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForFailedUpdater() {
        block8: {
            boolean gotInterrupted = false;
            try {
                if (this.failedUpdater != null) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater__0_IS_WAITING_FOR_1_TO_COMPLETE, new Object[]{this, this.failedUpdater}));
                    while (this.failedUpdater.isAlive()) {
                        if (this.quitting()) {
                            if (gotInterrupted) return;
                            if (this.failedUpdater == null) return;
                            break block8;
                        }
                        this.failedUpdater.join(5000L);
                    }
                }
                if (gotInterrupted) return;
                if (this.failedUpdater == null) return;
            }
            catch (InterruptedException ie) {
                try {
                    return;
                }
                catch (Throwable throwable) {
                    if (gotInterrupted) throw throwable;
                    if (this.failedUpdater == null) throw throwable;
                    logger.info(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_HAS_COMPLETED_WAITING_FOR_1, new Object[]{this, this.failedUpdater}));
                    this.failedUpdater = null;
                    throw throwable;
                }
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_HAS_COMPLETED_WAITING_FOR_1, new Object[]{this, this.failedUpdater}));
            this.failedUpdater = null;
            return;
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_HAS_COMPLETED_WAITING_FOR_1, new Object[]{this, this.failedUpdater}));
        this.failedUpdater = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessages() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            Part eid = null;
            Message _message = this.initializeMessage();
            if (this.quitting()) {
                if (isDebugEnabled) {
                    logger.debug("processMessages quitting early because we have stopped");
                }
                return;
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_READY_TO_PROCESS_MESSAGES, this));
            while (this.continueProcessing.get()) {
                if (this.quitting()) {
                    if (isDebugEnabled) {
                        logger.debug("termination detected");
                    }
                    return;
                }
                if (this.endpoint.isClosed()) {
                    if (isDebugEnabled) {
                        logger.debug("endpoint died");
                    }
                    this.continueProcessing.set(false);
                    break;
                }
                try {
                    boolean isCreateOrUpdate;
                    _message.recv();
                    this.waitForFailedUpdater();
                    this.cache.waitForRegisterInterestsInProgress();
                    if (this.quitting()) {
                        if (isDebugEnabled) {
                            logger.debug("processMessages quitting before processing message");
                        }
                        break;
                    }
                    if (_message.getMessageType() == 99) {
                        if (!isDebugEnabled) continue;
                        logger.debug("{}: Received ping", this);
                        continue;
                    }
                    boolean isDeltaSent = false;
                    boolean bl = isCreateOrUpdate = _message.getMessageType() == 27 || _message.getMessageType() == 28;
                    if (isCreateOrUpdate) {
                        isDeltaSent = (Boolean)_message.getPart(2).getObject();
                    }
                    int numberOfParts = _message.getNumberOfParts();
                    eid = _message.getPart(numberOfParts - 1);
                    EventID eventId = (EventID)eid.getObject();
                    if (_message.getMessageType() != 51 && _message.getMessageType() != 67 && this.qManager.getState().verifyIfDuplicate(eventId, !this.isDurableClient && !isDeltaSent)) continue;
                    if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                        logger.trace(LogMarker.BRIDGE_SERVER, "Processing event with id {}" + eventId.expensiveToString());
                    }
                    this.isOpCompleted = true;
                    switch (_message.getMessageType()) {
                        case 27: 
                        case 28: {
                            this.handleUpdate(_message);
                            break;
                        }
                        case 15: {
                            this.handleInvalidate(_message);
                            break;
                        }
                        case 16: {
                            this.handleDestroy(_message);
                            break;
                        }
                        case 17: {
                            this.handleDestroyRegion(_message);
                            break;
                        }
                        case 36: {
                            this.handleClearRegion(_message);
                            break;
                        }
                        case 51: {
                            this.handleRegisterInstantiator(_message, eventId);
                            break;
                        }
                        case 67: {
                            this.handleRegisterDataSerializer(_message, eventId);
                            break;
                        }
                        case 54: {
                            this.handleMarker(_message);
                            break;
                        }
                        case 55: {
                            this.handleInvalidateRegion(_message);
                            break;
                        }
                        case 65: {
                            this.handleRegisterInterest(_message);
                            break;
                        }
                        case 66: {
                            this.handleUnregisterInterest(_message);
                            break;
                        }
                        case 103: {
                            this.handleTombstoneOperation(_message);
                            break;
                        }
                        default: {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0_RECEIVED_AN_UNSUPPORTED_MESSAGE_TYPE_1, new Object[]{this, MessageType.getString(_message.getMessageType())}));
                        }
                    }
                    if (!this.isOpCompleted || !this.isDurableClient && !isDeltaSent) continue;
                    this.qManager.getState().verifyIfDuplicate(eventId, true);
                }
                catch (InterruptedIOException e) {
                    this.endPointDied = true;
                    this.continueProcessing.set(false);
                    if (!isDebugEnabled) continue;
                    logger.debug("InterruptedIOException");
                }
                catch (IOException e) {
                    this.endPointDied = true;
                    if (!this.quitting()) {
                        String message = ": Caught the following exception and will exit: ";
                        String errMessage = e.getMessage();
                        if (errMessage == null) {
                            errMessage = "";
                        }
                        BridgeObserver bo = BridgeObserverHolder.getInstance();
                        bo.beforeFailoverByCacheClientUpdater(this.location);
                        this.eManager.serverCrashed(this.endpoint);
                        if (isDebugEnabled) {
                            logger.debug("" + message + e);
                        }
                    }
                    this.continueProcessing.set(false);
                    if (!isDebugEnabled) continue;
                    logger.debug("terminated due to IOException");
                }
                catch (Exception e) {
                    if (!this.quitting()) {
                        this.endPointDied = true;
                        BridgeObserver bo = BridgeObserverHolder.getInstance();
                        bo.beforeFailoverByCacheClientUpdater(this.location);
                        this.eManager.serverCrashed(this.endpoint);
                        String message = ": Caught the following exception and will exit: ";
                        this.handleException(message, e);
                    }
                    this.continueProcessing.set(false);
                    if (!isDebugEnabled) continue;
                    logger.debug("CCU terminated due to Exception");
                }
                finally {
                    _message.clear();
                }
            }
        }
        finally {
            if (isDebugEnabled) {
                logger.debug("has stopped and cleaning the helper ..");
            }
            this.close();
            this.qManager.checkEndpoint(this, this.endpoint);
        }
    }

    private void handleException(String message, Exception exception) {
        boolean unexpected;
        boolean bl = unexpected = !this.quitting();
        if (unexpected && !(exception instanceof CancelException)) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.CacheClientUpdater_0__1__2, new Object[]{this, message, exception}), (Throwable)exception);
        }
    }

    private Object deserialize(byte[] serializedBytes) {
        Object deserializedObject = serializedBytes;
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(serializedBytes));
            deserializedObject = DataSerializer.readObject(dis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedObject;
    }

    protected int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void onDisconnect(InternalDistributedSystem sys) {
        this.stopUpdater();
    }

    public boolean isEndPointDead() {
        return this.endPointDied;
    }

    private void verifySocketBufferSize(int requestedBufferSize, int actualBufferSize, String type) {
        if (actualBufferSize < requestedBufferSize) {
            logger.info(LocalizedMessage.create(LocalizedStrings.Connection_SOCKET_0_IS_1_INSTEAD_OF_THE_REQUESTED_2, new Object[]{type + " buffer size", actualBufferSize, requestedBufferSize}));
        }
    }

    @Override
    public boolean isProcessing() {
        return this.continueProcessing.get();
    }

    static {
        fullValueRequested = false;
        MAX_CACHE_WAIT = Long.getLong("gemfire.CacheClientUpdater.MAX_WAIT", 120L);
    }

    public static class CCUStats
    implements MessageStats {
        private static final StatisticsType type;
        private static final int messagesBeingReceivedId;
        private static final int messageBytesBeingReceivedId;
        private static final int receivedBytesId;
        private final Statistics stats;

        public CCUStats(DistributedSystem ids, ServerLocation location) {
            this.stats = ids.createStatistics(type, "CacheClientUpdater-" + location);
        }

        public void close() {
            this.stats.close();
        }

        @Override
        public final void incReceivedBytes(long v) {
            this.stats.incLong(receivedBytesId, v);
        }

        @Override
        public final void incSentBytes(long v) {
        }

        @Override
        public void incMessagesBeingReceived(int bytes) {
            this.stats.incInt(messagesBeingReceivedId, 1);
            if (bytes > 0) {
                this.stats.incLong(messageBytesBeingReceivedId, (long)bytes);
            }
        }

        @Override
        public void decMessagesBeingReceived(int bytes) {
            this.stats.incInt(messagesBeingReceivedId, -1);
            if (bytes > 0) {
                this.stats.incLong(messageBytesBeingReceivedId, (long)(-bytes));
            }
        }

        public long startTime() {
            return DistributionStats.getStatTime();
        }

        static {
            StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
            type = f.createType("CacheClientUpdaterStats", "Statistics about incoming subscription data", new StatisticDescriptor[]{f.createLongCounter("receivedBytes", "Total number of bytes received from the server.", "bytes"), f.createIntGauge("messagesBeingReceived", "Current number of message being received off the network or being processed after reception.", "messages"), f.createLongGauge("messageBytesBeingReceived", "Current number of bytes consumed by messages being received or processed.", "bytes")});
            receivedBytesId = type.nameToId("receivedBytes");
            messagesBeingReceivedId = type.nameToId("messagesBeingReceived");
            messageBytesBeingReceivedId = type.nameToId("messageBytesBeingReceived");
        }
    }
}

