/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ClientInterestMessageImpl
implements ClientMessage {
    private static final long serialVersionUID = -797925585426839008L;
    private EventID eventId;
    private Object keyOfInterest;
    private String regionName;
    private boolean isDurable;
    private boolean forUpdatesAsInvalidates;
    private int interestType;
    private byte interestResultPolicy;
    private byte action;
    protected static final byte REGISTER = 0;
    protected static final byte UNREGISTER = 1;

    public ClientInterestMessageImpl(EventID eventId, String regionName, Object keyOfInterest, int interestType2, byte interestResultPolicy, boolean isDurable, boolean sendUpdatesAsInvalidates, byte action) {
        this.eventId = eventId;
        this.regionName = regionName;
        this.keyOfInterest = keyOfInterest;
        this.interestType = interestType2;
        this.interestResultPolicy = interestResultPolicy;
        this.isDurable = isDurable;
        this.forUpdatesAsInvalidates = sendUpdatesAsInvalidates;
        this.action = action;
    }

    public ClientInterestMessageImpl() {
    }

    @Override
    public Message getMessage(CacheClientProxy proxy, boolean notify) throws IOException {
        Version clientVersion = proxy.getVersion();
        Message message = null;
        if (clientVersion.compareTo(Version.GFE_57) < 0) {
            throw new IOException("Unsupported client version for server-to-client message creation: " + clientVersion);
        }
        message = this.getGFEMessage();
        return message;
    }

    protected Message getGFEMessage() throws IOException {
        Message message = new Message(this.isRegister() ? 7 : 6, Version.CURRENT);
        message.setTransactionId(0);
        switch (this.action) {
            case 0: {
                message.setMessageType(65);
                break;
            }
            case 1: {
                message.setMessageType(66);
                break;
            }
            default: {
                String s = "Unknown action: " + this.action;
                throw new IOException(s);
            }
        }
        message.addStringPart(this.regionName);
        message.addStringOrObjPart(this.keyOfInterest);
        message.addObjPart(this.interestType);
        if (this.isRegister()) {
            message.addObjPart(this.interestResultPolicy);
        }
        message.addObjPart(this.isDurable);
        message.addObjPart(this.forUpdatesAsInvalidates);
        message.addObjPart(this.eventId);
        return message;
    }

    @Override
    public boolean shouldBeConflated() {
        return false;
    }

    @Override
    public int getDSFID() {
        return -21;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.toData(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeString(this.regionName, out);
        DataSerializer.writeObject(this.keyOfInterest, out);
        DataSerializer.writePrimitiveBoolean(this.isDurable, out);
        DataSerializer.writePrimitiveBoolean(this.forUpdatesAsInvalidates, out);
        DataSerializer.writePrimitiveInt(this.interestType, out);
        DataSerializer.writePrimitiveByte(this.interestResultPolicy, out);
        DataSerializer.writePrimitiveByte(this.action, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.regionName = DataSerializer.readString(in);
        this.keyOfInterest = DataSerializer.readObject(in);
        this.isDurable = DataSerializer.readPrimitiveBoolean(in);
        this.forUpdatesAsInvalidates = DataSerializer.readPrimitiveBoolean(in);
        this.interestType = DataSerializer.readPrimitiveInt(in);
        this.interestResultPolicy = DataSerializer.readPrimitiveByte(in);
        this.action = DataSerializer.readPrimitiveByte(in);
    }

    @Override
    public EventID getEventId() {
        return this.eventId;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Object getKeyOfInterest() {
        return this.keyOfInterest;
    }

    public int getInterestType() {
        return this.interestType;
    }

    public boolean getIsDurable() {
        return this.isDurable;
    }

    public boolean getForUpdatesAsInvalidates() {
        return this.forUpdatesAsInvalidates;
    }

    public boolean isKeyInterest() {
        return this.interestType == 0;
    }

    public boolean isRegister() {
        return this.action == 0;
    }

    @Override
    public String getRegionToConflate() {
        return null;
    }

    @Override
    public Object getKeyToConflate() {
        return "interest";
    }

    @Override
    public Object getValueToConflate() {
        return "interest";
    }

    @Override
    public void setLatestValue(Object value2) {
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

