/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.Acceptor;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class ClientTombstoneMessage
extends ClientUpdateMessageImpl {
    private Object removalInformation;
    private TOperation op;

    public static ClientTombstoneMessage gc(LocalRegion region, Map<VersionSource, Long> regionGCVersions, EventID eventId) {
        return new ClientTombstoneMessage(TOperation.GC, region, regionGCVersions, eventId);
    }

    public static ClientTombstoneMessage gc(LocalRegion region, Set<Object> removedKeys, EventID eventId) {
        return new ClientTombstoneMessage(TOperation.GC_PR, region, removedKeys, eventId);
    }

    private ClientTombstoneMessage(TOperation op, LocalRegion region, Object removalInformation, EventID eventId) {
        super(EnumListenerEvent.AFTER_TOMBSTONE_EXPIRATION, null, eventId);
        this.op = op;
        this.removalInformation = removalInformation;
        this.setRegionName(region.getFullPath());
    }

    public ClientTombstoneMessage() {
    }

    @Override
    public boolean shouldBeConflated() {
        return false;
    }

    @Override
    protected Message getMessage(CacheClientProxy proxy, byte[] latestValue) throws IOException {
        if (Version.GFE_70.compareTo(proxy.getVersion()) <= 0) {
            return this.getGFE70Message(proxy.getVersion());
        }
        return null;
    }

    protected Message getGFE70Message(Version clientVersion) {
        Message message = null;
        int numParts = 4;
        message = new Message(numParts, clientVersion);
        message.setMessageType(103);
        message.addStringPart(this.getRegionName());
        message.addIntPart(this.op.ordinal());
        message.addObjPart(this.removalInformation);
        message.addObjPart(this.getEventId());
        return message;
    }

    @Override
    public int getDSFID() {
        return -133;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeByte(this.op.ordinal());
        out.writeByte(this._operation.getEventCode());
        DataSerializer.writeString(this.getRegionName(), out);
        DataSerializer.writeObject(this.removalInformation, out);
        DataSerializer.writeObject(this._membershipId, out);
        DataSerializer.writeObject(this._eventIdentifier, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.op = TOperation.values()[in.readByte()];
        this._operation = EnumListenerEvent.getEnumListenerEvent(in.readByte());
        this.setRegionName(DataSerializer.readString(in));
        this.removalInformation = DataSerializer.readObject(in);
        this._membershipId = ClientProxyMembershipID.readCanonicalized(in);
        this._eventIdentifier = (EventID)DataSerializer.readObject(in);
    }

    @Override
    public Object getKeyToConflate() {
        return null;
    }

    @Override
    public String getRegionToConflate() {
        return null;
    }

    @Override
    public Object getValueToConflate() {
        return null;
    }

    @Override
    public void setLatestValue(Object value2) {
    }

    @Override
    public boolean isClientInterested(ClientProxyMembershipID clientId) {
        return Acceptor.VERSION.compareTo(Version.GFE_70) >= 0;
    }

    @Override
    public boolean needsNoAuthorizationCheck() {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClientTombstoneMessage[op=").append((Object)this.op).append(";region=").append(this.getRegionName()).append(";removalInfo=").append(this.removalInformation).append(";memberId=").append(this.getMembershipId()).append(";eventId=").append(this.getEventId()).append("]");
        return buffer.toString();
    }

    static enum TOperation {
        GC,
        GC_PR;

    }
}

