/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.internal.cache.tier.sockets.UserAuthAttributes;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class ClientUserAuths {
    private Random uniqueIdGenerator = null;
    private int m_seed;
    private long m_firstId;
    private ConcurrentHashMap<Long, UserAuthAttributes> uniqueIdVsUserAuth = new ConcurrentHashMap();
    private ConcurrentHashMap<String, UserAuthAttributes> cqNameVsUserAuth = new ConcurrentHashMap();

    public long putUserAuth(UserAuthAttributes userAuthAttr) {
        long newId = this.getNextID();
        this.uniqueIdVsUserAuth.put(newId, userAuthAttr);
        return newId;
    }

    public ClientUserAuths(int clientProxyHashcode) {
        this.m_seed = clientProxyHashcode;
        this.uniqueIdGenerator = new Random((long)this.m_seed + System.currentTimeMillis());
        this.m_firstId = this.uniqueIdGenerator.nextLong();
    }

    private synchronized long getNextID() {
        long uniqueId = this.uniqueIdGenerator.nextLong();
        if (uniqueId == this.m_firstId) {
            this.uniqueIdGenerator = new Random((long)this.m_seed + System.currentTimeMillis());
            this.m_firstId = this.uniqueIdGenerator.nextLong();
            this.uniqueIdVsUserAuth.clear();
            return this.m_firstId;
        }
        return uniqueId;
    }

    public UserAuthAttributes getUserAuthAttributes(long userId) {
        return this.uniqueIdVsUserAuth.get(userId);
    }

    public UserAuthAttributes getUserAuthAttributes(String cqName) {
        return this.cqNameVsUserAuth.get(cqName);
    }

    public void setUserAuthAttributesForCq(String cqName, long uniqueId, boolean isDurable) {
        UserAuthAttributes uaa = this.uniqueIdVsUserAuth.get(uniqueId);
        if (uaa != null) {
            if (!isDurable) {
                this.cqNameVsUserAuth.put(cqName, uaa);
            } else {
                UserAuthAttributes oldUaa = this.cqNameVsUserAuth.put(cqName, uaa);
                if (oldUaa != null) {
                    if (oldUaa != uaa) {
                        this.cleanUserAuth(oldUaa);
                        uaa.setDurable();
                    }
                } else {
                    uaa.setDurable();
                }
            }
        } else {
            throw new NotAuthorizedException("User is not authorized for CQ");
        }
    }

    public void removeUserAuthAttributesForCq(String cqName, boolean isDurable) {
        UserAuthAttributes uaa = this.cqNameVsUserAuth.remove(cqName);
        if (uaa != null && isDurable) {
            uaa.unsetDurable();
        }
    }

    public boolean removeUserId(long userId, boolean keepAlive) {
        UserAuthAttributes uaa = this.uniqueIdVsUserAuth.get(userId);
        if (!(uaa == null || uaa.isDurable() && keepAlive || (uaa = this.uniqueIdVsUserAuth.remove(userId)) == null)) {
            this.cleanUserAuth(uaa);
            return true;
        }
        return false;
    }

    public void cleanUserAuth(UserAuthAttributes userAuth) {
        if (userAuth != null) {
            AuthorizeRequest authReq = userAuth.getAuthzRequest();
            try {
                if (authReq != null) {
                    authReq.close();
                    authReq = null;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                AuthorizeRequestPP postAuthzReq = userAuth.getPostAuthzRequest();
                if (postAuthzReq != null) {
                    postAuthzReq.close();
                    postAuthzReq = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cleanup(boolean fromCacheClientProxy) {
        for (UserAuthAttributes userAuth : this.uniqueIdVsUserAuth.values()) {
            if (!fromCacheClientProxy && !userAuth.isDurable()) {
                this.cleanUserAuth(userAuth);
                continue;
            }
            if (!fromCacheClientProxy || !userAuth.isDurable()) continue;
            this.cleanUserAuth(userAuth);
        }
    }

    public void fillPreviousCQAuth(ClientUserAuths previousClientUserAuths) {
        for (Map.Entry<String, UserAuthAttributes> ent : previousClientUserAuths.cqNameVsUserAuth.entrySet()) {
            UserAuthAttributes prevUaa;
            String cqName = ent.getKey();
            UserAuthAttributes newUaa = this.cqNameVsUserAuth.putIfAbsent(cqName, prevUaa = ent.getValue());
            if (newUaa == null) continue;
            previousClientUserAuths.cleanUserAuth(prevUaa);
        }
    }
}

