/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import java.util.concurrent.atomic.AtomicInteger;

public class UserAuthAttributes {
    private AtomicInteger numberOfDurableCQ;
    private AuthorizeRequest authzRequest;
    private AuthorizeRequestPP postAuthzRequest;

    public UserAuthAttributes(AuthorizeRequest authzRequest, AuthorizeRequestPP postAuthzRequest) {
        this.authzRequest = authzRequest;
        this.postAuthzRequest = postAuthzRequest;
        this.numberOfDurableCQ = new AtomicInteger();
    }

    public AuthorizeRequest getAuthzRequest() {
        return this.authzRequest;
    }

    public AuthorizeRequestPP getPostAuthzRequest() {
        return this.postAuthzRequest;
    }

    public void setDurable() {
        this.numberOfDurableCQ.incrementAndGet();
    }

    public void unsetDurable() {
        this.numberOfDurableCQ.decrementAndGet();
    }

    public boolean isDurable() {
        return this.numberOfDurableCQ.intValue() != 0;
    }
}

