/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;

public class ClientReady
extends BaseCommand {
    private static final ClientReady singleton = new ClientReady();

    public static Command getCommand() {
        return singleton;
    }

    private ClientReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CacheServerStats stats = servConn.getCacheServerStats();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadClientReadyRequestTime(start - oldStart);
        try {
            String clientHost = servConn.getSocketHost();
            int clientPort = servConn.getSocketPort();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received client ready request ({} bytes) from {} on {}:{}", servConn.getName(), msg.getPayloadLength(), servConn.getProxyID(), clientHost, clientPort);
            }
            servConn.getAcceptor().getCacheClientNotifier().readyForEvents(servConn.getProxyID());
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessClientReadyTime(start - oldStart2);
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            if (logger.isDebugEnabled()) {
                logger.debug(servConn.getName() + ": Processed client ready request from " + servConn.getProxyID() + " on " + clientHost + ":" + clientPort);
            }
        }
        finally {
            stats.incWriteClientReadyResponseTime(DistributionStats.getStatTime() - start);
        }
    }
}

