/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.operations.DestroyOperationContext;
import com.gemstone.gemfire.cache.operations.RegionDestroyOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Destroy65
extends BaseCommand {
    private static final Destroy65 singleton = new Destroy65();

    public static Command getCommand() {
        return singleton;
    }

    protected Destroy65() {
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr2, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr2, boolean entryNotFoundForRemove, byte nwHop, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr2.getMetadataVersion(), nwHop});
        pr2.getPrStats().incPRMetaDataSentCount();
        replyMsg.addIntPart(entryNotFoundForRemove ? 1 : 0);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", servConn.getName(), origMsg.getTransactionId());
        }
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, boolean entryNotFound, VersionTag tag) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        replyMsg.setNumberOfParts(2);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(OK_BYTES);
        replyMsg.addIntPart(entryNotFound ? 1 : 0);
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {} parts={}", servConn.getName(), origMsg.getTransactionId(), replyMsg.getNumberOfParts());
        }
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Object operation = null;
        Object expectedOldValue = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long now = DistributionStats.getStatTime();
        stats.incReadDestroyRequestTime(now - start);
        Part regionNamePart = msg.getPart(0);
        Part keyPart = msg.getPart(1);
        Part expectedOldValuePart = msg.getPart(2);
        try {
            operation = msg.getPart(3).getObject();
            if (operation instanceof Operation && (Operation)operation == Operation.REMOVE || operation instanceof Byte && (Byte)operation == 8) {
                expectedOldValue = expectedOldValuePart.getObject();
            }
        }
        catch (Exception e) {
            Destroy65.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        Part eventPart = msg.getPart(4);
        if (msg.getNumberOfParts() > 5) {
            Part callbackArgPart = msg.getPart(5);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Destroy65.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Destroy65.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy65 request ({} bytes; op={}) from {} for region {} key {}{} txId {}", servConn.getName(), msg.getPayloadLength(), operation, servConn.getSocketString(), regionName, key2, operation == Operation.REMOVE ? " value=" + expectedOldValue : "", msg.getTransactionId());
        }
        boolean entryNotFoundForRemove = false;
        if (key2 == null || regionName == null) {
            if (key2 == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            if (regionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            Destroy65.writeErrorResponse(msg, 10, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Destroy__0_WAS_NOT_FOUND_DURING_DESTROY_REQUEST.toLocalizedString(regionName);
                Destroy65.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
                long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
                EntryEventImpl clientEvent = new EntryEventImpl(eventId);
                Breadcrumbs.setEventId(eventId);
                if (msg.isRetry()) {
                    clientEvent.setPossibleDuplicate(true);
                    if (region.getAttributes().getConcurrencyChecksEnabled()) {
                        clientEvent.setRegion(region);
                        if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                            clientEvent.setPossibleDuplicate(false);
                        }
                    }
                }
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                            RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize((String)key2, callbackArg);
                            callbackArg = destroyContext.getCallbackArg();
                        } else {
                            DestroyOperationContext destroyContext = authzRequest.destroyAuthorize(regionName, key2, callbackArg);
                            callbackArg = destroyContext.getCallbackArg();
                        }
                    }
                    if (operation == null || operation == Operation.DESTROY) {
                        region.basicBridgeDestroy(key2, callbackArg, servConn.getProxyID(), true, clientEvent);
                    } else {
                        try {
                            if (expectedOldValue == null && operation != null) {
                                expectedOldValue = Token.INVALID;
                            }
                            if (operation == Operation.REMOVE && msg.isRetry() && clientEvent.getVersionTag() != null) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("remove(k,v) operation was successful last time with version {}", clientEvent.getVersionTag());
                                }
                                try {
                                    region.basicBridgeRemove(key2, expectedOldValue, callbackArg, servConn.getProxyID(), true, clientEvent);
                                }
                                catch (EntryNotFoundException e) {}
                            } else {
                                region.basicBridgeRemove(key2, expectedOldValue, callbackArg, servConn.getProxyID(), true, clientEvent);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("region.remove succeeded");
                                }
                            }
                        }
                        catch (EntryNotFoundException e) {
                            servConn.setModificationInfo(true, regionName, key2);
                            if (logger.isDebugEnabled()) {
                                logger.debug("writing entryNotFound response");
                            }
                            entryNotFoundForRemove = true;
                        }
                    }
                    servConn.setModificationInfo(true, regionName, key2);
                }
                catch (EntryNotFoundException e) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.Destroy_0_DURING_ENTRY_DESTROY_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{servConn.getName(), key2}));
                    entryNotFoundForRemove = true;
                }
                catch (RegionDestroyedException rde) {
                    Destroy65.writeException(msg, rde, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                catch (Exception e) {
                    Destroy65.checkForInterrupt(servConn, e);
                    Destroy65.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    if (e instanceof GemFireSecurityException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Unexpected Security exception", servConn.getName(), e);
                        }
                    } else {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                    }
                    return;
                }
                now = DistributionStats.getStatTime();
                stats.incProcessDestroyTime(now - start);
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr2 = (PartitionedRegion)region;
                    if (pr2.isNetworkHop() != 0) {
                        this.writeReplyWithRefreshMetadata(msg, servConn, pr2, entryNotFoundForRemove, pr2.isNetworkHop(), clientEvent.getVersionTag());
                        pr2.setIsNetworkHop((byte)0);
                        pr2.setMetadataVersion((byte)0);
                    } else {
                        this.writeReply(msg, servConn, entryNotFoundForRemove | clientEvent.getIsRedestroyedEntry(), clientEvent.getVersionTag());
                    }
                } else {
                    this.writeReply(msg, servConn, entryNotFoundForRemove | clientEvent.getIsRedestroyedEntry(), clientEvent.getVersionTag());
                }
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent destroy response for region {} key {}", servConn.getName(), regionName, key2);
                }
                stats.incWriteDestroyResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }
}

