/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.wan.BatchException70;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverStats;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.pdx.PdxConfigurationException;
import com.gemstone.gemfire.pdx.PdxRegistryMismatchException;
import java.io.IOException;
import java.util.List;

public class GatewayReceiverCommand
extends BaseCommand {
    private static final GatewayReceiverCommand singleton = new GatewayReceiverCommand();

    public static Command getCommand() {
        return singleton;
    }

    private GatewayReceiverCommand() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CASE], 30[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleMessageRetry(Message msg, LocalRegion region, EntryEventImpl clientEvent) {
        if (msg.isRetry()) {
            clientEvent.setPossibleDuplicate(true);
            if (region.getAttributes().getConcurrencyChecksEnabled()) {
                clientEvent.setRegion(region);
                if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                    clientEvent.setPossibleDuplicate(false);
                }
            }
        }
    }

    private void writeReply(Message msg, ServerConnection servConn, int batchId, int numberOfEvents) throws IOException {
        Message replyMsg = servConn.getResponseMessage();
        replyMsg.setMessageType(6);
        replyMsg.setTransactionId(msg.getTransactionId());
        replyMsg.setNumberOfParts(2);
        replyMsg.addIntPart(batchId);
        replyMsg.addIntPart(numberOfEvents);
        replyMsg.setTransactionId(msg.getTransactionId());
        replyMsg.send(servConn);
        servConn.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: rpl tx: {} batchId {} numberOfEvents: {}", servConn.getName(), msg.getTransactionId(), batchId, numberOfEvents);
        }
    }

    private static void writeBatchException(Message origMsg, List<BatchException70> exceptions, ServerConnection servConn, int batchId) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(2);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addObjPart(exceptions);
        errorMsg.send(servConn);
        for (Exception exception : exceptions) {
            ((GatewayReceiverStats)servConn.getCacheServerStats()).incExceptionsOccured();
        }
        for (Exception exception : exceptions) {
            if (!logger.isWarnEnabled()) continue;
            logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_WROTE_BATCH_EXCEPTION, servConn.getName()), (Throwable)exception);
        }
    }

    private static void writeFatalException(Message origMsg, Throwable exception, ServerConnection servConn, int batchId) throws IOException {
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(2);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        if ((servConn.getClientVersion() == null || servConn.getClientVersion().compareTo(Version.GFE_80) < 0) && exception instanceof PdxRegistryMismatchException) {
            PdxConfigurationException newException = new PdxConfigurationException(exception.getMessage());
            newException.setStackTrace(exception.getStackTrace());
            exception = newException;
        }
        errorMsg.addObjPart(exception);
        errorMsg.send(servConn);
        logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_WROTE_BATCH_EXCEPTION, servConn.getName()), exception);
    }
}

