/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.GetOperationContext;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.Get70;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class GetAll70
extends BaseCommand {
    private static final GetAll70 singleton = new GetAll70();

    public static Command getCommand() {
        return singleton;
    }

    protected GetAll70() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        boolean requestSerializedValues;
        Part regionNamePart = null;
        Part keysPart = null;
        String regionName = null;
        Object[] keys = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        int partIdx = 0;
        regionNamePart = msg.getPart(partIdx++);
        regionName = regionNamePart.getString();
        keysPart = msg.getPart(partIdx++);
        try {
            keys = (Object[])keysPart.getObject();
        }
        catch (Exception e) {
            GetAll70.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean bl = requestSerializedValues = msg.getPart(partIdx++).getInt() == 1;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(servConn.getName()).append(": Received getAll request (").append(msg.getPayloadLength()).append(" bytes) from ").append(servConn.getSocketString()).append(" for region ").append(regionName).append(" keys ");
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    buffer.append(keys[i]).append(" ");
                }
            } else {
                buffer.append("NULL");
            }
            logger.debug(buffer.toString());
        }
        if (regionName == null) {
            String message = null;
            message = LocalizedStrings.GetAll_THE_INPUT_REGION_NAME_FOR_THE_GETALL_REQUEST_IS_NULL.toLocalizedString();
            logger.warn("{}: {}", servConn.getName(), message);
            GetAll70.writeChunkedErrorResponse(msg, 58, message, servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during getAll request";
                GetAll70.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
                chunkedResponseMsg.setMessageType(1);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                try {
                    this.fillAndSendGetAllResponseChunks(region, regionName, keys, servConn, requestSerializedValues);
                    servConn.setAsTrue(1);
                }
                catch (Exception e) {
                    GetAll70.checkForInterrupt(servConn, e);
                    GetAll70.writeChunkedException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
        }
    }

    private void fillAndSendGetAllResponseChunks(Region region, String regionName, Object[] keys, ServerConnection servConn, boolean requestSerializedValues) throws IOException {
        int numKeys;
        Iterator allKeysIter;
        if (keys != null) {
            allKeysIter = null;
            numKeys = keys.length;
        } else {
            Set allKeys = region.keySet();
            allKeysIter = allKeys.iterator();
            numKeys = allKeys.size();
        }
        VersionedObjectList values = new VersionedObjectList(maximumChunkSize, keys == null, region.getAttributes().getConcurrencyChecksEnabled(), requestSerializedValues);
        AuthorizeRequest authzRequest = servConn.getAuthzRequest();
        AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
        Get70 request = (Get70)Get70.getCommand();
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (int i = 0; i < numKeys; ++i) {
            Get70.Entry entry;
            Object key2;
            boolean keyNotPresent;
            block15: {
                GetOperationContext getContext;
                block14: {
                    if (values.size() == maximumChunkSize) {
                        values.setKeys(null);
                        GetAll70.sendGetAllResponseChunk(region, values, false, servConn);
                        values.clear();
                    }
                    keyNotPresent = false;
                    key2 = keys != null ? keys[i] : allKeysIter.next();
                    if (isDebugEnabled) {
                        logger.debug("{}: Getting value for key={}", servConn.getName(), key2);
                    }
                    getContext = null;
                    if (authzRequest != null) {
                        try {
                            getContext = authzRequest.getAuthorize(regionName, key2, null);
                            if (!isDebugEnabled) break block14;
                            logger.debug("{}: Passed GET pre-authorization for key={}", servConn.getName(), key2);
                        }
                        catch (NotAuthorizedException ex) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{servConn.getName(), key2}), (Throwable)ex);
                            values.addExceptionPart(key2, ex);
                            continue;
                        }
                    }
                }
                entry = request.getValueAndIsObject(region, key2, null, servConn);
                keyNotPresent = entry.keyNotPresent;
                if (isDebugEnabled) {
                    logger.debug("retrieved key={} {}", key2, entry);
                }
                if (postAuthzRequest != null) {
                    try {
                        getContext = postAuthzRequest.getAuthorize(regionName, key2, entry.value, entry.isObject, getContext);
                        byte[] serializedValue = getContext.getSerializedValue();
                        entry.value = serializedValue == null ? getContext.getObject() : (Object)serializedValue;
                        entry.isObject = getContext.isObject();
                        if (!isDebugEnabled) break block15;
                        logger.debug("{}: Passed GET post-authorization for key={}: {}", servConn.getName(), key2, entry.value);
                    }
                    catch (NotAuthorizedException ex) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{servConn.getName(), key2}), (Throwable)ex);
                        values.addExceptionPart(key2, ex);
                        continue;
                    }
                }
            }
            if (keyNotPresent) {
                values.addObjectPartForAbsentKey(key2, entry.value, entry.versionTag);
                continue;
            }
            values.addObjectPart(key2, entry.value, entry.isObject, entry.versionTag);
        }
        if (Version.GFE_701.compareTo(servConn.getClientVersion()) <= 0) {
            values.setKeys(null);
        }
        GetAll70.sendGetAllResponseChunk(region, values, true, servConn);
        servConn.setAsTrue(1);
    }

    private static void sendGetAllResponseChunk(Region region, ObjectPartList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} getAll response chunk for region={}{}", servConn.getName(), lastChunk ? " last " : " ", region.getFullPath(), logger.isTraceEnabled() ? " values=" + list + " chunk=<" + chunkedResponseMsg + ">" : "");
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

