/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.Set;

public class GetClientPartitionAttributesCommand66
extends BaseCommand {
    private static final GetClientPartitionAttributesCommand66 singleton = new GetClientPartitionAttributesCommand66();

    public static Command getCommand() {
        return singleton;
    }

    private GetClientPartitionAttributesCommand66() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException, InterruptedException {
        String regionFullPath = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        regionFullPath = msg.getPart(0).getString();
        String errMessage = "";
        if (regionFullPath == null) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.GetClientPartitionAttributes_THE_INPUT_REGION_PATH_IS_NULL));
            errMessage = LocalizedStrings.GetClientPartitionAttributes_THE_INPUT_REGION_PATH_IS_NULL.toLocalizedString();
            GetClientPartitionAttributesCommand66.writeErrorResponse(msg, 76, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            Region region = crHelper.getRegion(regionFullPath);
            if (region == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GetClientPartitionAttributes_REGION_NOT_FOUND_FOR_SPECIFIED_REGION_PATH, regionFullPath));
                errMessage = LocalizedStrings.GetClientPartitionAttributes_REGION_NOT_FOUND.toLocalizedString() + regionFullPath;
                GetClientPartitionAttributesCommand66.writeErrorResponse(msg, 76, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
            } else {
                try {
                    Message responseMsg = servConn.getResponseMessage();
                    responseMsg.setTransactionId(msg.getTransactionId());
                    responseMsg.setMessageType(74);
                    if (!(region instanceof PartitionedRegion)) {
                        responseMsg.setNumberOfParts(2);
                        responseMsg.addObjPart(-1);
                        responseMsg.addObjPart(region.getFullPath());
                    } else {
                        PartitionedRegion prRgion = (PartitionedRegion)region;
                        PartitionResolver partitionResolver = prRgion.getPartitionResolver();
                        int numParts = 2;
                        if (partitionResolver != null) {
                            ++numParts;
                        }
                        if (prRgion.isFixedPartitionedRegion()) {
                            ++numParts;
                        }
                        responseMsg.setNumberOfParts(numParts);
                        responseMsg.addObjPart(prRgion.getTotalNumberOfBuckets());
                        String leaderRegionPath = null;
                        PartitionedRegion leaderRegion = null;
                        String leaderRegionName = prRgion.getColocatedWith();
                        if (leaderRegionName != null) {
                            GemFireCacheImpl cache = prRgion.getCache();
                            while (leaderRegionName != null) {
                                leaderRegion = (PartitionedRegion)cache.getRegion(leaderRegionName);
                                if (leaderRegion.getColocatedWith() == null) {
                                    leaderRegionPath = leaderRegion.getFullPath();
                                    break;
                                }
                                leaderRegionName = leaderRegion.getColocatedWith();
                            }
                        }
                        responseMsg.addObjPart(leaderRegionPath);
                        if (partitionResolver != null) {
                            responseMsg.addObjPart(partitionResolver.getClass().toString().substring(6));
                        }
                        if (prRgion.isFixedPartitionedRegion()) {
                            Set<FixedPartitionAttributes> fpaSet = null;
                            fpaSet = leaderRegion != null ? PartitionedRegionHelper.getAllFixedPartitionAttributes(leaderRegion) : PartitionedRegionHelper.getAllFixedPartitionAttributes(prRgion);
                            responseMsg.addObjPart(fpaSet);
                        }
                    }
                    responseMsg.send();
                    msg.flush();
                }
                catch (Exception e) {
                    GetClientPartitionAttributesCommand66.writeException(msg, e, false, servConn);
                }
                finally {
                    servConn.setAsTrue(1);
                }
            }
        }
    }
}

