/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.operations.InvalidateOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Invalidate
extends BaseCommand {
    private static final Invalidate singleton = new Invalidate();

    public static Command getCommand() {
        return singleton;
    }

    Invalidate() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadInvalidateRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        eventPart = msg.getPart(2);
        if (msg.getNumberOfParts() > 3) {
            callbackArgPart = msg.getPart(3);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Invalidate.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Invalidate.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(servConn.getName() + ": Received invalidate request (" + msg.getPayloadLength() + " bytes) from " + servConn.getSocketString() + " for region " + regionName + " key " + key2);
        }
        if (key2 == null || regionName == null) {
            if (key2 == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand__THE_INPUT_KEY_FOR_THE_0_REQUEST_IS_NULL, "invalidate"));
                errMessage.append(LocalizedStrings.BaseCommand__THE_INPUT_KEY_FOR_THE_0_REQUEST_IS_NULL.toLocalizedString("invalidate"));
            }
            if (regionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL, "invalidate"));
                errMessage.append(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL.toLocalizedString("invalidate"));
            }
            Invalidate.writeErrorResponse(msg, 10, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.BaseCommand__0_WAS_NOT_FOUND_DURING_1_REQUEST.toLocalizedString(regionName, "invalidate");
                Invalidate.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
                long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
                Breadcrumbs.setEventId(eventId);
                VersionTag tag = null;
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        InvalidateOperationContext invalidateContext = authzRequest.invalidateAuthorize(regionName, key2, callbackArg);
                        callbackArg = invalidateContext.getCallbackArg();
                    }
                    EntryEventImpl clientEvent = new EntryEventImpl(eventId);
                    if (msg.isRetry()) {
                        clientEvent.setPossibleDuplicate(true);
                        if (region.getAttributes().getConcurrencyChecksEnabled()) {
                            clientEvent.setRegion(region);
                            if (!this.recoverVersionTagForRetriedOperation(clientEvent)) {
                                clientEvent.setPossibleDuplicate(false);
                            }
                        }
                    }
                    region.basicBridgeInvalidate(key2, callbackArg, servConn.getProxyID(), true, clientEvent);
                    tag = clientEvent.getVersionTag();
                    servConn.setModificationInfo(true, regionName, key2);
                }
                catch (EntryNotFoundException e) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.BaseCommand_DURING_0_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{"invalidate", key2}));
                }
                catch (RegionDestroyedException rde) {
                    Invalidate.writeException(msg, rde, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                catch (Exception e) {
                    Invalidate.checkForInterrupt(servConn, e);
                    Invalidate.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    if (e instanceof GemFireSecurityException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Unexpected Security exception", servConn.getName(), e);
                        }
                    } else {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                    }
                    return;
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessInvalidateTime(start - oldStart2);
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr2 = (PartitionedRegion)region;
                    if (pr2.isNetworkHop() != 0) {
                        this.writeReplyWithRefreshMetadata(msg, servConn, pr2, pr2.isNetworkHop(), tag);
                        pr2.setIsNetworkHop((byte)0);
                        pr2.setMetadataVersion((byte)0);
                    } else {
                        this.writeReply(msg, servConn, tag);
                    }
                } else {
                    this.writeReply(msg, servConn, tag);
                }
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent invalidate response for region {} key {}", servConn.getName(), regionName, key2);
                }
                stats.incWriteInvalidateResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    protected void writeReply(Message origMsg, ServerConnection servConn, VersionTag tag) throws IOException {
        this.writeReply(origMsg, servConn);
    }

    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr2, byte nwHop, VersionTag tag) throws IOException {
        this.writeReplyWithRefreshMetadata(origMsg, servConn, pr2, nwHop);
    }
}

