/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;

public class MakePrimary
extends BaseCommand {
    private static final MakePrimary singleton = new MakePrimary();

    public static Command getCommand() {
        return singleton;
    }

    private MakePrimary() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        servConn.setAsTrue(2);
        Part isClientReadyPart = msg.getPart(0);
        byte[] isClientReadyPartBytes = (byte[])isClientReadyPart.getObject();
        boolean isClientReady = isClientReadyPartBytes[0] == 1;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received make primary request ({} bytes) isClientReady={}: from {}", servConn.getName(), msg.getPayloadLength(), isClientReady, servConn.getSocketString());
        }
        try {
            servConn.getAcceptor().getCacheClientNotifier().makePrimary(servConn.getProxyID(), isClientReady);
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            if (isDebugEnabled) {
                logger.debug("{}: Sent make primary response for {}", servConn.getName(), servConn.getSocketString());
            }
        }
        catch (Exception e) {
            MakePrimary.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
        }
    }
}

