/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;

public class MonitorCQ
extends BaseCommand {
    private static final MonitorCQ singleton = new MonitorCQ();

    public static Command getCommand() {
        return singleton;
    }

    private MonitorCQ() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        int op = msg.getPart(0).getInt();
        if (op < 1) {
            String err = LocalizedStrings.MonitorCQ__0_THE_MONITORCQ_OPERATION_IS_INVALID.toLocalizedString(servConn.getName());
            MonitorCQ.sendCqResponse(47, err, msg.getTransactionId(), null, servConn);
            return;
        }
        String regionName = null;
        if (msg.getNumberOfParts() == 2 && (regionName = msg.getPart(1).getString()) == null) {
            String err = LocalizedStrings.MonitorCQ__0_A_NULL_REGION_NAME_WAS_PASSED_FOR_MONITORCQ_OPERATION.toLocalizedString(servConn.getName());
            MonitorCQ.sendCqResponse(47, err, msg.getTransactionId(), null, servConn);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received MonitorCq request from {} op: {}{}", servConn.getName(), servConn.getSocketString(), op, regionName != null ? " RegionName: " + regionName : "");
        }
        try {
            CqService cqService = CqService.getCqService(crHelper.getCache());
            cqService.handleCqMonitorOp(op, regionName);
        }
        catch (CqException cqe) {
            MonitorCQ.sendCqResponse(50, "", msg.getTransactionId(), cqe, servConn);
            return;
        }
        catch (Exception e) {
            String err = LocalizedStrings.MonitorCQ_EXCEPTION_WHILE_HANDLING_THE_MONITOR_REQUEST_OP_IS_0.toLocalizedString(op);
            MonitorCQ.sendCqResponse(50, err, msg.getTransactionId(), e, servConn);
            return;
        }
        MonitorCQ.sendCqResponse(6, LocalizedStrings.MonitorCQ_MONITOR_CQ_REQUEST_COMPLETED_SUCCESSFULLY.toLocalizedString(), msg.getTransactionId(), null, servConn);
        servConn.setAsTrue(1);
    }
}

