/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientHealthMonitor;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;

public class Ping
extends BaseCommand {
    private static final Ping singleton = new Ping();

    public static Command getCommand() {
        return singleton;
    }

    private Ping() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper;
        ClientHealthMonitor chm;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: rcv tx: {} from {} rcvTime: {}", servConn.getName(), msg.getTransactionId(), servConn.getSocketString(), DistributionStats.getStatTime() - start);
        }
        if ((chm = ClientHealthMonitor.getInstance()) != null) {
            chm.receivedPing(servConn.getProxyID());
        }
        if ((crHelper = servConn.getCachedRegionHelper()).emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
        if (isDebugEnabled) {
            logger.debug("{}: Sent ping reply to {}", servConn.getName(), servConn.getSocketString());
        }
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        Message replyMsg = servConn.getReplyMessage();
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        replyMsg.setMessageType(6);
        if (Version.GFE_81.compareTo(servConn.getClientVersion()) > 0) {
            replyMsg.setNumberOfParts(1);
            replyMsg.setTransactionId(origMsg.getTransactionId());
            replyMsg.addBytesPart(OK_BYTES);
        } else {
            replyMsg.setNumberOfParts(2);
            replyMsg.setTransactionId(origMsg.getTransactionId());
            replyMsg.addBytesPart(OK_BYTES);
            long cacheTime = InternalDistributedSystem.getConnectedInstance().getDistributionManager().cacheTimeMillis();
            replyMsg.addLongPart(cacheTime);
        }
        replyMsg.send(servConn);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", servConn.getName(), origMsg.getTransactionId());
        }
    }
}

