/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.ResourceException;
import com.gemstone.gemfire.cache.operations.PutOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Put
extends BaseCommand {
    private static final Put singleton = new Put();

    public static Command getCommand() {
        return singleton;
    }

    private Put() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part valuePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        Part eventPart = null;
        String errMessage = "";
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        valuePart = msg.getPart(2);
        eventPart = msg.getPart(3);
        if (msg.getNumberOfParts() > 4) {
            callbackArgPart = msg.getPart(4);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Put.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Put.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Received put request ({} bytes) from {} for region {} key {} value {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key2, valuePart);
        }
        if (key2 == null || regionName == null) {
            if (key2 == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Put_0_THE_INPUT_KEY_FOR_THE_PUT_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.Put_THE_INPUT_KEY_FOR_THE_PUT_REQUEST_IS_NULL.toLocalizedString();
            }
            if (regionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Put_0_THE_INPUT_REGION_NAME_FOR_THE_PUT_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.Put_THE_INPUT_REGION_NAME_FOR_THE_PUT_REQUEST_IS_NULL.toLocalizedString();
            }
            Put.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Put_REGION_WAS_NOT_FOUND_DURING_PUT_REQUEST.toLocalizedString();
                Put.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else if (valuePart.isNull() && region.containsKey(key2)) {
                logger.info(LocalizedMessage.create(LocalizedStrings.Put_0_ATTEMPTED_TO_PUT_A_NULL_VALUE_FOR_EXISTING_KEY_1, new Object[]{servConn.getName(), key2}));
                errMessage = LocalizedStrings.Put_ATTEMPTED_TO_PUT_A_NULL_VALUE_FOR_EXISTING_KEY_0.toLocalizedString();
                Put.writeErrorResponse(msg, 8, errMessage, servConn);
                servConn.setAsTrue(1);
            } else {
                block40: {
                    ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
                    long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                    long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                    EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
                    try {
                        byte[] value2 = valuePart.getSerializedForm();
                        boolean isObject = valuePart.isObject();
                        AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                        if (authzRequest != null) {
                            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                                authzRequest.createRegionAuthorize((String)key2);
                            } else if (!region.isUsedForMetaRegion()) {
                                PutOperationContext putContext = authzRequest.putAuthorize(regionName, key2, value2, isObject, callbackArg);
                                value2 = putContext.getSerializedValue();
                                isObject = putContext.isObject();
                                callbackArg = putContext.getCallbackArg();
                            }
                        }
                        boolean result = false;
                        result = value2 == null ? region.basicBridgeCreate(key2, null, true, callbackArg, servConn.getProxyID(), true, new EntryEventImpl(eventId), false) : region.basicBridgePut(key2, value2, null, isObject, callbackArg, servConn.getProxyID(), true, new EntryEventImpl(eventId), servConn.isSqlFabricSystem());
                        if (result) {
                            servConn.setModificationInfo(true, regionName, key2);
                            break block40;
                        }
                        StringId message = LocalizedStrings.PUT_0_FAILED_TO_PUT_ENTRY_FOR_REGION_1_KEY_2_VALUE_3;
                        Object[] messageArgs = new Object[]{servConn.getName(), regionName, key2, valuePart};
                        String s = message.toLocalizedString(messageArgs);
                        logger.info(s);
                        throw new Exception(s);
                    }
                    catch (RegionDestroyedException rde) {
                        Put.writeException(msg, rde, false, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                    catch (ResourceException re) {
                        Put.writeException(msg, re, false, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                    catch (Exception ce) {
                        Put.checkForInterrupt(servConn, ce);
                        Put.writeException(msg, ce, false, servConn);
                        servConn.setAsTrue(1);
                        if (ce instanceof GemFireSecurityException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("{}: Unexpected Security exception", servConn.getName(), ce);
                            }
                        } else {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.PUT_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)ce);
                        }
                        return;
                    }
                    finally {
                        long oldStart2 = start;
                        start = DistributionStats.getStatTime();
                        stats.incProcessPutTime(start - oldStart2);
                    }
                }
                this.writeReply(msg, servConn);
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent put response back to {} for region {} key {} value {}", servConn.getName(), servConn.getSocketString(), regionName, key2, valuePart);
                }
                stats.incWritePutResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }
}

