/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.ResourceException;
import com.gemstone.gemfire.cache.operations.PutOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Put61
extends BaseCommand {
    private static final Put61 singleton = new Put61();

    public static Command getCommand() {
        return singleton;
    }

    private Put61() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long p_start) throws IOException, InterruptedException {
        long start = p_start;
        Part regionNamePart = null;
        Part keyPart = null;
        Part valuePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        boolean isDelta = false;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        try {
            isDelta = (Boolean)msg.getPart(2).getObject();
        }
        catch (Exception e) {
            Put61.writeException(msg, 70, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        valuePart = msg.getPart(3);
        eventPart = msg.getPart(4);
        if (msg.getNumberOfParts() > 5) {
            callbackArgPart = msg.getPart(5);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Put61.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Put61.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received 6.1{}put request ({} bytes) from {} for region {} key {}", servConn.getName(), isDelta ? " delta " : " ", msg.getPayloadLength(), servConn.getSocketString(), regionName, key2);
        }
        if (key2 == null || regionName == null) {
            String putMsg;
            if (key2 == null) {
                putMsg = " The input key for the 6.1 put request is null";
                if (isDebugEnabled) {
                    logger.debug("{}:{}", servConn.getName(), putMsg);
                }
                errMessage.append(putMsg);
            }
            if (regionName == null) {
                putMsg = " The input region name for the 6.1 put request is null";
                if (isDebugEnabled) {
                    logger.debug("{}:{}", servConn.getName(), putMsg);
                }
                errMessage.append(putMsg);
            }
            Put61.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during 6.1 put request";
                Put61.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else if (valuePart.isNull() && region.containsKey(key2)) {
                String putMsg = " Attempted to 6.1 put a null value for existing key " + key2;
                if (isDebugEnabled) {
                    logger.debug("{}:{}", servConn.getName(), putMsg);
                }
                errMessage.append(putMsg);
                Put61.writeErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
            } else {
                block57: {
                    ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
                    long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                    long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                    EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
                    try {
                        Object value2 = null;
                        if (!isDelta) {
                            value2 = valuePart.getSerializedForm();
                        }
                        boolean isObject = valuePart.isObject();
                        boolean isMetaRegion = region.isUsedForMetaRegion();
                        msg.setMetaRegion(isMetaRegion);
                        AuthorizeRequest authzRequest = null;
                        if (!isMetaRegion) {
                            authzRequest = servConn.getAuthzRequest();
                        }
                        if (authzRequest != null) {
                            if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                                authzRequest.createRegionAuthorize((String)key2);
                            } else {
                                PutOperationContext putContext = authzRequest.putAuthorize(regionName, key2, value2, isObject, callbackArg);
                                value2 = putContext.getValue();
                                isObject = putContext.isObject();
                                callbackArg = putContext.getCallbackArg();
                            }
                        }
                        boolean result = false;
                        if (value2 == null && !isDelta) {
                            result = region.basicBridgeCreate(key2, null, true, callbackArg, servConn.getProxyID(), true, new EntryEventImpl(eventId), false);
                        } else {
                            byte[] delta = null;
                            if (isDelta) {
                                delta = valuePart.getSerializedForm();
                            }
                            result = region.basicBridgePut(key2, value2, delta, isObject, callbackArg, servConn.getProxyID(), true, new EntryEventImpl(eventId), servConn.isSqlFabricSystem());
                        }
                        if (result) {
                            servConn.setModificationInfo(true, regionName, key2);
                            break block57;
                        }
                        String message = servConn.getName() + ": Failed to 6.1 put entry for region " + regionName + " key " + key2 + " value " + valuePart;
                        if (isDebugEnabled) {
                            logger.debug(message);
                        }
                        throw new Exception(message);
                    }
                    catch (RegionDestroyedException rde) {
                        Put61.writeException(msg, rde, false, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                    catch (ResourceException re) {
                        Put61.writeException(msg, re, false, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                    catch (InvalidDeltaException ide) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.UpdateOperation_ERROR_APPLYING_DELTA_FOR_KEY_0_OF_REGION_1, new Object[]{key2, regionName}));
                        Put61.writeException(msg, 70, ide, false, servConn);
                        servConn.setAsTrue(1);
                        region.getCachePerfStats().incDeltaFullValuesRequested();
                        return;
                    }
                    catch (Exception ce) {
                        Put61.checkForInterrupt(servConn, ce);
                        Put61.writeException(msg, ce, false, servConn);
                        servConn.setAsTrue(1);
                        if (ce instanceof GemFireSecurityException) {
                            if (isDebugEnabled) {
                                logger.debug("{}: Unexpected Security exception", servConn.getName(), ce);
                            }
                        } else if (isDebugEnabled) {
                            logger.debug("{}: Unexpected Exception", servConn.getName(), ce);
                        }
                        return;
                    }
                    finally {
                        long oldStart2 = start;
                        start = DistributionStats.getStatTime();
                        stats.incProcessPutTime(start - oldStart2);
                    }
                }
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr2 = (PartitionedRegion)region;
                    if (pr2.isNetworkHop() != 0) {
                        this.writeReplyWithRefreshMetadata(msg, servConn, pr2, pr2.isNetworkHop());
                        pr2.setIsNetworkHop((byte)0);
                        pr2.setMetadataVersion((byte)0);
                    } else {
                        this.writeReply(msg, servConn);
                    }
                } else {
                    this.writeReply(msg, servConn);
                }
                servConn.setAsTrue(1);
                if (isDebugEnabled) {
                    logger.debug("{}: Sent 6.1 put response back to {} for region {} key {} value {}", servConn.getName(), servConn.getSocketString(), regionName, key2, valuePart);
                }
                stats.incWritePutResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }
}

