/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.ResourceException;
import com.gemstone.gemfire.cache.operations.PutAllOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class PutAll80
extends BaseCommand {
    private static final PutAll80 singleton = new PutAll80();

    public static Command getCommand() {
        return singleton;
    }

    protected PutAll80() {
    }

    protected String putAllClassName() {
        return "putAll80";
    }

    protected Object getOptionalCallbackArg(Message msg) throws ClassNotFoundException, IOException {
        return null;
    }

    protected int getBasePartCount() {
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startp) throws IOException, InterruptedException {
        long start = startp;
        Part regionNamePart = null;
        Part numberOfKeysPart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        int numberOfKeys = 0;
        Object key2 = null;
        Part eventPart = null;
        boolean replyWithMetaData = false;
        VersionedObjectList response = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutAllRequestTime(start - oldStart);
        try {
            PartitionedRegion pr2;
            AuthorizeRequest authzRequest;
            regionNamePart = msg.getPart(0);
            regionName = regionNamePart.getString();
            if (regionName == null) {
                String putAllMsg = LocalizedStrings.PutAll_THE_INPUT_REGION_NAME_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                logger.warn("{}: {}", servConn.getName(), putAllMsg);
                errMessage.append(putAllMsg);
                PutAll80.writeChunkedErrorResponse(msg, 8, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during putAll request";
                PutAll80.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
                return;
            }
            int BASE_PART_COUNT = this.getBasePartCount();
            eventPart = msg.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
            Breadcrumbs.setEventId(eventId);
            Part callbacksPart = msg.getPart(2);
            boolean skipCallbacks = callbacksPart.getInt() == 1;
            int flags = msg.getPart(3).getInt();
            boolean clientIsEmpty = (flags & 1) != 0;
            boolean clientHasCCEnabled = (flags & 2) != 0;
            numberOfKeysPart = msg.getPart(4);
            numberOfKeys = numberOfKeysPart.getInt();
            Object callbackArg = this.getOptionalCallbackArg(msg);
            if (logger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(servConn.getName()).append(": Received ").append(this.putAllClassName()).append(" request from ").append(servConn.getSocketString()).append(" for region ").append(regionName).append(callbackArg != null ? " callbackArg " + callbackArg : "").append(" with ").append(numberOfKeys).append(" entries.");
                logger.debug(buffer.toString());
            }
            Map<Object, byte[]> map = new LinkedHashMap();
            LinkedHashMap<Object, VersionTag> retryVersions = new LinkedHashMap<Object, VersionTag>();
            for (int i = 0; i < numberOfKeys; ++i) {
                String putAllMsg;
                keyPart = msg.getPart(BASE_PART_COUNT + i * 2);
                key2 = keyPart.getStringOrObject();
                if (key2 == null) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_KEYS_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", servConn.getName(), putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll80.writeChunkedErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                valuePart = msg.getPart(BASE_PART_COUNT + i * 2 + 1);
                if (valuePart.isNull()) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_VALUES_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", servConn.getName(), putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll80.writeChunkedErrorResponse(msg, 8, errMessage.toString(), servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object value2 = valuePart.isObject() ? (skipCallbacks && Token.INVALID.isSerializedValue(valuePart.getSerializedForm()) ? (Object)Token.INVALID : (Object)CachedDeserializableFactory.create(valuePart.getSerializedForm())) : valuePart.getSerializedForm();
                if (msg.isRetry()) {
                    VersionTag tag;
                    EventID entryEventId = new EventID(eventId, i);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr3 = (PartitionedRegion)region;
                        int bucketId = pr3.getKeyInfo(key2).getBucketId();
                        long entryThreadId = ThreadIdentifier.createFakeThreadIDForBulkOp(bucketId, entryEventId.getThreadID());
                        entryEventId = new EventID(entryEventId.getMembershipID(), entryThreadId, entryEventId.getSequenceID());
                    }
                    if ((tag = this.findVersionTagsForRetriedBulkOp(region, entryEventId)) != null) {
                        retryVersions.put(key2, tag);
                    }
                }
                map.put(key2, (byte[])value2);
            }
            if (msg.getNumberOfParts() == BASE_PART_COUNT + 2 * numberOfKeys + 1) {
                int timeout = msg.getPart(BASE_PART_COUNT + 2 * numberOfKeys).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
            if ((authzRequest = servConn.getAuthzRequest()) != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    PutAllOperationContext putAllContext = authzRequest.putAllAuthorize(regionName, map, callbackArg);
                    map = putAllContext.getMap();
                    callbackArg = putAllContext.getCallbackArg();
                }
            }
            response = region.basicBridgePutAll(map, retryVersions, servConn.getProxyID(), eventId, skipCallbacks, callbackArg);
            if (!region.getConcurrencyChecksEnabled() || clientIsEmpty || !clientHasCCEnabled) {
                if (logger.isTraceEnabled()) {
                    logger.trace("setting response to null. region-cc-enabled={}; clientIsEmpty={}; client-cc-enabled={}", region.getConcurrencyChecksEnabled(), clientIsEmpty, clientHasCCEnabled);
                }
                response = null;
            }
            if (region instanceof PartitionedRegion && (pr2 = (PartitionedRegion)region).isNetworkHop() != 0) {
                this.writeReplyWithRefreshMetadata(msg, response, servConn, pr2, pr2.isNetworkHop());
                pr2.setIsNetworkHop((byte)0);
                pr2.setMetadataVersion((byte)0);
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException rde) {
            PutAll80.writeChunkedException(msg, rde, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (ResourceException re) {
            PutAll80.writeChunkedException(msg, re, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (PutAllPartialResultException pre) {
            PutAll80.writeChunkedException(msg, pre, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            PutAll80.checkForInterrupt(servConn, ce);
            PutAll80.writeChunkedException(msg, ce, false, servConn);
            servConn.setAsTrue(1);
            logger.warn(LocalizedMessage.create(LocalizedStrings.Generic_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessPutAllTime(start - oldStart2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} response back to {} for regin {} {}", servConn.getName(), this.putAllClassName(), servConn.getSocketString(), regionName, logger.isTraceEnabled() ? ": " + response : "");
        }
        if (!replyWithMetaData) {
            this.writeReply(msg, response, servConn);
        }
        servConn.setAsTrue(1);
        stats.incWritePutAllResponseTime(DistributionStats.getStatTime() - start);
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeReply(Message origMsg, VersionedObjectList response, ServerConnection servConn) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        int n = listSize = response == null ? 0 : response.size();
        if (response != null) {
            response.setKeys(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header.  version list size={}{}", listSize, logger.isTraceEnabled() ? " list=" + response : "");
        }
        replyMsg.sendHeader();
        if (listSize > 0) {
            int chunkSize = 2 * maximumChunkSize;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", i, lastChunk, replyMsg.getNumberOfParts());
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("sending only header");
            }
            replyMsg.addObjPart(null);
            replyMsg.setLastChunk(true);
            replyMsg.sendChunk(servConn);
        }
        servConn.setAsTrue(1);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl tx: {}", servConn.getName(), origMsg.getTransactionId());
        }
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr2, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeReplyWithRefreshMetadata(Message origMsg, VersionedObjectList response, ServerConnection servConn, PartitionedRegion pr2, byte nwHop) throws IOException {
        int listSize;
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        ChunkedMessage replyMsg = servConn.getChunkedResponseMessage();
        replyMsg.setMessageType(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.sendHeader();
        int n = listSize = response == null ? 0 : response.size();
        if (logger.isDebugEnabled()) {
            logger.debug("sending chunked response header with metadata refresh status. Version list size = {}{}", listSize, logger.isTraceEnabled() ? "; list=" + response : "");
        }
        if (response != null) {
            response.setKeys(null);
        }
        replyMsg.setNumberOfParts(1);
        replyMsg.setTransactionId(origMsg.getTransactionId());
        replyMsg.addBytesPart(new byte[]{pr2.getMetadataVersion(), nwHop});
        if (listSize > 0) {
            replyMsg.setLastChunk(false);
            replyMsg.sendChunk(servConn);
            int chunkSize = 2 * maximumChunkSize;
            VersionedObjectList.Chunker chunk = new VersionedObjectList.Chunker(response, chunkSize, false, false);
            for (int i = 0; i < listSize; i += chunkSize) {
                boolean lastChunk = i + chunkSize >= listSize;
                replyMsg.setNumberOfParts(1);
                replyMsg.setMessageType(1);
                replyMsg.setLastChunk(lastChunk);
                replyMsg.setTransactionId(origMsg.getTransactionId());
                replyMsg.addObjPart(chunk);
                if (logger.isDebugEnabled()) {
                    logger.debug("sending chunk at index {} last chunk={} numParts={}", i, lastChunk, replyMsg.getNumberOfParts());
                }
                replyMsg.sendChunk(servConn);
            }
        } else {
            replyMsg.setLastChunk(true);
            if (logger.isDebugEnabled()) {
                logger.debug("sending first and only part of chunked message");
            }
            replyMsg.sendChunk(servConn);
        }
        pr2.getPrStats().incPRMetaDataSentCount();
        if (logger.isTraceEnabled()) {
            logger.trace("{}: rpl with REFRESH_METADAT tx: {}", servConn.getName(), origMsg.getTransactionId());
        }
    }
}

