/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.GetOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;

public class Request
extends BaseCommand {
    private static final Request singleton = new Request();

    public static Command getCommand() {
        return singleton;
    }

    protected Request() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        Part regionNamePart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        StringId errMessage = null;
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadGetRequestTime(start - oldStart);
        int parts = msg.getNumberOfParts();
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        if (parts > 2) {
            valuePart = msg.getPart(2);
            try {
                callbackArg = valuePart.getObject();
            }
            catch (Exception e) {
                Request.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Request.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received get request ({} bytes) from {} for region {} key {} txId {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key2, msg.getTransactionId());
        }
        if (key2 == null || regionName == null) {
            if (key2 == null && regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_AND_KEY_FOR_THE_GET_REQUEST_ARE_NULL;
            } else if (key2 == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_KEY_FOR_THE_GET_REQUEST_IS_NULL;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_FOR_THE_GET_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", servConn.getName(), s);
            Request.writeErrorResponse(msg, 3, s, servConn);
            servConn.setAsTrue(1);
        } else {
            Region region = crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Request__0_WAS_NOT_FOUND_DURING_GET_REQUEST.toLocalizedString(regionName);
                Request.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                GetOperationContext getContext = null;
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        getContext = authzRequest.getAuthorize(regionName, key2, callbackArg);
                        callbackArg = getContext.getCallbackArg();
                    }
                }
                catch (NotAuthorizedException ex) {
                    Request.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object[] valueAndIsObject = new Object[3];
                try {
                    this.getValueAndIsObject(region, key2, callbackArg, servConn, valueAndIsObject);
                }
                catch (Exception e) {
                    Request.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object data = valueAndIsObject[0];
                boolean isObject = (Boolean)valueAndIsObject[1];
                try {
                    AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
                    if (postAuthzRequest != null) {
                        byte[] serializedValue = (getContext = postAuthzRequest.getAuthorize(regionName, key2, data, isObject, getContext)).getSerializedValue();
                        data = serializedValue == null ? getContext.getObject() : (Object)serializedValue;
                        isObject = getContext.isObject();
                    }
                }
                catch (NotAuthorizedException ex) {
                    Request.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessGetTime(start - oldStart2);
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr2 = (PartitionedRegion)region;
                    if (pr2.isNetworkHop() != 0) {
                        Request.writeResponseWithRefreshMetadata(data, callbackArg, msg, isObject, servConn, pr2, pr2.isNetworkHop());
                        pr2.setIsNetworkHop((byte)0);
                        pr2.setMetadataVersion((byte)0);
                    } else {
                        Request.writeResponse(data, callbackArg, msg, isObject, servConn);
                    }
                } else {
                    Request.writeResponse(data, callbackArg, msg, isObject, servConn);
                }
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Wrote get response back to {} for region {} key {} value: {}", servConn.getName(), servConn.getSocketString(), regionName, key2, data);
                }
                stats.incWriteGetResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    public void getValueAndIsObject(Region region, Object key2, Object callbackArg, ServerConnection servConn, Object[] result) {
        String regionName = region.getFullPath();
        if (servConn != null) {
            servConn.setModificationInfo(true, regionName, key2);
        }
        boolean isObject = true;
        ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
        Object data = ((LocalRegion)region).get(key2, callbackArg, true, true, true, id, null, false);
        if (data instanceof CachedDeserializable) {
            data = ((CachedDeserializable)data).getValue();
        } else if (data == Token.REMOVED_PHASE1 || data == Token.REMOVED_PHASE2 || data == Token.TOMBSTONE || data == Token.DESTROYED) {
            data = null;
        } else if (data == Token.INVALID || data == Token.LOCAL_INVALID) {
            data = null;
        } else if (data instanceof byte[]) {
            isObject = false;
        }
        result[0] = data;
        result[1] = isObject;
        result[2] = data == null;
    }
}

