/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.operations.UnregisterInterestOperationContext;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;

public class UnregisterInterest
extends BaseCommand {
    private static final UnregisterInterest singleton = new UnregisterInterest();

    public static Command getCommand() {
        return singleton;
    }

    private UnregisterInterest() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws ClassNotFoundException, IOException {
        Part regionNamePart = null;
        Part keyPart = null;
        String regionName = null;
        Object key2 = null;
        int interestType2 = 0;
        StringId errMessage = null;
        servConn.setAsTrue(2);
        regionNamePart = msg.getPart(0);
        interestType2 = msg.getPart(1).getInt();
        keyPart = msg.getPart(2);
        Part isClosingPart = msg.getPart(3);
        byte[] isClosingPartBytes = (byte[])isClosingPart.getObject();
        boolean isClosing = isClosingPartBytes[0] == 1;
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            UnregisterInterest.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean keepalive = false;
        try {
            Part keepalivePart = msg.getPart(4);
            byte[] keepaliveBytes = (byte[])keepalivePart.getObject();
            keepalive = keepaliveBytes[0] != 0;
        }
        catch (Exception e) {
            UnregisterInterest.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received unregister interest request ({} bytes) from {} for region {} key {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key2);
        }
        if (key2 == null && regionName == null) {
            errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_REGION_NAME_AND_KEY_FOR_THE_UNREGISTER_INTEREST_REQUEST_ARE_NULL;
        } else if (key2 == null) {
            errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_KEY_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_NULL;
        } else if (regionName == null) {
            errMessage = LocalizedStrings.UnRegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_UNREGISTER_INTEREST_REQUEST_IS_NULL;
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", servConn.getName(), s);
            UnregisterInterest.writeErrorResponse(msg, 23, s, servConn);
            servConn.setAsTrue(1);
        } else {
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                try {
                    UnregisterInterestOperationContext unregisterContext = authzRequest.unregisterInterestAuthorize(regionName, key2, interestType2);
                    key2 = unregisterContext.getKey();
                }
                catch (NotAuthorizedException ex) {
                    UnregisterInterest.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
            servConn.getAcceptor().getCacheClientNotifier().unregisterClientInterest(regionName, key2, interestType2, isClosing, servConn.getProxyID(), keepalive);
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent unregister interest response for region {} key {}", servConn.getName(), regionName, key2);
            }
        }
    }
}

