/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tx;

import com.gemstone.gemfire.internal.cache.tx.ClientTXStateStub;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransactionalOperation {
    private ServerRegionOperation operation;
    private String regionName;
    private Object key;
    private Object[] arguments;

    protected TransactionalOperation(ClientTXStateStub clienttx, String regionName, ServerRegionOperation op, Object key2, Object[] arguments) {
        this.regionName = regionName;
        this.operation = op;
        this.key = key2;
        this.arguments = arguments;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public ServerRegionOperation getOperation() {
        return this.operation;
    }

    public Object getKey() {
        return this.key;
    }

    public Set<Object> getKeys() {
        if (this.operation == ServerRegionOperation.PUT_ALL) {
            Map m = (Map)this.arguments[0];
            return m.keySet();
        }
        if (this.operation == ServerRegionOperation.REMOVE_ALL) {
            Collection keys = (Collection)this.arguments[0];
            return new HashSet<Object>(keys);
        }
        return null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "TransactionalOperation(region=" + this.regionName + "; op=" + (Object)((Object)this.operation) + "; key=" + this.key + ")";
    }

    public static enum ServerRegionOperation {
        CONTAINS_KEY,
        CONTAINS_VALUE,
        CONTAINS_VALUE_FOR_KEY,
        DESTROY,
        EXECUTE_FUNCTION,
        GET,
        GET_ENTRY,
        GET_ALL,
        INVALIDATE,
        KEY_SET,
        PUT,
        PUT_ALL,
        REMOVE_ALL;


        public static boolean lockKeyForTx(ServerRegionOperation op) {
            return op == PUT || op == PUT_ALL || op == REMOVE_ALL || op == DESTROY || op == INVALIDATE;
        }
    }
}

