/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.logging.log4j.Logger;

public class GatewaySenderAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    private DistributedLockService lockService;
    private volatile boolean isPrimary;
    private final Object primaryLock = new Object();
    private final String lockToken;
    private Thread lockObtainingThread;
    private final ThreadGroup threadGroup = LoggingThreadGroup.createThreadGroup("GatewaySenderAdvisor Threads");
    private AbstractGatewaySender sender;

    private GatewaySenderAdvisor(DistributionAdvisee sender) {
        super(sender);
        this.sender = (AbstractGatewaySender)sender;
        this.lockToken = this.getDLockServiceName() + "-token";
    }

    public static GatewaySenderAdvisor createGatewaySenderAdvisor(DistributionAdvisee sender) {
        GatewaySenderAdvisor advisor = new GatewaySenderAdvisor(sender);
        advisor.initialize();
        return advisor;
    }

    public String getDLockServiceName() {
        return this.getClass().getName() + "_" + this.sender.getId();
    }

    public Thread getLockObtainingThread() {
        return this.lockObtainingThread;
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new GatewaySenderProfile(memberId, version);
    }

    @Override
    public void profileCreated(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            this.checkCompatibility(sp);
        }
    }

    private void checkCompatibility(GatewaySenderProfile sp) {
        if (sp.remoteDSId != this.sender.getRemoteDSId()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_REMOTE_DS_ID_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_2_REMOTE_DS_ID.toString(sp.Id, sp.remoteDSId, this.sender.remoteDSId));
        }
        if (sp.isParallel && !this.sender.isParallel()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_AS_PARALLEL_GATEWAY_SENDER_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_AS_SERIAL_GATEWAY_SENDER.toString(sp.Id));
        }
        if (!sp.isParallel && this.sender.isParallel()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_AS_SERIAL_GATEWAY_SENDER_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_AS_PARALLEL_GATEWAY_SENDER.toString(sp.Id));
        }
        if (sp.isBatchConflationEnabled != this.sender.isBatchConflationEnabled()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_IS_BACTH_CONFLATION_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_IS_BATCH_CONFLATION_2.toString(sp.Id, sp.isBatchConflationEnabled, this.sender.isBatchConflationEnabled()));
        }
        if (sp.isPersistenceEnabled != this.sender.isPersistenceEnabled()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_IS_PERSISTENT_ENABLED_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_IS_PERSISTENT_ENABLED_2.toString(sp.Id, sp.isPersistenceEnabled, this.sender.isPersistenceEnabled()));
        }
        if (sp.alertThreshold != this.sender.getAlertThreshold()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_ALERT_THRESHOLD_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_ALERT_THRESHOLD_2.toString(sp.Id, sp.alertThreshold, this.sender.getAlertThreshold()));
        }
        if (!this.sender.isParallel() && sp.manualStart != this.sender.isManualStart()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_MANUAL_START_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_MANUAL_START_2.toString(sp.Id, sp.manualStart, this.sender.isManualStart()));
        }
        if (!sp.isParallel && sp.orderPolicy != this.sender.getOrderPolicy()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_CANNOT_CREATE_GATEWAYSENDER_0_WITH_ORDER_POLICY_1_BECAUSE_ANOTHER_CACHE_HAS_THE_SAME_SENDER_WITH_ORDER_POLICY_2.toString(new Object[]{sp.Id, sp.orderPolicy, this.sender.getOrderPolicy()}));
        }
        ArrayList<String> senderEventFilterClassNames = new ArrayList<String>();
        for (GatewayEventFilter filter : this.sender.getGatewayEventFilters()) {
            senderEventFilterClassNames.add(filter.getClass().getName());
        }
        if (sp.eventFiltersClassNames.size() != senderEventFilterClassNames.size()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_EVENT_FILTERS_MISMATCH.toString(sp.Id, sp.eventFiltersClassNames, senderEventFilterClassNames));
        }
        for (String filterName : senderEventFilterClassNames) {
            if (sp.eventFiltersClassNames.contains(filterName)) continue;
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_EVENT_FILTERS_MISMATCH.toString(sp.Id, sp.eventFiltersClassNames, senderEventFilterClassNames));
        }
        LinkedHashSet<String> senderTransportFilterClassNames = new LinkedHashSet<String>();
        for (GatewayTransportFilter filter : this.sender.getGatewayTransportFilters()) {
            senderTransportFilterClassNames.add(filter.getClass().getName());
        }
        if (sp.transFiltersClassNames.size() != senderTransportFilterClassNames.size()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_TRANSPORT_FILTERS_MISMATCH.toString(sp.Id, sp.transFiltersClassNames, senderTransportFilterClassNames));
        }
        Iterator<String> i1 = sp.transFiltersClassNames.iterator();
        Iterator i2 = senderTransportFilterClassNames.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_TRANSPORT_FILTERS_MISMATCH.toString(sp.Id, sp.transFiltersClassNames, senderTransportFilterClassNames));
        }
        ArrayList<String> senderEventListenerClassNames = new ArrayList<String>();
        for (AsyncEventListener listener : this.sender.getAsyncEventListeners()) {
            senderEventListenerClassNames.add(listener.getClass().getName());
        }
        if (sp.senderEventListenerClassNames.size() != senderEventListenerClassNames.size()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_SENDER_LISTENER_MISMATCH.toString(sp.Id, sp.senderEventListenerClassNames, senderEventListenerClassNames));
        }
        for (String listenerName : senderEventListenerClassNames) {
            if (sp.senderEventListenerClassNames.contains(listenerName)) continue;
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_SENDER_LISTENER_MISMATCH.toString(sp.Id, sp.senderEventListenerClassNames, senderEventListenerClassNames));
        }
        if (sp.isDiskSynchronous != this.sender.isDiskSynchronous()) {
            throw new IllegalStateException(LocalizedStrings.GatewaySenderAdvisor_GATEWAY_SENDER_IS_DISK_SYNCHRONOUS_MISMATCH.toString(sp.Id, sp.isDiskSynchronous, this.sender.isDiskSynchronous()));
        }
    }

    @Override
    public void profileUpdated(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (!sp.isParallel) {
                if (!sp.isRunning) {
                    if (this.advisePrimaryGatewaySender() != null) {
                        return;
                    }
                    if (!((SerialGatewaySenderImpl)this.sender).isPrimary()) {
                        if (!this.adviseEldestGatewaySender()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", this.sender);
                            }
                            return;
                        }
                        this.launchLockObtainingVolunteerThread();
                    }
                } else if (sp.serverLocation != null) {
                    this.sender.setServerLocation(sp.serverLocation);
                }
            }
        }
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (profile instanceof GatewaySenderProfile) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (!sp.isParallel) {
                if (this.advisePrimaryGatewaySender() != null) {
                    return;
                }
                if (!((SerialGatewaySenderImpl)this.sender).isPrimary()) {
                    if (!this.adviseEldestGatewaySender()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", this.sender);
                        }
                        return;
                    }
                    this.launchLockObtainingVolunteerThread();
                }
            }
        }
    }

    public boolean isPrimary() {
        return this.sender.isParallel() || this.isPrimary;
    }

    public void initDLockService() {
        InternalDistributedSystem ds = ((GemFireCacheImpl)this.sender.getCache()).getDistributedSystem();
        String dlsName = this.getDLockServiceName();
        this.lockService = DistributedLockService.getServiceNamed(dlsName);
        if (this.lockService == null) {
            this.lockService = DLockService.create(dlsName, ds, true, true, true);
        }
        Assert.assertTrue(this.lockService != null);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Obtained DistributedLockService: {}", this, this.lockService);
        }
    }

    public boolean volunteerForPrimary() {
        if (logger.isDebugEnabled()) {
            logger.debug("Sender : {} is volunteering for Primary ", this.sender.getId());
        }
        if (this.advisePrimaryGatewaySender() == null) {
            if (!this.adviseEldestGatewaySender()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sender {} is not the eldest in the system. Giving preference to eldest sender to become primary...", this.sender);
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Sender : {} no Primary available. So going to acquire distributed lock", this.sender);
            }
            this.lockService.lock(this.lockToken, 10000L, -1L);
            return this.lockService.isHeldByCurrentThread(this.lockToken);
        }
        return false;
    }

    private boolean adviseEldestGatewaySender() {
        DistributionAdvisor.Profile[] snapshot = this.profiles;
        TreeSet<Long> senderStartTimes = new TreeSet<Long>();
        for (DistributionAdvisor.Profile profile : snapshot) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isRunning) continue;
            senderStartTimes.add(sp.startTime);
        }
        return senderStartTimes.isEmpty() || this.sender.isRunning() && this.sender.startTime <= (Long)senderStartTimes.first();
    }

    private InternalDistributedMember adviseEldestGatewaySenderNode() {
        DistributionAdvisor.Profile[] snapshot = this.profiles;
        InternalDistributedMember node = null;
        DistributionAdvisor.Profile eldestProfile = null;
        for (DistributionAdvisor.Profile profile : snapshot) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isRunning) continue;
            if (eldestProfile == null) {
                eldestProfile = sp;
            }
            if (sp.startTime >= ((GatewaySenderProfile)eldestProfile).startTime) continue;
            eldestProfile = sp;
        }
        if (eldestProfile != null) {
            node = eldestProfile.getDistributedMember();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePrimary() {
        logger.info(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__STARTING_AS_PRIMARY, this.sender));
        AbstractGatewaySenderEventProcessor eventProcessor = ((SerialGatewaySenderImpl)this.sender).getEventProcessor();
        if (eventProcessor != null) {
            eventProcessor.removeCacheListener();
        }
        Object object = this.primaryLock;
        synchronized (object) {
            this.isPrimary = true;
            logger.info(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__BECOMING_PRIMARY_GATEWAYSENDER, this.sender));
            this.primaryLock.notifyAll();
        }
        new UpdateAttributesProcessor(this.sender).distribute(false);
    }

    public void makeSecondary() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Did not obtain the lock on {}. Starting as secondary gateway sender.", this.sender, this.lockToken);
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_0__STARTING_AS_SECONDARY_BECAUSE_PRIMARY_GATEWAY_SENDER_IS_AVAIALABLE_ON_MEMBER_2, new Object[]{this.sender.getId(), this.advisePrimaryGatewaySender()}));
        this.isPrimary = false;
        new UpdateAttributesProcessor(this.sender).distribute(false);
    }

    public void launchLockObtainingVolunteerThread() {
        this.lockObtainingThread = new Thread(this.threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ((SerialGatewaySenderImpl)((GatewaySenderAdvisor)GatewaySenderAdvisor.this).sender).lifeCycleLock.readLock().lock();
                try {
                    if (!((SerialGatewaySenderImpl)GatewaySenderAdvisor.this.sender).isRunning()) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Obtaining the lock on {}", this, GatewaySenderAdvisor.this.lockToken);
                    }
                    if (GatewaySenderAdvisor.this.volunteerForPrimary()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Obtained the lock on {}", this, GatewaySenderAdvisor.this.lockToken);
                        }
                        logger.info(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_0_IS_BECOMING_PRIMARY_GATEWAY_HUB, GatewaySenderAdvisor.this));
                        GatewaySenderAdvisor.this.makePrimary();
                    }
                }
                catch (CancelException e) {
                }
                catch (Exception e) {
                    if (((SerialGatewaySenderImpl)GatewaySenderAdvisor.this.sender).getStopper().cancelInProgress() == null) {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_0_THE_THREAD_TO_OBTAIN_THE_FAILOVER_LOCK_WAS_INTERRUPTED__THIS_GATEWAY_HUB_WILL_NEVER_BECOME_THE_PRIMARY, GatewaySenderAdvisor.this), (Throwable)e);
                    }
                }
                finally {
                    ((SerialGatewaySenderImpl)((GatewaySenderAdvisor)GatewaySenderAdvisor.this).sender).lifeCycleLock.readLock().unlock();
                }
            }
        }, "Gateway Sender Primary Lock Acquisition Thread Volunteer");
        this.lockObtainingThread.setDaemon(true);
        this.lockObtainingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToBecomePrimary() throws InterruptedException {
        if (this.isPrimary()) {
            return;
        }
        Object object = this.primaryLock;
        synchronized (object) {
            while (!this.isPrimary()) {
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__WAITING_TO_BECOME_PRIMARY_GATEWAY, this.sender.getId()));
                this.primaryLock.wait();
            }
        }
    }

    public InternalDistributedMember advisePrimaryGatewaySender() {
        DistributionAdvisor.Profile[] snapshot;
        for (DistributionAdvisor.Profile profile : snapshot = this.profiles) {
            GatewaySenderProfile sp = (GatewaySenderProfile)profile;
            if (sp.isParallel || !sp.isPrimary) continue;
            return sp.getDistributedMember();
        }
        return null;
    }

    public void setIsPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @Override
    public void close() {
        new UpdateAttributesProcessor(this.getAdvisee(), true).distribute(false);
        super.close();
    }

    public static final class GatewaySenderProfile
    extends DistributionAdvisor.Profile {
        public String Id;
        public long startTime;
        public int remoteDSId;
        public boolean isRunning;
        public boolean isPrimary;
        public boolean isParallel;
        public boolean isBatchConflationEnabled;
        public boolean isPersistenceEnabled;
        public int alertThreshold;
        public boolean manualStart;
        public ArrayList<String> eventFiltersClassNames = new ArrayList();
        public ArrayList<String> transFiltersClassNames = new ArrayList();
        public ArrayList<String> senderEventListenerClassNames = new ArrayList();
        public boolean isDiskSynchronous;
        public int dispatcherThreads;
        public Gateway.OrderPolicy orderPolicy;
        public ServerLocation serverLocation;
        private static final Version[] serializationVersions = new Version[]{Version.GFE_80};

        public GatewaySenderProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public GatewaySenderProfile() {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.Id = DataSerializer.readString(in);
            this.startTime = in.readLong();
            this.remoteDSId = in.readInt();
            this.isRunning = in.readBoolean();
            this.isPrimary = in.readBoolean();
            this.isParallel = in.readBoolean();
            this.isBatchConflationEnabled = in.readBoolean();
            this.isPersistenceEnabled = in.readBoolean();
            this.alertThreshold = in.readInt();
            this.manualStart = in.readBoolean();
            this.eventFiltersClassNames = DataSerializer.readArrayList(in);
            this.transFiltersClassNames = DataSerializer.readArrayList(in);
            this.senderEventListenerClassNames = DataSerializer.readArrayList(in);
            this.isDiskSynchronous = in.readBoolean();
            this.dispatcherThreads = in.readInt();
            this.orderPolicy = (Gateway.OrderPolicy)((Object)DataSerializer.readObject(in));
            boolean serverLocationFound = DataSerializer.readPrimitiveBoolean(in);
            if (serverLocationFound) {
                this.serverLocation = new ServerLocation();
                InternalDataSerializer.invokeFromData(this.serverLocation, in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.Id, out);
            out.writeLong(this.startTime);
            out.writeInt(this.remoteDSId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isPrimary);
            out.writeBoolean(this.isParallel);
            out.writeBoolean(this.isBatchConflationEnabled);
            out.writeBoolean(this.isPersistenceEnabled);
            out.writeInt(this.alertThreshold);
            out.writeBoolean(this.manualStart);
            DataSerializer.writeArrayList(this.eventFiltersClassNames, out);
            DataSerializer.writeArrayList(this.transFiltersClassNames, out);
            DataSerializer.writeArrayList(this.senderEventListenerClassNames, out);
            out.writeBoolean(this.isDiskSynchronous);
            out.writeInt(this.dispatcherThreads);
            DataSerializer.writeObject((Object)this.orderPolicy, out);
            boolean serverLocationFound = this.serverLocation != null;
            DataSerializer.writePrimitiveBoolean(serverLocationFound, out);
            if (serverLocationFound) {
                InternalDataSerializer.invokeToData(this.serverLocation, out);
            }
        }

        public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.Id = DataSerializer.readString(in);
            this.startTime = in.readLong();
            this.remoteDSId = in.readInt();
            this.isRunning = in.readBoolean();
            this.isPrimary = in.readBoolean();
            this.isParallel = in.readBoolean();
            this.isBatchConflationEnabled = in.readBoolean();
            this.isPersistenceEnabled = in.readBoolean();
            this.alertThreshold = in.readInt();
            this.manualStart = in.readBoolean();
            this.eventFiltersClassNames = DataSerializer.readArrayList(in);
            this.transFiltersClassNames = DataSerializer.readArrayList(in);
            this.senderEventListenerClassNames = DataSerializer.readArrayList(in);
            this.isDiskSynchronous = in.readBoolean();
            this.dispatcherThreads = in.readInt();
            this.orderPolicy = (Gateway.OrderPolicy)((Object)DataSerializer.readObject(in));
            boolean serverLocationFound = DataSerializer.readPrimitiveBoolean(in);
            if (serverLocationFound) {
                this.serverLocation = new ServerLocation();
                InternalDataSerializer.invokeFromData(this.serverLocation, in);
            }
        }

        public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString(this.Id, out);
            out.writeLong(this.startTime);
            out.writeInt(this.remoteDSId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isPrimary);
            out.writeBoolean(this.isParallel);
            out.writeBoolean(this.isBatchConflationEnabled);
            out.writeBoolean(this.isPersistenceEnabled);
            out.writeInt(this.alertThreshold);
            out.writeBoolean(this.manualStart);
            DataSerializer.writeArrayList(this.eventFiltersClassNames, out);
            DataSerializer.writeArrayList(this.transFiltersClassNames, out);
            DataSerializer.writeArrayList(this.senderEventListenerClassNames, out);
            out.writeBoolean(this.isDiskSynchronous);
            if (this.isParallel) {
                out.writeInt(1);
            } else if (this.orderPolicy == null) {
                out.writeInt(1);
            } else {
                out.writeInt(this.dispatcherThreads);
            }
            if (this.isParallel) {
                DataSerializer.writeObject(null, out);
            } else {
                DataSerializer.writeObject((Object)this.orderPolicy, out);
            }
            boolean serverLocationFound = this.serverLocation != null;
            DataSerializer.writePrimitiveBoolean(serverLocationFound, out);
            if (serverLocationFound) {
                InternalDataSerializer.invokeToData(this.serverLocation, out);
            }
        }

        @Override
        public Version[] getSerializationVersions() {
            return serializationVersions;
        }

        @Override
        public int getDSFID() {
            return 2144;
        }

        @Override
        public void processIncoming(DistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null) {
                AbstractGatewaySender sender = (AbstractGatewaySender)cache.getGatewaySender(adviseePath);
                this.handleDistributionAdvisee(sender, removeProfile, exchangeProfiles, replyProfiles);
            }
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; id=" + this.Id);
            sb.append("; remoteDSName=" + this.remoteDSId);
            sb.append("; isRunning=" + this.isRunning);
            sb.append("; isPrimary=" + this.isPrimary);
        }
    }
}

