/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.parallel;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventRemoteDispatcher;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.Logger;

public class ConcurrentParallelGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    private final ParallelGatewaySenderEventProcessor[] processors;
    private GemFireException ex = null;
    final int nDispatcher;

    protected ConcurrentParallelGatewaySenderEventProcessor(ParallelGatewaySenderImpl sender) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + sender.getId()), "Event Processor for GatewaySender_" + sender.getId(), sender);
        logger.info("ConcurrentParallelGatewaySenderEventProcessor: dispatcher threads {}", sender.getDispatcherThreads());
        this.processors = new ParallelGatewaySenderEventProcessor[sender.getDispatcherThreads()];
        this.nDispatcher = sender.getDispatcherThreads();
        HashSet<Region> targetRs = new HashSet<Region>();
        for (LocalRegion pr2 : ((GemFireCacheImpl)sender.getCache()).getApplicationRegions()) {
            if (!pr2.getAllGatewaySenderIds().contains(sender.getId())) continue;
            targetRs.add(pr2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The target PRs are {} Dispatchers: {}", targetRs, this.nDispatcher);
        }
        for (int i = 0; i < sender.getDispatcherThreads(); ++i) {
            this.processors[i] = new ParallelGatewaySenderEventProcessor(sender, targetRs, i, sender.getDispatcherThreads());
        }
        this.queue = new ConcurrentParallelGatewaySenderQueue(this.processors);
        this.setDaemon(true);
    }

    @Override
    protected void initializeMessageQueue(String id) {
    }

    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException, CacheException {
        Region region = event.getRegion();
        int bucketId = ((EntryEventImpl)event).getEventId().getBucketID();
        if (bucketId < 0) {
            return;
        }
        int pId = bucketId % this.nDispatcher;
        this.processors[pId].enqueueEvent(operation, event, substituteValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (int i = 0; i < this.processors.length; ++i) {
            if (isDebugEnabled) {
                logger.debug("Starting the ParallelProcessors {}", i);
            }
            this.processors[i].start();
        }
        try {
            this.waitForRunningStatus();
        }
        catch (GatewaySenderException e) {
            this.ex = e;
        }
        Object e = this.runningStateLock;
        synchronized (e) {
            if (this.ex != null) {
                this.setException(this.ex);
                this.setIsStopped(true);
            } else {
                this.setIsStopped(false);
            }
            this.runningStateLock.notifyAll();
        }
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            try {
                parallelProcessor.join();
            }
            catch (InterruptedException e2) {
                if (!isDebugEnabled) continue;
                logger.debug("Got InterruptedException while waiting for child threads to finish.");
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunningStatus() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            Object object = parallelProcessor.runningStateLock;
            synchronized (object) {
                while (parallelProcessor.getException() == null && parallelProcessor.isStopped()) {
                    try {
                        parallelProcessor.runningStateLock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                Exception ex = parallelProcessor.getException();
                if (ex != null) {
                    throw new GatewaySenderException(LocalizedStrings.Sender_COULD_NOT_START_GATEWAYSENDER_0_BECAUSE_OF_EXCEPTION_1.toLocalizedString(this.getId(), ex.getMessage()), ex.getCause());
                }
            }
        }
    }

    @Override
    public void stopProcessing() {
        if (!this.isAlive()) {
            return;
        }
        final LoggingThreadGroup loggingThreadGroup = LoggingThreadGroup.createThreadGroup("ConcurrentParallelGatewaySenderEventProcessor Logger Group", logger);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread(loggingThreadGroup, task, "ConcurrentParallelGatewaySenderEventProcessor Stopper Thread");
                thread.setDaemon(true);
                return thread;
            }
        };
        ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable> stopperCallables = new ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable>();
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            stopperCallables.add(new AbstractGatewaySenderEventProcessor.SenderStopperCallable(parallelProcessor));
        }
        ExecutorService stopperService = Executors.newFixedThreadPool(this.processors.length, threadFactory);
        try {
            List futures = stopperService.invokeAll(stopperCallables);
            for (Future f : futures) {
                try {
                    Boolean b = (Boolean)f.get();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("ConcurrentParallelGatewaySenderEventProcessor: {} stopped dispatching: {}", b != false ? "Successfully" : "Unsuccesfully", this);
                }
                catch (ExecutionException e) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.GatewaySender_0_CAUGHT_EXCEPTION_WHILE_STOPPING_1, this.sender), e.getCause());
                }
            }
        }
        catch (InterruptedException e) {
            throw new InternalGemFireException(e.getMessage());
        }
        catch (RejectedExecutionException rejectedExecutionEx) {
            throw rejectedExecutionEx;
        }
        this.setIsStopped(true);
        stopperService.shutdown();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Stopped dispatching: {}", this);
        }
    }

    @Override
    public void pauseDispatching() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.pauseDispatching();
        }
        super.pauseDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Paused dispatching: {}", this);
        }
    }

    @Override
    public void waitForDispatcherToPause() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.waitForDispatcherToPause();
        }
    }

    @Override
    public void resumeDispatching() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.resumeDispatching();
        }
        super.resumeDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Resumed dispatching: {}", this);
        }
    }

    @Override
    protected void waitForResumption() throws InterruptedException {
        super.waitForResumption();
    }

    public List<ParallelGatewaySenderEventProcessor> getProcessors() {
        LinkedList<ParallelGatewaySenderEventProcessor> l = new LinkedList<ParallelGatewaySenderEventProcessor>();
        for (int i = 0; i < this.processors.length; ++i) {
            l.add(this.processors[i]);
        }
        return l;
    }

    @Override
    public RegionQueue getQueue() {
        return this.queue;
    }

    @Override
    public GatewaySenderEventDispatcher getDispatcher() {
        return this.processors[0].getDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rebalance() {
        GatewaySenderStats statistics = this.sender.getStatistics();
        long startTime = statistics.startLoadBalance();
        try {
            for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
                GatewaySenderEventRemoteDispatcher remoteDispatcher;
                if (!(parallelProcessor.getDispatcher() instanceof GatewaySenderEventRemoteDispatcher) || !(remoteDispatcher = (GatewaySenderEventRemoteDispatcher)parallelProcessor.getDispatcher()).isConnected()) continue;
                remoteDispatcher.stopAckReaderThread();
                remoteDispatcher.destroyConnection();
            }
        }
        finally {
            statistics.endLoadBalance(startTime);
        }
    }
}

