/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.distributed.internal.ConflationKey;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class BatchDestroyOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();

    public BatchDestroyOperation(EntryEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        return new DestroyMessage(this.event);
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor processor) {
        super.initMessage(msg, processor);
        DestroyMessage m = (DestroyMessage)msg;
        EntryEventImpl event = this.getEvent();
        m.key = event.getKey();
        m.eventId = event.getEventId();
    }

    public static class DestroyMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventId = null;
        protected Object key;
        protected EntryEventImpl event = null;
        private Long tailKey = 0L;

        public DestroyMessage() {
        }

        public DestroyMessage(InternalCacheEvent event) {
            this.event = (EntryEventImpl)event;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.getRegion();
            boolean isDebugEnabled = logger.isDebugEnabled();
            try {
                if (isDebugEnabled) {
                    logger.debug("Received batch destroyed message with key {} tail key {} this size of the region is {} they keys are {}", this.key, this.tailKey, rgn.size(), rgn.keys());
                }
                for (long k = ((Long)this.key).longValue(); k <= this.tailKey; ++k) {
                    try {
                        for (GatewayEventFilter filter : rgn.getSerialGatewaySender().getGatewayEventFilters()) {
                            GatewayQueueEvent eventForFilter = (GatewayQueueEvent)rgn.get(k);
                            try {
                                if (eventForFilter == null) continue;
                                filter.afterAcknowledgement(eventForFilter);
                            }
                            catch (Exception e) {
                                logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayEventFilter_EXCEPTION_OCCURED_WHILE_HANDLING_CALL_TO_0_AFTER_ACKNOWLEDGEMENT_FOR_EVENT_1, new Object[]{filter.toString(), eventForFilter}), (Throwable)e);
                            }
                        }
                        rgn.localDestroy(k, "WAN_QUEUE_TOKEN");
                        continue;
                    }
                    catch (EntryNotFoundException e) {
                        if (!isDebugEnabled) continue;
                        logger.debug("For key {} there is no entry in the region.", k);
                    }
                }
                this.appliedOperation = true;
            }
            catch (CacheWriterException e) {
                throw new Error(LocalizedStrings.DestroyOperation_CACHEWRITER_SHOULD_NOT_BE_CALLED.toLocalizedString(), e);
            }
            catch (TimeoutException e) {
                throw new Error(LocalizedStrings.DestroyOperation_DISTRIBUTEDLOCK_SHOULD_NOT_BE_ACQUIRED.toLocalizedString(), e);
            }
            return true;
        }

        @Override
        protected final InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl ev = this.createEntryEvent(rgn);
            ev.setEventId(this.eventId);
            ev.setOldValueFromRegion();
            if (this.filterRouting != null) {
                ev.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getCache().getMyId()));
            }
            ev.setTailKey(this.tailKey);
            return ev;
        }

        EntryEventImpl createEntryEvent(DistributedRegion rgn) {
            EntryEventImpl event = new EntryEventImpl((LocalRegion)rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender());
            this.setOldValueInEvent(event);
            event.setTailKey(this.tailKey);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append(" lastDestroydKey=").append(this.key).append(" lastDispatchedKey=").append(this.tailKey).append(" id=").append(this.eventId);
        }

        @Override
        public int getDSFID() {
            return 2148;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
            Boolean hasTailKey = DataSerializer.readBoolean(in);
            if (hasTailKey.booleanValue()) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
            DataSerializer.writeBoolean(Boolean.TRUE, out);
            DataSerializer.writeLong(this.event.getTailKey(), out);
        }

        @Override
        public List getOperations() {
            return Collections.singletonList(new QueuedOperation(this.getOperation(), this.key, null, null, 0, this.callbackArg));
        }

        @Override
        public ConflationKey getConflationKey() {
            if (!this.regionAllowsConflation || this.getProcessorId() != 0) {
                return null;
            }
            return new ConflationKey(this.key, this.regionPath, false);
        }
    }
}

