/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialSecondaryGatewayListener;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class SerialGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    private final Object unprocessedEventsLock = new Object();
    protected static final int RANDOM_SLEEP_TIME = 1000;
    private Map unprocessedEvents;
    private Map unprocessedTokens;
    private ExecutorService executor;
    private Object listenerObjectLock = new Object();
    private boolean failoverCompleted = false;
    private final Object failoverCompletedLock = new Object();
    private static final int REAP_THRESHOLD = 1000;
    private int uncheckedCount = 0;

    protected SerialGatewaySenderEventProcessor(SerialGatewaySenderImpl sender, String id) {
        super(LoggingThreadGroup.createThreadGroup("Event Processor for GatewaySender_" + id, logger), "Event Processor for GatewaySender_" + id, sender);
        this.unprocessedEvents = new LinkedHashMap();
        this.unprocessedTokens = new LinkedHashMap();
        this.initializeMessageQueue(id);
        this.setDaemon(true);
    }

    @Override
    protected void initializeMessageQueue(String id) {
        StringBuffer regionNameBuffer = new StringBuffer();
        regionNameBuffer.append(id).append("_SERIAL_GATEWAY_SENDER_QUEUE");
        String regionName = regionNameBuffer.toString();
        SerialSecondaryGatewayListener listener = null;
        if (!this.sender.isPrimary()) {
            listener = new SerialSecondaryGatewayListener(this);
            this.initializeListenerExecutor();
        }
        this.queue = new SerialGatewaySenderQueue(this.sender, regionName, listener);
        if (logger.isDebugEnabled()) {
            logger.debug("Created queue: {}", this.queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForPrimary() {
        block13: {
            try {
                this.sender.getSenderAdvisor().waitToBecomePrimary();
            }
            catch (InterruptedException e) {
                if (!this.stopped()) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_AN_INTERRUPTEDEXCEPTION_OCCURRED_THE_THREAD_WILL_EXIT), (Throwable)e);
                }
                this.shutdownListenerExecutor();
                return false;
            }
            try {
                this.shutdownListenerExecutor();
                DistributedSystem.setThreadsSocketPolicy(true);
                if (!this.stopped()) {
                    this.handleFailover();
                    break block13;
                }
                boolean e = false;
                return e;
            }
            catch (RegionDestroyedException e) {
                if (!this.stopped()) {
                    logger.debug("Terminating due to {}", e.getMessage(), e);
                }
                boolean bl = false;
                return bl;
            }
            catch (CancelException e) {
                if (!this.stopped()) {
                    logger.debug("Terminating due to {}", e.getMessage(), e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.completeFailover();
            }
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.setRunningStatus();
            if (!this.sender.isPrimary()) {
                if (!this.waitForPrimary()) {
                    return;
                }
            } else {
                this.completeFailover();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Beginning to process the message queue");
            }
            if (!this.sender.isPrimary()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_ABOUT_TO_PROCESS_THE_MESSAGE_QUEUE_BUT_NOT_THE_PRIMARY));
            }
            try {
                Thread.sleep(new Random().nextInt(1000));
            }
            catch (InterruptedException e) {
                return;
            }
            this.processQueue();
        }
        catch (CancelException e) {
            if (!this.isStopped()) {
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_A_CANCELLATION_OCCURRED_STOPPING_THE_DISPATCHER));
                this.setIsStopped(true);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            logger.fatal(LocalizedMessage.create(LocalizedStrings.GatewayImpl_MESSAGE_DISPATCH_FAILED_DUE_TO_UNEXPECTED_EXCEPTION), e);
        }
    }

    @Override
    protected void rebalance() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFailover() {
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            GatewaySenderEventImpl ge;
            Object o;
            Iterator it;
            this.queue.removeCacheListener();
            this.unprocessedTokens = null;
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_GATEWAY_FAILOVER_INITIATED_PROCESSING_0_UNPROCESSED_EVENTS, this.unprocessedEvents.size()));
            GatewaySenderStats statistics = this.sender.getStatistics();
            if (!this.unprocessedEvents.isEmpty()) {
                this.reapOld(statistics, true);
                it = this.queue.getRegion().values().iterator();
                while (!(!it.hasNext() || this.stopped() || (o = it.next()) != null && o instanceof GatewaySenderEventImpl && this.unprocessedEvents.remove((ge = (GatewaySenderEventImpl)o).getEventId()) != null && this.unprocessedEvents.isEmpty())) {
                }
                it = this.unprocessedEvents.values().iterator();
                while (it.hasNext() && !this.stopped()) {
                    SerialGatewaySenderImpl.EventWrapper ew = (SerialGatewaySenderImpl.EventWrapper)it.next();
                    GatewaySenderEventImpl gatewayEvent = ew.event;
                    try {
                        gatewayEvent.initialize();
                    }
                    catch (IOException e) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_FAILED_TO_BE_INITIALIZED_0, gatewayEvent), (Throwable)e);
                    }
                    GatewaySenderEventCallbackArgument seca = gatewayEvent.getSenderCallbackArgument();
                    if (seca.getOriginatingDSId() == -1) {
                        seca.setOriginatingDSId(this.sender.getMyDSId());
                        seca.initializeReceipientDSIds(Collections.singletonList(this.sender.getRemoteDSId()));
                    }
                    try {
                        this.queuePrimaryEvent(gatewayEvent);
                    }
                    catch (IOException ex) {
                        if (this.stopped()) continue;
                        logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_DROPPED_DURING_FAILOVER_0, gatewayEvent), (Throwable)ex);
                    }
                    catch (CacheException ex) {
                        if (this.stopped()) continue;
                        logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_DROPPED_DURING_FAILOVER_0, gatewayEvent), (Throwable)ex);
                    }
                }
                statistics.clearUnprocessedMaps();
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__MARKING__1__EVENTS_AS_POSSIBLE_DUPLICATES, new Object[]{this.getSender(), this.queue.size()}));
            it = this.queue.getRegion().values().iterator();
            while (it.hasNext() && !this.stopped()) {
                o = it.next();
                if (o == null || !(o instanceof GatewaySenderEventImpl)) continue;
                ge = (GatewaySenderEventImpl)o;
                ge.setPossibleDuplicate(true);
            }
            this.unprocessedEvents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException, CacheException {
        GatewaySenderEventImpl senderEvent = null;
        boolean isPrimary = this.sender.isPrimary();
        if (!isPrimary) {
            Object object = this.unprocessedEventsLock;
            synchronized (object) {
                if (this.sender.isPrimary()) {
                    isPrimary = true;
                } else {
                    senderEvent = new GatewaySenderEventImpl(operation, event, substituteValue, false);
                    this.handleSecondaryEvent(senderEvent);
                }
            }
        }
        if (isPrimary) {
            boolean isPDXRegion;
            Region region = event.getRegion();
            boolean bl = isPDXRegion = region instanceof DistributedRegion && region.getName().equals("PdxTypes");
            if (!isPDXRegion) {
                this.waitForFailoverCompletion();
            }
            senderEvent = new GatewaySenderEventImpl(operation, event, substituteValue);
            this.queuePrimaryEvent(senderEvent);
        }
    }

    private void queuePrimaryEvent(GatewaySenderEventImpl gatewayEvent) throws IOException, CacheException {
        GatewaySenderStats statistics = this.sender.getStatistics();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Queueing event ({}): {}", this.sender.getId(), statistics.getEventsQueued() + 1, gatewayEvent);
        }
        if (!this.sender.beforeEnque(gatewayEvent)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Event {} is not added to queue.", gatewayEvent);
            }
            statistics.incEventsFiltered();
            return;
        }
        long start = statistics.startTime();
        try {
            this.queue.put(gatewayEvent);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getSender().getCancelCriterion().checkCancelInProgress(e);
        }
        statistics.endPut(start);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Queued event ({}): {}", this.sender.getId(), statistics.getEventsQueued(), gatewayEvent);
        }
        int queueSize = this.eventQueueSize();
        statistics.incQueueSize(1);
        if (!this.eventQueueSizeWarning && queueSize >= AbstractGatewaySender.QUEUE_SIZE_THRESHOLD) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_THE_EVENT_QUEUE_SIZE_HAS_REACHED_THE_THRESHOLD_1, new Object[]{this.sender.getId(), AbstractGatewaySender.QUEUE_SIZE_THRESHOLD}));
            this.eventQueueSizeWarning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForFailoverCompletion() {
        Object object = this.failoverCompletedLock;
        synchronized (object) {
            if (this.failoverCompleted) {
                return;
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0__WAITING_FOR_FAILOVER_COMPLETION, this));
            try {
                while (!this.failoverCompleted) {
                    this.failoverCompletedLock.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.sender.getCache().getCancelCriterion().checkCancelInProgress(ex);
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_DID_NOT_WAIT_FOR_FAILOVER_COMPLETION_DUE_TO_INTERRUPTION, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeFailover() {
        Object object = this.failoverCompletedLock;
        synchronized (object) {
            this.failoverCompleted = true;
            this.failoverCompletedLock.notifyAll();
        }
    }

    protected void handleSecondaryEvent(GatewaySenderEventImpl senderEvent) {
        this.basicHandleSecondaryEvent(senderEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePrimaryEvent(final GatewaySenderEventImpl gatewayEvent) {
        ExecutorService my_executor = this.executor;
        Object object = this.listenerObjectLock;
        synchronized (object) {
            if (my_executor == null) {
                return;
            }
            my_executor.execute(new Runnable(){

                @Override
                public void run() {
                    SerialGatewaySenderEventProcessor.this.basicHandlePrimaryEvent(gatewayEvent);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePrimaryDestroy(final GatewaySenderEventImpl gatewayEvent) {
        ExecutorService my_executor = this.executor;
        Object object = this.listenerObjectLock;
        synchronized (object) {
            if (my_executor == null) {
                return;
            }
            my_executor.execute(new Runnable(){

                @Override
                public void run() {
                    SerialGatewaySenderEventProcessor.this.basicHandlePrimaryDestroy(gatewayEvent);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicHandlePrimaryDestroy(GatewaySenderEventImpl gatewayEvent) {
        if (this.sender.isPrimary()) {
            return;
        }
        GatewaySenderStats statistics = this.sender.getStatistics();
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            if (this.unprocessedEvents == null) {
                return;
            }
            Object v = this.unprocessedEvents.remove(gatewayEvent.getEventId());
            if (v != null) {
                statistics.incUnprocessedEventsRemovedByPrimary();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicHandlePrimaryEvent(GatewaySenderEventImpl gatewayEvent) {
        if (this.sender.isPrimary()) {
            return;
        }
        GatewaySenderStats statistics = this.sender.getStatistics();
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            if (this.unprocessedEvents == null) {
                return;
            }
            Object v = this.unprocessedEvents.remove(gatewayEvent.getEventId());
            if (v == null) {
                if (logger.isTraceEnabled()) {
                    try {
                        gatewayEvent.initialize();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    logger.trace("{}: fromPrimary event {} : {}->{} added to unprocessed token map", this.sender.getId(), gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
                }
                Long mapValue = System.currentTimeMillis() + (long)AbstractGatewaySender.TOKEN_TIMEOUT;
                Long oldv = this.unprocessedTokens.put(gatewayEvent.getEventId(), mapValue);
                if (oldv == null) {
                    statistics.incUnprocessedTokensAddedByPrimary();
                }
            } else {
                if (logger.isTraceEnabled()) {
                    try {
                        gatewayEvent.initialize();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    logger.trace("{}: Primary create/update event {}:{}->{} remove from unprocessed events map", this.sender.getId(), gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
                }
                statistics.incUnprocessedEventsRemovedByPrimary();
            }
            this.reapOld(statistics, false);
        }
    }

    private void basicHandleSecondaryEvent(GatewaySenderEventImpl gatewayEvent) {
        GatewaySenderStats statistics = this.sender.getStatistics();
        if (!this.getSender().getGatewayEventFilters().isEmpty()) {
            try {
                gatewayEvent.initialize();
            }
            catch (Exception e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_EVENT_FAILED_TO_BE_INITIALIZED_0, gatewayEvent), (Throwable)e);
            }
            if (!this.sender.beforeEnque(gatewayEvent)) {
                statistics.incEventsFiltered();
                return;
            }
        }
        Assert.assertHoldsLock(this.unprocessedEventsLock, true);
        Assert.assertTrue(this.unprocessedEvents != null);
        Object v = this.unprocessedTokens.remove(gatewayEvent.getEventId());
        if (v == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("{}: fromSecondary event {}:{}->{} added from unprocessed events map", this.sender.getId(), gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
            }
            SerialGatewaySenderImpl.EventWrapper mapValue = new SerialGatewaySenderImpl.EventWrapper(gatewayEvent);
            SerialGatewaySenderImpl.EventWrapper oldv = this.unprocessedEvents.put(gatewayEvent.getEventId(), mapValue);
            if (oldv == null) {
                statistics.incUnprocessedEventsAddedBySecondary();
            } else {
                this.unprocessedEvents.put(gatewayEvent.getEventId(), oldv);
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewayImpl_0_THE_UNPROCESSED_EVENTS_MAP_ALREADY_CONTAINED_AN_EVENT_FROM_THE_HUB_1_SO_IGNORING_NEW_EVENT_2, new Object[]{this.sender.getId(), v, gatewayEvent}));
            }
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Secondary created event {}:{}->{} removed from unprocessed events map", this.sender.getId(), gatewayEvent.getEventId(), gatewayEvent.getKey(), this.deserialize(gatewayEvent.getValue()));
            }
            statistics.incUnprocessedTokensRemovedBySecondary();
        }
        this.reapOld(statistics, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reapOld(GatewaySenderStats statistics, boolean forceEventReap) {
        Object object = this.unprocessedEventsLock;
        synchronized (object) {
            if (this.uncheckedCount > 1000) {
                Map.Entry me;
                int count;
                Iterator it;
                this.uncheckedCount = 0;
                long now = System.currentTimeMillis();
                if (!forceEventReap && this.unprocessedTokens.size() > 1000) {
                    long meValue;
                    it = this.unprocessedTokens.entrySet().iterator();
                    count = 0;
                    while (it.hasNext() && (meValue = ((Long)(me = it.next()).getValue()).longValue()) <= now) {
                        it.remove();
                        ++count;
                    }
                    if (count > 0) {
                        // empty if block
                    }
                }
                if (!forceEventReap && this.unprocessedEvents.size() <= 1000) return;
                it = this.unprocessedEvents.entrySet().iterator();
                count = 0;
                while (it.hasNext()) {
                    me = it.next();
                    SerialGatewaySenderImpl.EventWrapper ew = (SerialGatewaySenderImpl.EventWrapper)me.getValue();
                    if (ew.timeout > now) break;
                    it.remove();
                    ++count;
                }
                if (count <= 0) return;
            } else {
                ++this.uncheckedCount;
                // empty if block
            }
            return;
        }
    }

    protected Object deserialize(byte[] serializedBytes) {
        Object deserializedObject = serializedBytes;
        try {
            deserializedObject = EntryEventImpl.deserialize(serializedBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedObject;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GatewayEventProcessor[").append("gatewaySenderId=").append(this.sender.getId()).append(";remoteDSId=").append(this.getSender().getRemoteDSId()).append(";batchSize=").append(this.getSender().getBatchSize());
        buffer.append("]");
        return buffer.toString();
    }

    private void initializeListenerExecutor() {
        final LoggingThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup("Gateway Listener Group", logger);
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable command) {
                Thread thread = new Thread(loggerGroup, command, "Queued Gateway Listener Thread");
                thread.setDaemon(true);
                return thread;
            }
        };
        LinkedBlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(1, 1, 120L, TimeUnit.SECONDS, q, tf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownListenerExecutor() {
        Object object = this.listenerObjectLock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        }
    }

    @Override
    public void removeCacheListener() {
        this.queue.removeCacheListener();
    }
}

