/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.UpdateAttributesProcessor;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAdvisor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderAttributes;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderConfigurationException;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderQueue;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;

public class SerialGatewaySenderImpl
extends AbstractGatewaySender {
    private static final Logger logger = LogService.getLogger();
    final ThreadGroup loggerGroup = LoggingThreadGroup.createThreadGroup("Remote Site Discovery Logger Group", logger);
    final Object lockForConcurrentDispatcher = new Object();

    public SerialGatewaySenderImpl(Cache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting gatewaySender : {}", this);
        }
        this.checkLicense();
        if (logger.isDebugEnabled()) {
            logger.debug("Done checking the license. Proceeding with the start... {}", this);
        }
        this.lifeCycleLock.writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GatewaySender_SENDER_0_IS_ALREADY_RUNNING, this.getId()));
                return;
            }
            if (this.remoteDSId != -1 && (locators = ((GemFireCacheImpl)this.cache).getDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new GatewaySenderConfigurationException(LocalizedStrings.AbstractGatewaySender_LOCATOR_SHOULD_BE_CONFIGURED_BEFORE_STARTING_GATEWAY_SENDER.toLocalizedString());
            }
            this.getSenderAdvisor().initDLockService();
            if (!this.isPrimary()) {
                if (this.getSenderAdvisor().volunteerForPrimary()) {
                    this.getSenderAdvisor().makePrimary();
                } else {
                    this.getSenderAdvisor().makeSecondary();
                }
            }
            this.eventProcessor = this.getDispatcherThreads() > 1 ? new ConcurrentSerialGatewaySenderEventProcessor(this) : new SerialGatewaySenderEventProcessor(this, this.getId());
            this.eventProcessor.start();
            this.waitForRunningStatus();
            this.startTime = System.currentTimeMillis();
            if (!this.isAsyncEventQueue()) {
                ((GemFireCacheImpl)this.getCache()).getPdxRegistry().gatewaySenderStarted(this);
            }
            new UpdateAttributesProcessor(this).distribute(false);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, this);
            logger.info(LocalizedMessage.create(LocalizedStrings.SerialGatewaySenderImpl_STARTED__0, this));
            this.enqueTempEvents();
        }
        finally {
            this.lifeCycleLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping Gateway Sender : {}", this);
        }
        this.lifeCycleLock.writeLock().lock();
        try {
            AbstractGatewaySenderEventProcessor ev = this.eventProcessor;
            if (ev != null && !ev.isStopped()) {
                ev.stopProcessing();
            }
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.GatewayImpl_STOPPED__0, this));
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.lifeCycleLock.writeLock().unlock();
        }
        if (this.isPrimary()) {
            try {
                DistributedLockService.destroy(this.getSenderAdvisor().getDLockServiceName());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (this.getQueues() != null && !this.getQueues().isEmpty()) {
            for (RegionQueue q : this.getQueues()) {
                ((SerialGatewaySenderQueue)q).cleanUp();
            }
        }
        this.setIsPrimary(false);
        new UpdateAttributesProcessor(this).distribute(false);
        Thread lockObtainingThread = this.getSenderAdvisor().getLockObtainingThread();
        if (lockObtainingThread != null && lockObtainingThread.isAlive()) {
            try {
                lockObtainingThread.join(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (lockObtainingThread.isAlive()) {
                logger.info(LocalizedMessage.create(LocalizedStrings.GatewayHubImpl_COULD_NOT_STOP_LOCK_OBTAINING_THREAD_DURING_GATEWAY_HUB_SHUTDOWN));
            }
        }
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SerialGatewaySender{");
        sb.append("id=" + this.getId());
        sb.append(",remoteDsId=" + this.getRemoteDSId());
        sb.append(",isRunning =" + this.isRunning());
        sb.append(",isPrimary =" + this.isPrimary());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.startTime = this.getStartTime();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = false;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        for (GatewayEventFilter gatewayEventFilter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(gatewayEventFilter.getClass().getName());
        }
        for (GatewayTransportFilter gatewayTransportFilter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(gatewayTransportFilter.getClass().getName());
        }
        for (AsyncEventListener asyncEventListener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(asyncEventListener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        pf.serverLocation = this.getServerLocation();
    }

    @Override
    protected void setModifiedEventId(EntryEventImpl clonedEvent) {
        EventID originalEventId = clonedEvent.getEventId();
        long originalThreadId = originalEventId.getThreadID();
        long newThreadId = originalThreadId;
        if (!ThreadIdentifier.isWanTypeThreadID(newThreadId)) {
            newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket(0, originalThreadId, this.getEventIdIndex());
        }
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, original event id={}, originalThreadId={}, new event id={}, newThreadId={}", this, clonedEvent.getKey(), originalEventId, originalThreadId, newEventId, newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }

    public Object getLockForConcurrentDispatcher() {
        return this.lockForConcurrentDispatcher;
    }

    public static class EventWrapper {
        private static final int EVENT_TIMEOUT = Integer.getInteger("Gateway.EVENT_TIMEOUT", 300000);
        public final long timeout;
        public final GatewaySenderEventImpl event;

        public EventWrapper(GatewaySenderEventImpl e) {
            this.event = e;
            this.timeout = System.currentTimeMillis() + (long)EVENT_TIMEOUT;
        }
    }
}

