/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.wan.serial;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class SerialSecondaryGatewayListener
extends CacheListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private final SerialGatewaySenderEventProcessor processor;
    private final AbstractGatewaySender sender;

    protected SerialSecondaryGatewayListener(SerialGatewaySenderEventProcessor eventProcessor) {
        this.processor = eventProcessor;
        this.sender = eventProcessor.getSender();
    }

    @Override
    public void afterCreate(EntryEvent event) {
        if (this.sender.isPrimary()) {
            return;
        }
        if (this.sender.getQueues() != null && !this.sender.getQueues().isEmpty()) {
            this.sender.getStatistics().incQueueSize();
        }
        GatewaySenderEventImpl senderEvent = (GatewaySenderEventImpl)event.getNewValue();
        this.processor.handlePrimaryEvent(senderEvent);
    }

    @Override
    public void afterDestroy(EntryEvent event) {
        if (this.sender.isPrimary()) {
            return;
        }
        if (this.sender.getQueues() != null && !this.sender.getQueues().isEmpty()) {
            this.sender.getStatistics().decQueueSize();
        }
        if (event.getOldValue() instanceof GatewaySenderEventImpl) {
            GatewaySenderEventImpl senderEvent = (GatewaySenderEventImpl)event.getOldValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Received after Destroy for Secondary event {} the key was {}", senderEvent, event.getKey());
            }
            this.processor.handlePrimaryDestroy(senderEvent);
        }
    }
}

