/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ClientSession;
import com.gemstone.gemfire.cache.InterestRegistrationListener;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ClientSubscriptionConfig;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractBridgeServer;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;

public class BridgeServerCreation
extends AbstractBridgeServer {
    BridgeServerCreation(Cache cache) {
        super(cache);
    }

    BridgeServerCreation(Cache cache, boolean attachListener) {
        super(cache, attachListener);
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void setNotifyBySubscription(boolean b) {
        this.notifyBySubscription = b;
    }

    @Override
    public boolean getNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public void setTcpNoDelay(boolean setting) {
        this.tcpNoDelay = setting;
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public void setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    @Override
    public int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    @Override
    public void setMaximumMessageCount(int maximumMessageCount) {
        this.maximumMessageCount = maximumMessageCount;
    }

    @Override
    public int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    @Override
    public void setMessageTimeToLive(int messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    @Override
    public boolean isRunning() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean sameAs(CacheServer other) {
        ClientSubscriptionConfig cscThis = this.getClientSubscriptionConfig();
        ClientSubscriptionConfig cscOther = other.getClientSubscriptionConfig();
        boolean result = this.getPort() == other.getPort() && this.getSocketBufferSize() == other.getSocketBufferSize() && this.getMaximumTimeBetweenPings() == other.getMaximumTimeBetweenPings() && this.getNotifyBySubscription() == other.getNotifyBySubscription() && this.getMaxConnections() == other.getMaxConnections() && this.getMaxThreads() == other.getMaxThreads() && this.getMaximumMessageCount() == other.getMaximumMessageCount() && this.getMessageTimeToLive() == other.getMessageTimeToLive() && this.getTcpNoDelay() == other.getTcpNoDelay() && cscThis.getCapacity() == cscOther.getCapacity() && cscThis.getEvictionPolicy().equals(cscOther.getEvictionPolicy());
        String diskStoreName = cscThis.getDiskStoreName();
        result = diskStoreName != null ? result && diskStoreName.equals(cscOther.getDiskStoreName()) : result && cscThis.getOverflowDirectory().equals(cscOther.getOverflowDirectory());
        return result;
    }

    public String toString() {
        return "BridgeServerCreation on port " + this.getPort() + " notify by subscription " + this.getNotifyBySubscription() + " maximum time between pings " + this.getMaximumTimeBetweenPings() + " socket buffer size " + this.getSocketBufferSize() + " maximum connections " + this.getMaxConnections() + " maximum threads " + this.getMaxThreads() + " maximum message count " + this.getMaximumMessageCount() + " message time to live " + this.getMessageTimeToLive() + " groups " + Arrays.asList(this.getGroups()) + " loadProbe " + this.loadProbe + " loadPollInterval " + this.loadPollInterval + this.getClientSubscriptionConfig().toString();
    }

    @Override
    public ClientSubscriptionConfig getClientSubscriptionConfig() {
        return this.clientSubscriptionConfig;
    }

    public Set getInterestRegistrationListeners() {
        return null;
    }

    @Override
    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
    }

    @Override
    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
    }

    @Override
    public Set getAllClientSessions() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public ClientSession getClientSession(DistributedMember member) {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public ClientSession getClientSession(String durableClientId) {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }
}

