/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.BridgePoolImpl;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.MultiIndexCreationException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.snapshot.CacheSnapshotService;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.cache.DiskStoreFactoryImpl;
import com.gemstone.gemfire.internal.cache.GatewayHubImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.cache.extension.Extensible;
import com.gemstone.gemfire.internal.cache.extension.ExtensionPoint;
import com.gemstone.gemfire.internal.cache.extension.SimpleExtensionPoint;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverFactoryImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderFactoryImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.BridgeServerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheTransactionManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.DiskStoreAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.FunctionServiceCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.GatewayHubCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.IndexCreationData;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.SerializerCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.jndi.JNDIInvoker;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LocalLogWriter;
import com.gemstone.gemfire.internal.logging.LogWriterFactory;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxInstanceFactory;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;

public class CacheCreation
implements Cache,
Extensible<Cache> {
    private int lockTimeout = GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT;
    private boolean hasLockTimeout = false;
    private int lockLease = GemFireCacheImpl.DEFAULT_LOCK_LEASE;
    private boolean hasLockLease = false;
    private int searchTimeout = GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT;
    private boolean hasSearchTimeout = false;
    private boolean hasMessageSyncInterval = false;
    protected final Map roots = new LinkedHashMap();
    private DynamicRegionFactory.Config dynamicRegionFactoryConfig = null;
    private boolean hasDynamicRegionFactory = false;
    private boolean isServer = false;
    private boolean hasServer = false;
    private final List bridgeServers = new ArrayList();
    private final Map<Declarable, Properties> declarablePropertiesMap = new HashMap<Declarable, Properties>();
    private final List gatewayHubs = new ArrayList();
    private Set<GatewaySender> gatewaySenders = new HashSet<GatewaySender>();
    private Set<GatewayReceiver> gatewayReceivers = new HashSet<GatewayReceiver>();
    private Set<AsyncEventQueue> asyncEventQueues = new HashSet<AsyncEventQueue>();
    private GatewayConflictResolver gatewayConflictResolver;
    private boolean copyOnRead = false;
    private boolean hasCopyOnRead = false;
    protected CacheTransactionManagerCreation txMgrCreation = null;
    private final Map namedRegionAttributes = new HashMap();
    protected final List regionAttributesNames = new ArrayList();
    protected final Map diskStores = new LinkedHashMap();
    private final List<File> backups = new ArrayList<File>();
    private CacheConfig cacheConfig = new CacheConfig();
    private InternalLogWriter logWriter = new LocalLogWriter(Integer.MIN_VALUE, System.out);
    private InternalLogWriter securityLogWriter = LogWriterFactory.toSecurityLogWriter(this.logWriter);
    private SimpleExtensionPoint<Cache> extensionPoint = new SimpleExtensionPoint<CacheCreation>(this, this);
    private static final RegionAttributes defaults = new AttributesFactory().create();
    private static final ThreadLocal createInProgress = new ThreadLocal();
    private final PoolManagerImpl pm = new PoolManagerImpl(false);
    private volatile FunctionServiceCreation functionServiceCreation;
    private volatile boolean hasResourceManager = false;
    private volatile ResourceManagerCreation resourceManagerCreation;
    private volatile boolean hasSerializerRegistration = false;
    private volatile SerializerCreation serializerCreation;
    private Declarable initializer = null;
    private Properties initializerProps = null;
    public QueryService queryService = new QueryService(){
        private Map<String, List> indexes = new HashMap<String, List>();

        @Override
        public Query newQuery(String queryString) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Index createHashIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createHashIndex(indexName, indexedExpression, regionPath, "");
        }

        @Override
        public Index createHashIndex(String indexName, String indexedExpression, String regionPath, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, IndexType.HASH, indexedExpression, regionPath, imports);
        }

        @Override
        public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, indexType, indexedExpression, fromClause, "");
        }

        @Override
        public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            IndexCreationData indexData = new IndexCreationData(indexName);
            indexData.setFunctionalIndexData(fromClause, indexedExpression, imports);
            indexData.setIndexType(indexType.toString());
            ArrayList<IndexCreationData> indexesForRegion = this.indexes.get(fromClause);
            if (indexesForRegion == null) {
                indexesForRegion = new ArrayList<IndexCreationData>();
                this.indexes.put(fromClause, indexesForRegion);
            }
            indexesForRegion.add(indexData);
            return indexData;
        }

        @Override
        public Index createIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, indexedExpression, regionPath, "");
        }

        @Override
        public Index createIndex(String indexName, String indexedExpression, String regionPath, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, regionPath, imports);
        }

        @Override
        public Index createKeyIndex(String indexName, String indexedExpression, String regionPath) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
            return this.createIndex(indexName, IndexType.PRIMARY_KEY, indexedExpression, regionPath, "");
        }

        @Override
        public Index getIndex(Region<?, ?> region, String indexName) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Collection<Index> getIndexes() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Collection<Index> getIndexes(Region<?, ?> region) {
            return this.indexes.get(region.getFullPath());
        }

        @Override
        public Collection<Index> getIndexes(Region<?, ?> region, IndexType indexType) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void removeIndex(Index index2) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void removeIndexes() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void removeIndexes(Region<?, ?> region) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String queryString, CqAttributes cqAttr) throws QueryInvalidException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String queryString, CqAttributes cqAttr, boolean isDurable) throws QueryInvalidException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String name, String queryString, CqAttributes cqAttr) throws QueryInvalidException, CqExistsException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery newCq(String name, String queryString, CqAttributes cqAttr, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void closeCqs() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery[] getCqs() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery[] getCqs(String regionName) throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqQuery getCq(String cqName) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void executeCqs() throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void stopCqs() throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void executeCqs(String regionName) throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void stopCqs(String regionName) throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public List<String> getAllDurableCqsFromServer() throws CqException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CqServiceStatistics getCqStatistics() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineKeyIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineHashIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineHashIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public void defineIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public List<Index> createDefinedIndexes() throws MultiIndexCreationException {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public boolean clearDefinedIndexes() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }
    };

    public CacheCreation() {
        this(false);
    }

    public CacheCreation(boolean forParsing) {
        this.initializeRegionShortcuts();
        if (!forParsing) {
            createInProgress.set(this.pm);
        }
    }

    public void startingGenerate() {
        createInProgress.set(null);
    }

    RegionAttributes getDefaultAttributes() {
        return defaults;
    }

    protected void initializeRegionShortcuts() {
        GemFireCacheImpl.initializeRegionShortcuts(this);
    }

    void addRootRegion(RegionCreation root) throws RegionExistsException {
        String name = root.getName();
        RegionCreation existing = (RegionCreation)this.roots.get(name);
        if (existing != null) {
            throw new RegionExistsException(existing);
        }
        this.roots.put(root.getName(), root);
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(int seconds) {
        this.lockTimeout = seconds;
        this.hasLockTimeout = true;
    }

    boolean hasLockTimeout() {
        return this.hasLockTimeout;
    }

    @Override
    public int getLockLease() {
        return this.lockLease;
    }

    @Override
    public void setLockLease(int seconds) {
        this.lockLease = seconds;
        this.hasLockLease = true;
    }

    boolean hasLockLease() {
        return this.hasLockLease;
    }

    @Override
    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public void setSearchTimeout(int seconds) {
        this.searchTimeout = seconds;
        this.hasSearchTimeout = true;
    }

    boolean hasSearchTimeout() {
        return this.hasSearchTimeout;
    }

    @Override
    public int getMessageSyncInterval() {
        return HARegionQueue.getMessageSyncInterval();
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException(LocalizedStrings.CacheCreation_THE_MESSAGESYNCINTERVAL_PROPERTY_FOR_CACHE_CANNOT_BE_NEGATIVE.toLocalizedString());
        }
        HARegionQueue.setMessageSyncInterval(seconds);
        this.hasMessageSyncInterval = true;
    }

    boolean hasMessageSyncInterval() {
        return this.hasMessageSyncInterval;
    }

    public Set rootRegions() {
        LinkedHashSet regions = new LinkedHashSet();
        Iterator itr = this.roots.values().iterator();
        while (itr.hasNext()) {
            regions.add(itr.next());
        }
        return Collections.unmodifiableSet(regions);
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory() {
        return new DiskStoreFactoryImpl(this);
    }

    public static final PoolManagerImpl getCurrentPoolManager() {
        return (PoolManagerImpl)createInProgress.get();
    }

    void create(GemFireCacheImpl cache) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Object factory;
        Map m;
        cache.setDeclarativeCacheConfig(this.cacheConfig);
        if (cache.isClient()) {
            throw new IllegalStateException("You must use client-cache in the cache.xml when ClientCacheFactory is used.");
        }
        if (this.hasLockLease()) {
            cache.setLockLease(this.lockLease);
        }
        if (this.hasLockTimeout()) {
            cache.setLockTimeout(this.lockTimeout);
        }
        if (this.hasSearchTimeout()) {
            cache.setSearchTimeout(this.searchTimeout);
        }
        if (this.hasMessageSyncInterval()) {
            cache.setMessageSyncInterval(this.getMessageSyncInterval());
        }
        if (this.gatewayConflictResolver != null) {
            cache.setGatewayConflictResolver(this.gatewayConflictResolver);
        }
        if (!(m = this.getPools()).isEmpty()) {
            for (Pool cp : m.values()) {
                PoolFactoryImpl f = (PoolFactoryImpl)PoolManager.createFactory();
                f.init(cp);
                PoolImpl p = (PoolImpl)f.create(cp.getName());
            }
        }
        if (this.hasResourceManager()) {
            this.getResourceManager().configure(cache.getResourceManager());
        }
        DiskStoreAttributesCreation pdxRegDSC = this.initializePdxDiskStore(cache);
        cache.initializePdxRegistry();
        for (DiskStoreAttributesCreation creation : this.diskStores.values()) {
            if (creation == pdxRegDSC) continue;
            this.createDiskStore(creation, cache);
        }
        if (this.hasDynamicRegionFactory()) {
            DynamicRegionFactory.get().open(this.getDynamicRegionFactoryConfig());
        }
        if (this.hasServer()) {
            cache.setIsServer(this.isServer);
        }
        if (this.hasCopyOnRead()) {
            cache.setCopyOnRead(this.copyOnRead);
        }
        if (this.txMgrCreation != null && this.txMgrCreation.getListeners().length > 0 && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().initListeners(this.txMgrCreation.getListeners());
        }
        if (this.txMgrCreation != null && cache.getCacheTransactionManager() != null) {
            cache.getCacheTransactionManager().setWriter(this.txMgrCreation.getWriter());
        }
        for (GatewaySender senderCreation : this.getGatewaySenders()) {
            factory = (GatewaySenderFactoryImpl)cache.createGatewaySenderFactory();
            ((GatewaySenderFactoryImpl)factory).configureGatewaySender(senderCreation);
            GatewaySender gatewaySender = ((GatewaySenderFactoryImpl)factory).create(senderCreation.getId(), senderCreation.getRemoteDSId());
            if (!gatewaySender.isManualStart()) continue;
            cache.getLoggerI18n().info(LocalizedStrings.CacheCreation_0_IS_NOT_BEING_STARTED_SINCE_IT_IS_CONFIGURED_FOR_MANUAL_START, gatewaySender);
        }
        for (AsyncEventQueue asyncEventQueueCreation : this.getAsyncEventQueues()) {
            AsyncEventQueueFactoryImpl asyncQueueFactory = (AsyncEventQueueFactoryImpl)cache.createAsyncEventQueueFactory();
            asyncQueueFactory.configureAsyncEventQueue(asyncEventQueueCreation);
            AsyncEventQueue asyncEventQueue = cache.getAsyncEventQueue(asyncEventQueueCreation.getId());
            if (asyncEventQueue != null) continue;
            asyncQueueFactory.create(asyncEventQueueCreation.getId(), asyncEventQueueCreation.getAsyncEventListener());
        }
        for (GatewayReceiver receiverCreation : this.getGatewayReceivers()) {
            factory = cache.createGatewayReceiverFactory();
            factory.setBindAddress(receiverCreation.getBindAddress());
            factory.setMaximumTimeBetweenPings(receiverCreation.getMaximumTimeBetweenPings());
            factory.setStartPort(receiverCreation.getStartPort());
            factory.setEndPort(receiverCreation.getEndPort());
            factory.setSocketBufferSize(receiverCreation.getSocketBufferSize());
            factory.setManualStart(receiverCreation.isManualStart());
            for (GatewayTransportFilter filter : receiverCreation.getGatewayTransportFilters()) {
                factory.addGatewayTransportFilter(filter);
            }
            factory.setHostnameForSenders(receiverCreation.getHost());
            GatewayReceiver receiver = factory.create();
            if (!receiver.isManualStart()) continue;
            cache.getLoggerI18n().info(LocalizedStrings.CacheCreation_0_IS_NOT_BEING_STARTED_SINCE_IT_IS_CONFIGURED_FOR_MANUAL_START, receiver);
        }
        cache.initializePdxRegistry();
        for (String id : this.regionAttributesNames) {
            RegionAttributesCreation creation = (RegionAttributesCreation)this.getRegionAttributes(id);
            creation.inheritAttributes(cache, false);
            AttributesFactory factory2 = new AttributesFactory(creation);
            RegionAttributes attrs = factory2.create();
            cache.setRegionAttributes(id, attrs);
        }
        for (RegionCreation r : this.roots.values()) {
            r.createRoot(cache);
        }
        cache.readyDynamicRegionFactory();
        for (GatewayHubCreation hubCreation : this.getGatewayHubs()) {
            GatewayHubImpl hubImpl = (GatewayHubImpl)cache.addGatewayHub(hubCreation.getId(), hubCreation.getPort());
            hubImpl.configureFrom(hubCreation);
            try {
                if (hubImpl.getManualStart()) {
                    cache.getLoggerI18n().info(LocalizedStrings.CacheCreation_0_IS_NOT_BEING_STARTED_SINCE_IT_IS_CONFIGURED_FOR_MANUAL_START, hubImpl);
                    continue;
                }
                hubImpl.start();
            }
            catch (IOException ex) {
                throw new GemFireIOException(LocalizedStrings.CacheCreation_WHILE_STARTING_GATEWAY_HUB_0.toLocalizedString(hubImpl), ex);
            }
        }
        Integer serverPort = CacheServerLauncher.getServerPort();
        String serverBindAdd = CacheServerLauncher.getServerBindAddress();
        Boolean disableDefaultServer = CacheServerLauncher.disableDefaultServer.get();
        if (this.getCacheServers().size() > 1 && (serverPort != null || serverBindAdd != null)) {
            throw new RuntimeException(LocalizedStrings.CacheServerLauncher_SERVER_PORT_MORE_THAN_ONE_CACHE_SERVER.toLocalizedString());
        }
        if (!(!this.getCacheServers().isEmpty() || serverPort == null && serverBindAdd == null || disableDefaultServer != null && disableDefaultServer.booleanValue())) {
            boolean existingCacheServer = false;
            List cacheServers = cache.getCacheServers();
            if (cacheServers != null) {
                for (CacheServer cacheServer : cacheServers) {
                    if (serverPort.intValue() != cacheServer.getPort() || !cacheServer.getBindAddress().equals(serverBindAdd)) continue;
                    existingCacheServer = true;
                }
            }
            if (!existingCacheServer) {
                this.getCacheServers().add(new BridgeServerCreation(cache, false));
            }
        }
        for (BridgeServerCreation bridge : this.getCacheServers()) {
            BridgeServerImpl impl = (BridgeServerImpl)cache.addCacheServer();
            impl.configureFrom(bridge);
            if (serverPort != null && serverPort != 40404) {
                impl.setPort(serverPort);
            }
            if (serverBindAdd != null) {
                impl.setBindAddress(serverBindAdd.trim());
            }
            try {
                if (impl.isRunning()) continue;
                impl.start();
            }
            catch (IOException ex) {
                throw new GemFireIOException(LocalizedStrings.CacheCreation_WHILE_STARTING_BRIDGE_SERVER_0.toLocalizedString(impl), ex);
            }
        }
        cache.setBackupFiles(this.backups);
        cache.addDeclarableProperties(this.declarablePropertiesMap);
        this.runInitializer();
        cache.setInitializer(this.getInitializer(), this.getInitializerProps());
        this.extensionPoint.fireCreate(cache);
    }

    protected DiskStoreAttributesCreation initializePdxDiskStore(GemFireCacheImpl cache) {
        DiskStoreAttributesCreation pdxRegDSC = null;
        if (TypeRegistry.mayNeedDiskStore(cache)) {
            String pdxRegDsName = cache.getPdxDiskStore();
            if (pdxRegDsName == null) {
                pdxRegDsName = "DEFAULT";
            }
            if ((pdxRegDSC = (DiskStoreAttributesCreation)this.diskStores.get(pdxRegDsName)) == null) {
                if (pdxRegDsName.equals("DEFAULT")) {
                    cache.getOrCreateDefaultDiskStore();
                }
            } else {
                this.createDiskStore(pdxRegDSC, cache);
            }
        }
        return pdxRegDSC;
    }

    protected void createDiskStore(DiskStoreAttributesCreation creation, GemFireCacheImpl cache) {
        DiskStoreFactory factory = cache.createDiskStoreFactory(creation);
        factory.create(creation.getName());
    }

    public boolean sameAs(Cache other) {
        Pool p;
        boolean sameConfig;
        boolean bl = sameConfig = other.getLockLease() == this.getLockLease() && other.getLockTimeout() == this.getLockTimeout() && other.getSearchTimeout() == this.getSearchTimeout() && other.getMessageSyncInterval() == this.getMessageSyncInterval() && other.getCopyOnRead() == this.getCopyOnRead() && other.isServer() == this.isServer();
        if (!sameConfig) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_SAMECONFIG.toLocalizedString());
        }
        DynamicRegionFactory.Config drc1 = this.getDynamicRegionFactoryConfig();
        if (drc1 != null) {
            DynamicRegionFactory.Config drc2 = null;
            drc2 = other instanceof CacheCreation ? ((CacheCreation)other).getDynamicRegionFactoryConfig() : DynamicRegionFactory.get().getConfig();
            if (drc2 == null) {
                return false;
            }
            if (!RegionAttributesCreation.equal(drc1.getDiskDir(), drc2.getDiskDir())) {
                return false;
            }
            if (!RegionAttributesCreation.equal(drc1.getBridgeWriter(), drc2.getBridgeWriter())) {
                return false;
            }
        } else if (other instanceof CacheCreation ? ((CacheCreation)other).getDynamicRegionFactoryConfig() != null : DynamicRegionFactory.get().isOpen()) {
            return false;
        }
        List myBridges = this.getCacheServers();
        List<CacheServer> otherBridges = other.getCacheServers();
        if (myBridges.size() != otherBridges.size()) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_BRIDGESERVERS_SIZE.toLocalizedString());
        }
        for (BridgeServerCreation myBridge : myBridges) {
            boolean found = false;
            for (CacheServer otherBridge : otherBridges) {
                if (!myBridge.sameAs(otherBridge)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException(LocalizedStrings.CacheCreation_BRIDGE_0_NOT_FOUND.toLocalizedString(myBridge));
        }
        Map m1 = this.getPools();
        Map m2 = other instanceof CacheCreation ? ((CacheCreation)other).getPools() : PoolManager.getAll();
        int m1Size = m1.size();
        for (Pool cp : m1.values()) {
            if (!(cp instanceof BridgePoolImpl) && !((PoolImpl)cp).isUsedByGateway()) continue;
            --m1Size;
        }
        int m2Size = m2.size();
        for (Pool cp : m2.values()) {
            if (!(cp instanceof BridgePoolImpl) && !((PoolImpl)cp).isUsedByGateway()) continue;
            --m2Size;
        }
        if (m2Size == 1 && (p = (Pool)m2.values().iterator().next()).getName().equals("DEFAULT")) {
            m2Size = 0;
        }
        if (m1Size != m2Size) {
            throw new RuntimeException("pool sizes differ m1Size=" + m1Size + " m2Size=" + m2Size + " m1=" + m1.values() + " m2=" + m2.values());
        }
        if (m1Size > 0) {
            for (Pool cp : m1.values()) {
                if (cp instanceof BridgePoolImpl || ((PoolImpl)cp).isUsedByGateway()) continue;
                ((PoolImpl)cp).sameAs(m2.get(((PoolImpl)cp).getName()));
            }
        }
        for (DiskStoreAttributesCreation dsac : this.diskStores.values()) {
            String name = dsac.getName();
            DiskStore ds = other.findDiskStore(name);
            if (ds == null) {
                this.getLogger().fine("Disk store " + name + " not found.");
                throw new RuntimeException(LocalizedStrings.CacheCreation_DISKSTORE_NOTFOUND_0.toLocalizedString(name));
            }
            if (dsac.sameAs(ds)) continue;
            this.getLogger().fine("Attributes for disk store " + name + " do not match");
            throw new RuntimeException(LocalizedStrings.CacheCreation_ATTRIBUTES_FOR_DISKSTORE_0_DO_NOT_MATCH.toLocalizedString(name));
        }
        Map myNamedAttributes = this.listRegionAttributes();
        Map otherNamedAttributes = other.listRegionAttributes();
        if (myNamedAttributes.size() != otherNamedAttributes.size()) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_NAMEDATTRIBUTES_SIZE.toLocalizedString());
        }
        for (Map.Entry myEntry : myNamedAttributes.entrySet()) {
            String myId = (String)myEntry.getKey();
            Assert.assertTrue(myEntry.getValue() instanceof RegionAttributesCreation, "Entry value is a " + myEntry.getValue().getClass().getName());
            RegionAttributesCreation myAttrs = (RegionAttributesCreation)myEntry.getValue();
            RegionAttributes otherAttrs = other.getRegionAttributes(myId);
            if (otherAttrs == null) {
                this.getLogger().fine("No attributes for " + myId);
                throw new RuntimeException(LocalizedStrings.CacheCreation_NO_ATTRIBUTES_FOR_0.toLocalizedString(myId));
            }
            if (myAttrs.sameAs(otherAttrs)) continue;
            this.getLogger().fine("Attributes for " + myId + " do not match");
            throw new RuntimeException(LocalizedStrings.CacheCreation_ATTRIBUTES_FOR_0_DO_NOT_MATCH.toLocalizedString(myId));
        }
        Collection myRoots = this.roots.values();
        Set<Region<?, ?>> otherRoots = other.rootRegions();
        if (myRoots.size() != otherRoots.size()) {
            throw new RuntimeException(LocalizedStrings.CacheCreation_ROOTS_SIZE.toLocalizedString());
        }
        for (RegionCreation r : myRoots) {
            Region r2 = other.getRegion(r.getName());
            if (r2 == null) {
                throw new RuntimeException(LocalizedStrings.CacheCreation_NO_ROOT_0.toLocalizedString(r.getName()));
            }
            if (r.sameAs(r2)) continue;
            throw new RuntimeException(LocalizedStrings.CacheCreation_REGIONS_DIFFER.toLocalizedString());
        }
        if (this.getCacheTransactionManager() != null) {
            List<TransactionListener> otherTxListeners = Arrays.asList(other.getCacheTransactionManager().getListeners());
            List<TransactionListener> thisTxListeners = Arrays.asList(this.getCacheTransactionManager().getListeners());
            if (!thisTxListeners.equals(otherTxListeners)) {
                throw new RuntimeException(LocalizedStrings.CacheCreation_TXLISTENER.toLocalizedString());
            }
        }
        if (this.hasResourceManager()) {
            this.getResourceManager().sameAs(other.getResourceManager());
        }
        return true;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void close(boolean keepalive) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isReconnecting() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopReconnecting() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cache getReconnectedCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LogWriter getLogger() {
        return this.logWriter;
    }

    @Override
    public LogWriter getSecurityLogger() {
        return this.securityLogWriter;
    }

    @Override
    public LogWriterI18n getLoggerI18n() {
        return this.logWriter.convertToLogWriterI18n();
    }

    @Override
    public LogWriterI18n getSecurityLoggerI18n() {
        return this.securityLogWriter.convertToLogWriterI18n();
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public QueryService getQueryService() {
        return this.queryService;
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut atts) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(String regionAttributesId) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionAttributes<K, V> regionAttributes) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Region createVMRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        return this.createRegion(name, attrs);
    }

    public Region createRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        if (attrs instanceof RegionAttributesCreation) {
            ((RegionAttributesCreation)attrs).inheritAttributes(this);
            ((RegionAttributesCreation)attrs).prepareForValidation();
        }
        AttributesFactory.validateAttributes(attrs);
        RegionCreation region = new RegionCreation(this, name, null);
        region.setAttributes(attrs);
        this.addRootRegion(region);
        return region;
    }

    public Region createRegion(String name, String refid) throws RegionExistsException, TimeoutException {
        RegionCreation region = new RegionCreation(this, name, refid);
        this.addRootRegion(region);
        return region;
    }

    public Region getRegion(String path) {
        if (path.indexOf(47) != -1) {
            throw new UnsupportedOperationException();
        }
        return (Region)this.roots.get(path);
    }

    @Override
    public BridgeServer addBridgeServer() {
        return (BridgeServer)((Object)this.addCacheServer());
    }

    @Override
    public CacheServer addCacheServer() {
        return this.addCacheServer(false);
    }

    public CacheServer addCacheServer(boolean isGatewayReceiver) {
        BridgeServerCreation bridge = new BridgeServerCreation(this, false);
        this.bridgeServers.add(bridge);
        return bridge;
    }

    public void addDeclarableProperties(Declarable declarable, Properties properties) {
        this.declarablePropertiesMap.put(declarable, properties);
    }

    public List getBridgeServers() {
        return this.getCacheServers();
    }

    public List getCacheServers() {
        return this.bridgeServers;
    }

    @Override
    public GatewayHub setGatewayHub(String id, int port) {
        return this.addGatewayHub(id, port);
    }

    @Override
    public GatewayHub addGatewayHub(String id, int port) {
        if (this.alreadyDefinesGatewayHubId(id)) {
            throw new GatewayException(LocalizedStrings.CacheCreation_A_GATEWAYHUB_WITH_ID_0_IS_ALREADY_DEFINED_IN_THIS_CACHE.toLocalizedString(id));
        }
        if (this.alreadyDefinesGatewayHubPort(port)) {
            throw new GatewayException(LocalizedStrings.CacheCreation_A_GATEWAYHUB_WITH_PORT_0_IS_ALREADY_DEFINED_IN_THIS_CACHE.toLocalizedString(port));
        }
        GatewayHubCreation hub = new GatewayHubCreation(this, id, port);
        this.gatewayHubs.add(hub);
        return hub;
    }

    public GatewaySender addGatewaySender(GatewaySender sender) {
        this.gatewaySenders.add(sender);
        return sender;
    }

    public GatewayReceiver addGatewayReceiver(GatewayReceiver receiver) {
        this.gatewayReceivers.add(receiver);
        return receiver;
    }

    public AsyncEventQueue addAsyncEventQueue(AsyncEventQueue asyncEventQueue) {
        this.asyncEventQueues.add(asyncEventQueue);
        return asyncEventQueue;
    }

    @Override
    public Set<GatewaySender> getGatewaySenders() {
        HashSet<GatewaySender> tempSet = new HashSet<GatewaySender>();
        for (GatewaySender sender : this.gatewaySenders) {
            if (((AbstractGatewaySender)sender).isForInternalUse()) continue;
            tempSet.add(sender);
        }
        return tempSet;
    }

    @Override
    public GatewaySender getGatewaySender(String Id) {
        for (GatewaySender sender : this.gatewaySenders) {
            if (!sender.getId().equals(Id)) continue;
            return sender;
        }
        return null;
    }

    @Override
    public Set<GatewayReceiver> getGatewayReceivers() {
        return this.gatewayReceivers;
    }

    @Override
    public Set<AsyncEventQueue> getAsyncEventQueues() {
        return this.asyncEventQueues;
    }

    @Override
    public AsyncEventQueue getAsyncEventQueue(String id) {
        for (AsyncEventQueue asyncEventQueue : this.asyncEventQueues) {
            if (!asyncEventQueue.getId().equals(id)) continue;
            return asyncEventQueue;
        }
        return null;
    }

    @Override
    public GatewayHub getGatewayHub() {
        List hubs = this.getGatewayHubs();
        return hubs.isEmpty() ? null : (GatewayHub)hubs.get(0);
    }

    public List getGatewayHubs() {
        return this.gatewayHubs;
    }

    @Override
    public GatewayHub getGatewayHub(String id) {
        GatewayHub result = null;
        for (GatewayHub hub : this.getGatewayHubs()) {
            if (!hub.getId().equals(id)) continue;
            result = hub;
            break;
        }
        return result;
    }

    protected boolean alreadyDefinesGatewayHubId(String id) {
        boolean alreadyDefined = false;
        for (GatewayHub hub : this.getGatewayHubs()) {
            if (!hub.getId().equals(id)) continue;
            alreadyDefined = true;
            break;
        }
        return alreadyDefined;
    }

    protected boolean alreadyDefinesGatewayHubPort(int port) {
        boolean alreadyDefined = false;
        if (port != -1) {
            for (GatewayHub hub : this.getGatewayHubs()) {
                if (hub.getPort() != port) continue;
                alreadyDefined = true;
                break;
            }
        }
        return alreadyDefined;
    }

    @Override
    public void setIsServer(boolean isServer) {
        this.isServer = isServer;
        this.hasServer = true;
    }

    @Override
    public boolean isServer() {
        if (!this.isServer) {
            return this.bridgeServers.size() > 0;
        }
        return true;
    }

    boolean hasServer() {
        return this.hasServer;
    }

    public void setDynamicRegionFactoryConfig(DynamicRegionFactory.Config v) {
        this.dynamicRegionFactoryConfig = v;
        this.hasDynamicRegionFactory = true;
    }

    boolean hasDynamicRegionFactory() {
        return this.hasDynamicRegionFactory;
    }

    public DynamicRegionFactory.Config getDynamicRegionFactoryConfig() {
        return this.dynamicRegionFactoryConfig;
    }

    @Override
    public CacheTransactionManager getCacheTransactionManager() {
        return this.txMgrCreation;
    }

    @Override
    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
        this.hasCopyOnRead = true;
    }

    @Override
    public boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    boolean hasCopyOnRead() {
        return this.hasCopyOnRead;
    }

    public void addCacheTransactionManagerCreation(CacheTransactionManagerCreation txm) {
        this.txMgrCreation = txm;
    }

    @Override
    public Context getJNDIContext() {
        return JNDIInvoker.getJNDIContext();
    }

    @Override
    public DiskStore findDiskStore(String storeName) {
        String s = storeName;
        if (s == null) {
            s = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        return (DiskStore)this.diskStores.get(s);
    }

    public void addDiskStore(DiskStore ds) {
        this.diskStores.put(ds.getName(), ds);
    }

    public Collection<DiskStore> listDiskStores() {
        return this.diskStores.values();
    }

    public void setDiskStore(String name, DiskStoreAttributesCreation dsac) {
        this.diskStores.put(name, dsac);
    }

    public RegionAttributes getRegionAttributes(String id) {
        return (RegionAttributes)this.namedRegionAttributes.get(id);
    }

    public void setRegionAttributes(String id, RegionAttributes attrs) {
        RegionAttributes a = attrs;
        if (!(a instanceof RegionAttributesCreation)) {
            a = new RegionAttributesCreation(this, a, false);
        }
        this.namedRegionAttributes.put(id, a);
        this.regionAttributesNames.add(id);
    }

    public Map listRegionAttributes() {
        return Collections.unmodifiableMap(this.namedRegionAttributes);
    }

    @Override
    public void loadCacheXml(InputStream is) throws TimeoutException, CacheWriterException, RegionExistsException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void readyForEvents() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Map getPools() {
        return this.pm.getMap();
    }

    public PoolFactory createPoolFactory() {
        return new PoolFactoryImpl(this.pm).setStartDisabled(true);
    }

    public Pool findPool(String name) {
        return this.pm.find(name);
    }

    public void setFunctionServiceCreation(FunctionServiceCreation f) {
        this.functionServiceCreation = f;
    }

    public FunctionServiceCreation getFunctionServiceCreation() {
        return this.functionServiceCreation;
    }

    public void setResourceManagerCreation(ResourceManagerCreation rmc) {
        this.hasResourceManager = true;
        this.resourceManagerCreation = rmc;
    }

    @Override
    public ResourceManagerCreation getResourceManager() {
        return this.resourceManagerCreation;
    }

    public boolean hasResourceManager() {
        return this.hasResourceManager;
    }

    public void setSerializerCreation(SerializerCreation sc) {
        this.hasSerializerRegistration = true;
        this.serializerCreation = sc;
    }

    public SerializerCreation getSerializerCreation() {
        return this.serializerCreation;
    }

    public boolean hasSerializerCreation() {
        return this.hasSerializerRegistration;
    }

    public FunctionService getFunctionService() {
        throw new UnsupportedOperationException();
    }

    public void addBackup(File backup) {
        this.backups.add(backup);
    }

    public List<File> getBackupFiles() {
        return Collections.unmodifiableList(this.backups);
    }

    @Override
    public GatewaySenderFactory createGatewaySenderFactory() {
        return new GatewaySenderFactoryImpl(this);
    }

    @Override
    public GatewayReceiverFactory createGatewayReceiverFactory() {
        return new GatewayReceiverFactoryImpl(this);
    }

    @Override
    public AsyncEventQueueFactory createAsyncEventQueueFactory() {
        return new AsyncEventQueueFactoryImpl(this);
    }

    public void setPdxReadSerialized(boolean readSerialized) {
        this.cacheConfig.setPdxReadSerialized(readSerialized);
    }

    public void setPdxIgnoreUnreadFields(boolean ignore) {
        this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
    }

    public void setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
    }

    public void setPdxDiskStore(String diskStore) {
        this.cacheConfig.setPdxDiskStore(diskStore);
    }

    public void setPdxPersistent(boolean persistent) {
        this.cacheConfig.setPdxPersistent(persistent);
    }

    @Override
    public boolean getPdxReadSerialized() {
        return this.cacheConfig.isPdxReadSerialized();
    }

    @Override
    public PdxSerializer getPdxSerializer() {
        return this.cacheConfig.getPdxSerializer();
    }

    @Override
    public String getPdxDiskStore() {
        return this.cacheConfig.getPdxDiskStore();
    }

    @Override
    public boolean getPdxPersistent() {
        return this.cacheConfig.isPdxPersistent();
    }

    @Override
    public boolean getPdxIgnoreUnreadFields() {
        return this.cacheConfig.getPdxIgnoreUnreadFields();
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<DistributedMember> getAdminMembers() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<DistributedMember> getMembers(Region r) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Declarable getInitializer() {
        return this.initializer;
    }

    @Override
    public Properties getInitializerProps() {
        return this.initializerProps;
    }

    public void setInitializer(Declarable d, Properties props) {
        this.initializer = d;
        this.initializerProps = props;
    }

    protected void runInitializer() {
        if (this.getInitializer() != null) {
            this.getInitializer().init(this.getInitializerProps());
        }
    }

    @Override
    public void setGatewayConflictResolver(GatewayConflictResolver g) {
        this.gatewayConflictResolver = g;
    }

    @Override
    public GatewayConflictResolver getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        throw new UnsupportedOperationException();
    }

    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheSnapshotService getSnapshotService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExtensionPoint<Cache> getExtensionPoint() {
        return this.extensionPoint;
    }
}

