/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.cache.GatewayException;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

class GatewayCreation
implements Gateway {
    private GatewayHub _hub;
    private String _id;
    private List _endpoints;
    private List _listeners;
    private GatewayQueueAttributes _queueAttributes;
    private boolean _earlyAck;
    private int _socketBufferSize;
    private int _socketReadTimeout;
    private int _concurrencyLevel;
    private Gateway.OrderPolicy _orderPolicy;

    GatewayCreation(GatewayHub hub, String id, int concurrencyLevel) {
        this._hub = hub;
        this._id = id;
        this._endpoints = new ArrayList();
        this._listeners = new ArrayList();
        this._queueAttributes = new GatewayQueueAttributes();
        this._socketBufferSize = 32768;
        this._socketReadTimeout = 0;
        this._concurrencyLevel = concurrencyLevel;
    }

    @Override
    public String getGatewayHubId() {
        return this._hub.getId();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void addEndpoint(String id, String host, int port) throws GatewayException {
        if (this.alreadyDefinesEndpoint(id, host, port)) {
            throw new GatewayException(LocalizedStrings.GatewayCreation_GATEWAY_0_ALREADY_DEFINES_AN_ENDPOINT_EITHER_WITH_ID_1_OR_HOST_2_AND_PORT_3.toLocalizedString(this._id, id, host, port));
        }
        String[] otherGateway = new String[1];
        if (this.otherGatewayDefinesEndpoint(host, port, otherGateway)) {
            throw new GatewayException(LocalizedStrings.GatewayCreation_GATEWAY_0_CANNOT_DEFINE_ENDPOINT_HOST_1_AND_PORT_2_BECAUSE_IT_IS_ALREADY_DEFINED_BY_GATEWAY_3.toLocalizedString(this._id, host, port, otherGateway[0]));
        }
        if (this.isConnectingToOwnHub(host, port)) {
            throw new GatewayException(LocalizedStrings.GatewayCreation_GATEWAY_0_CANNOT_DEFINE_AN_ENDPOINT_TO_ITS_OWN_HUB_HOST_1_AND_PORT_2.toLocalizedString(this._id, host, port));
        }
        if (this.hasListeners()) {
            throw new GatewayException(LocalizedStrings.GatewayCreation_GATEWAY_0_CANNOT_DEFINE_AN_ENDPOINT_BECAUSE_AT_LEAST_ONE_LISTENER_IS_ALREADY_DEFINED_BOTH_LISTENERS_AND_ENDPOINTS_CANNOT_BE_DEFINED_FOR_THE_SAME_GATEWAY.toLocalizedString(this._id));
        }
        this._endpoints.add(new EndpointCreation(id, host, port));
    }

    @Override
    public List getEndpoints() {
        return this._endpoints;
    }

    @Override
    public boolean hasEndpoints() {
        return this.getEndpoints().size() > 0;
    }

    @Override
    public void addListener(GatewayEventListener listener) throws GatewayException {
        if (this.hasEndpoints()) {
            throw new GatewayException(LocalizedStrings.GatewayCreation_GATEWAY_0_CANNOT_DEFINE_A_LISTENER_BECAUSE_AT_LEAST_ONE_ENDPOINT_IS_ALREADY_DEFINED_BOTH_LISTENERS_AND_ENDPOINTS_CANNOT_BE_DEFINED_FOR_THE_SAME_GATEWAY.toLocalizedString(this._id));
        }
        this._listeners.add(listener);
    }

    public List getListeners() {
        return this._listeners;
    }

    @Override
    public boolean hasListeners() {
        return this.getListeners().size() > 0;
    }

    @Override
    public void setQueueAttributes(GatewayQueueAttributes queueAttributes) {
        this._queueAttributes = queueAttributes;
    }

    @Override
    public GatewayQueueAttributes getQueueAttributes() {
        return this._queueAttributes;
    }

    @Override
    public void setEarlyAck(boolean earlyAck) {
        this._earlyAck = earlyAck;
    }

    @Override
    public boolean getEarlyAck() {
        return this._earlyAck;
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this._socketBufferSize = socketBufferSize;
    }

    @Override
    public int getSocketBufferSize() {
        return this._socketBufferSize;
    }

    @Override
    public void setSocketReadTimeout(int socketReadTimeout) {
        this._socketReadTimeout = socketReadTimeout;
    }

    @Override
    public int getSocketReadTimeout() {
        return this._socketReadTimeout;
    }

    @Override
    public int getConcurrencyLevel() {
        return this._concurrencyLevel;
    }

    @Override
    public void setOrderPolicy(Gateway.OrderPolicy orderPolicy) throws GatewayException {
        if (orderPolicy != null) {
            if (this.getConcurrencyLevel() == 1) {
                throw new GatewayException(LocalizedStrings.CacheXmlParser_INVALID_GATEWAY_ORDER_POLICY_CONCURRENCY_0.toLocalizedString(this.getId()));
            }
            this._orderPolicy = orderPolicy;
        }
    }

    @Override
    public Gateway.OrderPolicy getOrderPolicy() {
        return this._orderPolicy;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public boolean isRunning() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isConnected() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public int getQueueSize() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isPaused() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    protected GatewayHub getGatewayHub() {
        return this._hub;
    }

    protected boolean otherGatewayDefinesEndpoint(String host, int port, String[] otherGateway) {
        boolean otherGatewayDefined = false;
        block0: for (Gateway gateway : this.getGatewayHub().getGateways()) {
            if (this.getId().equals(gateway.getId())) continue;
            for (Gateway.Endpoint endpoint : gateway.getEndpoints()) {
                if (!endpoint.getHost().equals(host) || endpoint.getPort() != port) continue;
                otherGatewayDefined = true;
                otherGateway[0] = gateway.getId();
                continue block0;
            }
        }
        return otherGatewayDefined;
    }

    protected boolean alreadyDefinesEndpoint(String id, String host, int port) {
        boolean alreadyDefined = false;
        for (Gateway.Endpoint endpoint : this._endpoints) {
            if (!endpoint.getId().equals(id) && (!endpoint.getHost().equals(host) || endpoint.getPort() != port)) continue;
            alreadyDefined = true;
            break;
        }
        return alreadyDefined;
    }

    protected boolean isConnectingToOwnHub(String host, int port) {
        boolean isConnectingToOwnHub = false;
        if (port == this._hub.getPort()) {
            try {
                String localHostName = SocketCreator.getLocalHost().getCanonicalHostName();
                String requestedHostName = InetAddress.getByName(host).getCanonicalHostName();
                if (localHostName.equals(requestedHostName) || requestedHostName.startsWith("localhost")) {
                    isConnectingToOwnHub = true;
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        return isConnectingToOwnHub;
    }

    protected static class EndpointCreation
    implements Gateway.Endpoint {
        protected String _id;
        protected String _host;
        protected int _port;

        protected EndpointCreation(String id, String host, int port) {
            this._id = id;
            this._host = host;
            this._port = port;
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public String getHost() {
            return this._host;
        }

        @Override
        public int getPort() {
            return this._port;
        }
    }
}

