/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationData;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.extension.Extensible;
import com.gemstone.gemfire.internal.cache.extension.ExtensionPoint;
import com.gemstone.gemfire.internal.cache.extension.SimpleExtensionPoint;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class RegionCreation
implements Region,
Extensible<Region<?, ?>> {
    private final String name;
    private String refid;
    private boolean hasAttributes;
    private final String fullPath;
    private RegionAttributesCreation attrs;
    private Map subregions = new LinkedHashMap();
    private Map values = new HashMap();
    private List indexes = new ArrayList();
    private final CacheCreation cache;
    private final SimpleExtensionPoint<Region<?, ?>> extensionPoint = new SimpleExtensionPoint<RegionCreation>(this, this);

    public RegionCreation(CacheCreation cache, RegionCreation parent, String name, String refid) {
        this.cache = cache;
        this.fullPath = parent != null ? parent.getFullPath() + "/" + name : "/" + name;
        this.name = name;
        this.refid = refid;
        this.attrs = new RegionAttributesCreation(this.cache);
        if (refid != null) {
            this.attrs.setRefid(refid);
            this.attrs.inheritAttributes(cache);
        }
    }

    public RegionCreation(CacheCreation cache, String name, String refid) {
        this(cache, null, name, refid);
    }

    public RegionCreation(CacheCreation cache, String name) {
        this(cache, null, name, null);
    }

    @Override
    public Object put(Object key2, Object value2) throws TimeoutException, CacheWriterException {
        return this.values.put(key2, value2);
    }

    private void fillIn(Region region) throws TimeoutException, CacheWriterException, RegionExistsException {
        for (Map.Entry entry : this.values.entrySet()) {
            region.put(entry.getKey(), entry.getValue());
        }
        if (region instanceof Extensible) {
            Extensible extensible = (Extensible)((Object)region);
            this.extensionPoint.fireCreate(extensible);
        }
        for (RegionCreation sub : this.subregions.values()) {
            sub.create(region);
        }
    }

    private void setMutableAttributes(Region region) {
        AttributesMutator mutator = region.getAttributesMutator();
        RegionAttributesCreation attrs = this.attrs;
        if (attrs.hasCacheListeners()) {
            mutator.initCacheListeners(attrs.getCacheListeners());
        }
        if (attrs.hasCacheLoader()) {
            mutator.setCacheLoader(attrs.getCacheLoader());
        }
        if (attrs.hasCacheWriter()) {
            mutator.setCacheWriter(attrs.getCacheWriter());
        }
        if (attrs.hasEntryIdleTimeout()) {
            mutator.setEntryIdleTimeout(attrs.getEntryIdleTimeout());
        }
        if (attrs.hasCustomEntryIdleTimeout()) {
            mutator.setCustomEntryIdleTimeout(attrs.getCustomEntryIdleTimeout());
        }
        if (attrs.hasEntryTimeToLive()) {
            mutator.setEntryTimeToLive(attrs.getEntryTimeToLive());
        }
        if (attrs.hasCustomEntryTimeToLive()) {
            mutator.setCustomEntryTimeToLive(attrs.getCustomEntryTimeToLive());
        }
        if (attrs.hasRegionIdleTimeout()) {
            mutator.setRegionIdleTimeout(attrs.getEntryIdleTimeout());
        }
        if (attrs.hasRegionTimeToLive()) {
            mutator.setRegionTimeToLive(attrs.getRegionTimeToLive());
        }
        if (attrs.hasCloningEnabled()) {
            mutator.setCloningEnabled(attrs.getCloningEnabled());
        }
    }

    void createRoot(Cache cache) throws TimeoutException, CacheWriterException, RegionExistsException {
        Region root = null;
        this.attrs.inheritAttributes(cache);
        this.attrs.setIndexes(this.indexes);
        this.attrs.prepareForValidation();
        try {
            root = ((GemFireCacheImpl)cache).basicCreateRegion(this.name, new AttributesFactory(this.attrs).create());
        }
        catch (RegionExistsException ex) {
            root = ex.getRegion();
            this.setMutableAttributes(root);
        }
        catch (RegionDestroyedException ex) {
            cache.getLoggerI18n().warning(LocalizedStrings.RegionCreation_REGION_DESTROYED_DURING_INITIALIZATION, this.name);
        }
        if (root != null) {
            this.fillIn(root);
        }
    }

    void addIndexData(IndexCreationData icd) {
        this.indexes.add(icd);
    }

    void create(Region parent) throws TimeoutException, CacheWriterException, RegionExistsException {
        this.attrs.inheritAttributes(parent.getCache());
        this.attrs.prepareForValidation();
        this.attrs.setIndexes(this.indexes);
        Region me = null;
        try {
            me = parent.createSubregion(this.name, new AttributesFactory(this.attrs).create());
        }
        catch (RegionExistsException ex) {
            me = ex.getRegion();
            this.setMutableAttributes(me);
        }
        catch (RegionDestroyedException ex) {
            this.cache.getLoggerI18n().warning(LocalizedStrings.RegionCreation_REGION_DESTROYED_DURING_INITIALIZATION, this.name);
        }
        if (me != null) {
            String id = this.attrs.getId();
            if (id != null) {
                RegionAttributes realAttrs = me.getAttributes();
                me.getCache().setRegionAttributes(id, realAttrs);
            }
            this.fillIn(me);
        }
    }

    public boolean sameAs(Region other) {
        if (other == null) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            throw new RuntimeException(LocalizedStrings.RegionCreation_REGION_NAMES_DIFFER_THIS_0_OTHER_1.toLocalizedString(this.getName(), other.getName()));
        }
        if (!this.attrs.sameAs(other.getAttributes())) {
            throw new RuntimeException(LocalizedStrings.RegionCreation_REGION_ATTRIBUTES_DIFFER_THIS_0_OTHER_1.toLocalizedString(this.attrs, other.getAttributes()));
        }
        Set myEntries = this.basicEntries(false);
        Set otherEntries = ((LocalRegion)other).basicEntries(false);
        if (myEntries.size() != otherEntries.size()) {
            return false;
        }
        for (Region.Entry myEntry : myEntries) {
            Region.Entry otherEntry = other.getEntry(myEntry.getKey());
            if (otherEntry == null) {
                return false;
            }
            if (myEntry.getValue().equals(otherEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setAttributes(RegionAttributes attrs) {
        this.setAttributes(attrs, true);
    }

    public void setAttributes(RegionAttributes attrs, boolean setRefid) {
        this.hasAttributes = true;
        this.attrs = attrs instanceof RegionAttributesCreation ? (RegionAttributesCreation)attrs : new RegionAttributesCreation(this.cache, attrs, false);
        if (setRefid && this.attrs.getRefid() == null) {
            this.attrs.setRefid(this.getRefid());
        }
        if (attrs.getPartitionAttributes() != null && attrs.getEvictionAttributes() != null && attrs.getEvictionAttributes().getAlgorithm().isLRUMemory() && attrs.getPartitionAttributes().getLocalMaxMemory() != 0 && attrs.getEvictionAttributes().getMaximum() != attrs.getPartitionAttributes().getLocalMaxMemory()) {
            this.getCache().getLoggerI18n().warning(LocalizedStrings.Mem_LRU_Eviction_Attribute_Reset, new Object[]{this.getName(), attrs.getEvictionAttributes().getMaximum(), attrs.getPartitionAttributes().getLocalMaxMemory()});
            attrs.getEvictionAttributes();
            this.attrs.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes(attrs.getPartitionAttributes().getLocalMaxMemory(), attrs.getEvictionAttributes().getObjectSizer(), attrs.getEvictionAttributes().getAction()));
        }
    }

    public RegionAttributes getAttributes() {
        return this.attrs;
    }

    public Region getSubregion(String regionName) {
        return (Region)this.subregions.get(regionName);
    }

    void addSubregion(String name, RegionCreation region) throws RegionExistsException {
        if (this.subregions.containsKey(name)) {
            RegionCreation existing = (RegionCreation)this.subregions.get(name);
            throw new RegionExistsException(existing);
        }
        this.subregions.put(name, region);
    }

    public Set subregions(boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_GETTING_SUBREGIONS_RECURSIVELY_IS_NOT_SUPPORTED.toLocalizedString());
        }
        return new HashSet(this.subregions.values());
    }

    @Override
    public void writeToDisk() {
        throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_WRITING_A_REGIONCREATION_TO_DISK_IS_NOT_SUPPORTED.toLocalizedString());
    }

    public void registerInterest(Object key2) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key2, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key2, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key2, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key2, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key2, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key2) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key2, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public void unregisterInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterestRegex(String regex, boolean isDurable) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestList() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getDurableInterestList() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestListRegex() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public Set keySetOnServer() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    @Override
    public boolean containsKeyOnServer(Object key2) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public Region.Entry getEntry(Object key2) {
        Object value2 = this.values.get(key2);
        if (value2 == null) {
            return null;
        }
        return new Entry(key2, value2);
    }

    public Set entries(boolean recursive) {
        return this.basicEntries(recursive);
    }

    public Set basicEntries(boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_GETTING_ENTRIES_RECURSIVELY_IS_NOT_SUPPORTED.toLocalizedString());
        }
        HashSet<Entry> set = new HashSet<Entry>();
        for (Map.Entry entry : this.values.entrySet()) {
            set.add(new Entry(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public Region getParentRegion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public AttributesMutator getAttributesMutator() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public CacheStatistics getStatistics() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidateRegion() throws TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidateRegion(Object aCallbackArgument) throws TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidateRegion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidateRegion(Object aCallbackArgument) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void destroyRegion() throws CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void destroyRegion(Object aCacheWriterParam) throws CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroyRegion() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroyRegion(Object aCallbackArgument) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Region createSubregion(String subregionName, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        RegionCreation subregion = new RegionCreation(this.cache, this, subregionName, null);
        subregion.setAttributes(attrs);
        this.addSubregion(subregionName, subregion);
        return subregion;
    }

    @Override
    public Object get(Object key2) throws CacheLoaderException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object get(Object key2, Object aCallbackArgument) throws TimeoutException, CacheLoaderException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object put(Object key2, Object value2, Object aCacheWriterParam) throws TimeoutException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void create(Object key2, Object value2) throws TimeoutException, EntryExistsException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void create(Object key2, Object value2, Object aCacheWriterParam) throws TimeoutException, EntryExistsException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidate(Object key2) throws TimeoutException, EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void invalidate(Object key2, Object callbackArgument) throws TimeoutException, EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidate(Object key2) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localInvalidate(Object key2, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object destroy(Object key2) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Object destroy(Object key2, Object aCacheWriterParam) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroy(Object key2) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void localDestroy(Object key2, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Set keys() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public RegionService getRegionService() {
        return this.cache;
    }

    @Override
    public Object getUserAttribute() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void setUserAttribute(Object value2) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isDestroyed() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean containsValueForKey(Object key2) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean containsKey(Object key2) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Lock getRegionDistributedLock() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Lock getDistributedLock(Object key2) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean existsValue(String predicate) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public SelectResults query(String predicate) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Object selectValue(String predicate) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void becomeLockGrantor() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void putAll(Map arg0) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void putAll(Map arg0, Object callbackArg) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Map getAll(Collection keys) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Map getAll(Collection keys, Object callback) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public Object remove(Object arg0) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public Set entrySet(boolean recursive) {
        if (recursive) {
            throw new UnsupportedOperationException(LocalizedStrings.RegionCreation_GETTING_ENTRIES_RECURSIVELY_IS_NOT_SUPPORTED.toLocalizedString());
        }
        HashSet<Entry> set = new HashSet<Entry>();
        for (Map.Entry entry : this.values.entrySet()) {
            set.add(new Entry(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    @Override
    public void localClear() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public void forceRolling() {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public boolean forceCompaction() {
        throw new UnsupportedOperationException("Shouldn't be invoked");
    }

    @Override
    public Object putIfAbsent(Object key2, Object value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key2, Object value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replace(Object key2, Object value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Object key2, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void setRefid(String refid) {
        this.refid = refid;
    }

    public String getRefid() {
        return this.refid;
    }

    public boolean hasAttributes() {
        return this.hasAttributes;
    }

    public RegionSnapshotService<?, ?> getSnapshotService() {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Collection keys) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    public void removeAll(Collection keys, Object aCallbackArgument) {
        throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
    }

    @Override
    public ExtensionPoint<Region<?, ?>> getExtensionPoint() {
        return this.extensionPoint;
    }

    static class Entry
    implements Region.Entry {
        private Object key;
        private Object value;

        Entry(Object key2, Object value2) {
            this.key = key2;
            this.value = value2;
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public Region getRegion() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public CacheStatistics getStatistics() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Object getUserAttribute() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Object setUserAttribute(Object userAttribute) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public boolean isDestroyed() {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }

        @Override
        public Object setValue(Object arg0) {
            throw new UnsupportedOperationException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }
    }
}

