/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.xmlcache;

import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.ResourceManager;
import java.util.Set;

public class ResourceManagerCreation
implements ResourceManager {
    private volatile float criticalHeapPercentage;
    private boolean criticalHeapSet = false;
    private volatile float evictionHeapPercentage;
    private boolean evictionHeapSet = false;

    @Override
    public RebalanceFactory createRebalanceFactory() {
        throw new IllegalArgumentException("Unused");
    }

    @Override
    public Set<RebalanceOperation> getRebalanceOperations() {
        throw new IllegalArgumentException("Unused");
    }

    @Override
    public float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    @Override
    public void setCriticalHeapPercentage(float heapPercentage) {
        this.criticalHeapSet = true;
        this.criticalHeapPercentage = heapPercentage;
    }

    public void setCriticalHeapPercentageToDefault() {
        this.criticalHeapPercentage = 0.0f;
    }

    public void setEvictionHeapPercentageToDefault() {
        this.evictionHeapPercentage = 0.0f;
    }

    public boolean hasCriticalHeap() {
        return this.criticalHeapSet;
    }

    public void configure(ResourceManager r) {
        if (this.hasCriticalHeap()) {
            r.setCriticalHeapPercentage(this.criticalHeapPercentage);
        }
        if (this.hasEvictionHeap()) {
            r.setEvictionHeapPercentage(this.evictionHeapPercentage);
        }
    }

    public void sameAs(ResourceManager other) {
        if (this.getCriticalHeapPercentage() != other.getCriticalHeapPercentage()) {
            throw new RuntimeException("Resource Manager critical heap percentages differ: " + this.getCriticalHeapPercentage() + " != " + other.getCriticalHeapPercentage());
        }
        if (this.hasEvictionHeap() && this.getEvictionHeapPercentage() != other.getEvictionHeapPercentage()) {
            throw new RuntimeException("Resource Manager eviction heap percentages differ: " + this.getEvictionHeapPercentage() + " != " + other.getEvictionHeapPercentage());
        }
    }

    @Override
    public float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    @Override
    public void setEvictionHeapPercentage(float heapPercentage) {
        this.evictionHeapSet = true;
        this.evictionHeapPercentage = heapPercentage;
    }

    public boolean hasEvictionHeap() {
        return this.evictionHeapSet;
    }
}

