/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.datasource;

import com.gemstone.gemfire.internal.datasource.AbstractPoolCache;
import com.gemstone.gemfire.internal.datasource.ConfiguredDataSourceProperties;
import com.gemstone.gemfire.internal.datasource.PoolException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.logging.log4j.Logger;

public class ManagedPoolCacheImpl
extends AbstractPoolCache {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1064642271736399718L;
    private ManagedConnectionFactory connFactory;
    private Subject sub;
    private ConnectionRequestInfo connReqInfo;

    public ManagedPoolCacheImpl(ManagedConnectionFactory connFac, Subject subject, ConnectionRequestInfo connReq, ConnectionEventListener eventListner, ConfiguredDataSourceProperties configs) throws PoolException {
        super(eventListner, configs);
        this.connFactory = connFac;
        this.sub = subject;
        this.connReqInfo = connReq;
        this.initializePool();
    }

    @Override
    public Object getNewPoolConnection() throws PoolException {
        ManagedConnection manConn = null;
        try {
            manConn = this.connFactory.createManagedConnection(this.sub, this.connReqInfo);
        }
        catch (ResourceException rex) {
            rex.printStackTrace();
            throw new PoolException(LocalizedStrings.ManagedPoolCacheImpl_MANAGEDPOOLCACHEIMPLGETNEWCONNECTION_EXCEPTION_IN_CREATING_NEW_MANAGED_POOLEDCONNECTION.toLocalizedString(), rex);
        }
        manConn.addConnectionEventListener((ConnectionEventListener)this.connEventListner);
        return manConn;
    }

    @Override
    void destroyPooledConnection(Object connectionObject) {
        block2: {
            try {
                ((ManagedConnection)connectionObject).removeConnectionEventListener((ConnectionEventListener)this.connEventListner);
                ((ManagedConnection)connectionObject).destroy();
                connectionObject = null;
            }
            catch (ResourceException rex) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace("ManagedPoolcacheImpl::destroyPooledConnection:Exception in closing the connection.Ignoring it. The exeption is {}", rex.getMessage(), rex);
            }
        }
    }
}

