/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jndi;

import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.jndi.NameParserImpl;
import com.gemstone.gemfire.internal.jta.TransactionUtils;
import com.gemstone.gemfire.internal.jta.UserTransactionImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.transaction.SystemException;

public class ContextImpl
implements Context {
    private static final String ROOT_CONTEXT_NAME = "ROOT";
    private static final NameParser nameParser = new NameParserImpl();
    private final Map ctxMaps = Collections.synchronizedMap(new HashMap());
    private String ctxName;
    private ContextImpl parentCtx;
    private boolean isDestroyed;

    private ContextImpl(ContextImpl parentCtx, String name) {
        this.parentCtx = parentCtx;
        this.ctxName = name;
        this.isDestroyed = false;
    }

    public ContextImpl() {
        this(null, ROOT_CONTEXT_NAME);
    }

    @Override
    public Object addToEnvironment(String key2, Object value2) throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_ADDTOENVIRONMENTSTRING_KEY_OBJECT_VALUE_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.checkIsDestroyed();
        this.rebind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(nameParser.parse(name), obj);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        this.checkIsDestroyed();
        Name parsedPrefix = this.getParsedName((Name)prefix.clone());
        Name parsedName = this.getParsedName(name);
        return parsedPrefix.addAll(parsedName);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        this.checkIsDestroyed();
        return this.composeName(nameParser.parse(name), nameParser.parse(prefix)).toString();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException(LocalizedStrings.ContextImpl_NAME_CAN_NOT_BE_EMPTY.toLocalizedString());
        }
        String subContextName = parsedName.get(0);
        Object boundObject = this.ctxMaps.get(parsedName.get(0));
        if (parsedName.size() == 1) {
            if (boundObject == null) {
                ContextImpl subContext = new ContextImpl(this, subContextName);
                this.ctxMaps.put(subContextName, subContext);
                return subContext;
            }
            throw new NameAlreadyBoundException(LocalizedStrings.ContextImpl_NAME_0_IS_ALREADY_BOUND.toLocalizedString(subContextName));
        }
        if (boundObject instanceof Context) {
            return ((Context)boundObject).createSubcontext(parsedName.getSuffix(1));
        }
        throw new NotContextException(LocalizedStrings.ContextImpl_EXPECTED_CONTEXT_BUT_FOUND_0.toLocalizedString(boundObject));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(nameParser.parse(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException(LocalizedStrings.ContextImpl_NAME_CAN_NOT_BE_EMPTY.toLocalizedString());
        }
        String subContextName = parsedName.get(0);
        Object boundObject = this.ctxMaps.get(subContextName);
        if (boundObject == null) {
            throw new NameNotFoundException(LocalizedStrings.ContextImpl_NAME_0_NOT_FOUND_IN_THE_CONTEXT.toLocalizedString(subContextName));
        }
        if (!(boundObject instanceof ContextImpl)) {
            throw new NotContextException();
        }
        ContextImpl contextToDestroy = (ContextImpl)boundObject;
        if (parsedName.size() == 1) {
            if (contextToDestroy.ctxMaps.size() != 0) throw new ContextNotEmptyException(LocalizedStrings.ContextImpl_CAN_NOT_DESTROY_NONEMPTY_CONTEXT.toLocalizedString());
            this.ctxMaps.remove(subContextName);
            contextToDestroy.destroyInternal();
            return;
        } else {
            ((ContextImpl)boundObject).destroySubcontext(parsedName.getSuffix(1));
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(nameParser.parse(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_GETENVIRONMENT_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_GETNAMEINNAMESPACE_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        this.checkIsDestroyed();
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        this.checkIsDestroyed();
        return nameParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(nameParser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0) {
            Vector<Binding> bindings = new Vector<Binding>();
            for (String bindingName : this.ctxMaps.keySet()) {
                bindings.addElement(new Binding(bindingName, this.ctxMaps.get(bindingName)));
            }
            return new NamingEnumerationImpl(bindings);
        }
        Object subContext = this.ctxMaps.get(parsedName.get(0));
        if (subContext instanceof Context) {
            Name nextLayer = nameParser.parse("");
            if (parsedName.size() > 1) {
                nextLayer = parsedName.getSuffix(1);
            }
            return ((Context)subContext).list(nextLayer);
        }
        if (subContext == null && !this.ctxMaps.containsKey(parsedName.get(0))) {
            throw new NameNotFoundException(LocalizedStrings.ContextImpl_NAME_0_NOT_FOUND.toLocalizedString(name));
        }
        throw new NotContextException(LocalizedStrings.ContextImpl_EXPECTED_CONTEXT_BUT_FOUND_0.toLocalizedString(subContext));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(nameParser.parse(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        this.checkIsDestroyed();
        try {
            Name parsedName = this.getParsedName(name);
            String nameComponent = parsedName.get(0);
            Object res = this.ctxMaps.get(nameComponent);
            if (res instanceof UserTransactionImpl) {
                res = new UserTransactionImpl();
            }
            if (!this.ctxMaps.containsKey(nameComponent)) {
                throw new NameNotFoundException(LocalizedStrings.ContextImpl_NAME_0_NOT_FOUND.toLocalizedString(name));
            }
            if (parsedName.size() > 1) {
                if (res instanceof ContextImpl) {
                    res = ((ContextImpl)res).lookup(parsedName.getSuffix(1));
                } else {
                    throw new NotContextException(LocalizedStrings.ContextImpl_EXPECTED_CONTEXTIMPL_BUT_FOUND_0.toLocalizedString(res));
                }
            }
            return res;
        }
        catch (NameNotFoundException e) {
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.infoEnabled()) {
                writer.info(LocalizedStrings.ContextImpl_CONTEXTIMPL_LOOKUP_ERROR_WHILE_LOOKING_UP_0, name, (Throwable)e);
            }
            throw new NameNotFoundException(LocalizedStrings.ContextImpl_NAME_0_NOT_FOUND.toLocalizedString(name));
        }
        catch (SystemException se) {
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.severeEnabled()) {
                writer.info(LocalizedStrings.ContextImpl_CONTEXTIMPL_LOOKUP_ERROR_WHILE_CREATING_USERTRANSACTION_OBJECT, se);
            }
            throw new NameNotFoundException(LocalizedStrings.ContextImpl_CONTEXTIMPL_LOOKUP_ERROR_WHILE_CREATING_USERTRANSACTION_OBJECT.toLocalizedString());
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        this.checkIsDestroyed();
        try {
            return this.lookup(nameParser.parse(name));
        }
        catch (NameNotFoundException e) {
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.infoEnabled()) {
                writer.info(LocalizedStrings.ContextImpl_CONTEXTIMPL_LOOKUP_ERROR_WHILE_LOOKING_UP_0, name, (Throwable)e);
            }
            throw new NameNotFoundException(LocalizedStrings.ContextImpl_NAME_0_NOT_FOUND.toLocalizedString(name));
        }
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_LOOKUPLINKNAME_NAME_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_LOOKUPLINKSTRING_NAME_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException(LocalizedStrings.ContextImpl_NAME_CAN_NOT_BE_EMPTY.toLocalizedString());
        }
        String nameToBind = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.ctxMaps.put(nameToBind, obj);
        } else {
            Object boundObject = this.ctxMaps.get(nameToBind);
            if (boundObject instanceof Context) {
                ((Context)boundObject).bind(parsedName.getSuffix(1), obj);
            } else if (boundObject == null) {
                Context sub = this.createSubcontext(nameToBind);
                sub.bind(parsedName.getSuffix(1), obj);
            } else {
                throw new NotContextException(LocalizedStrings.ContextImpl_EXPECTED_CONTEXT_BUT_FOUND_0.toLocalizedString(boundObject));
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(nameParser.parse(name), obj);
    }

    @Override
    public Object removeFromEnvironment(String key2) throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_REMOVEFROMENVIRONMENTSTRING_KEY_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public void rename(Name name1, Name name2) throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_RENAMENAME_NAME1_NAME_NAME2_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public void rename(String name1, String name2) throws NamingException {
        throw new NamingException(LocalizedStrings.ContextImpl_RENAMESTRING_NAME1_STRING_NAME2_IS_NOT_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = this.getParsedName(name);
        if (parsedName.size() == 0 || parsedName.get(0).length() == 0) {
            throw new InvalidNameException(LocalizedStrings.ContextImpl_NAME_CAN_NOT_BE_EMPTY.toLocalizedString());
        }
        String nameToRemove = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.ctxMaps.remove(nameToRemove);
        } else {
            Object boundObject = this.ctxMaps.get(nameToRemove);
            if (boundObject instanceof Context) {
                ((Context)boundObject).unbind(parsedName.getSuffix(1));
            } else {
                if (!this.ctxMaps.containsKey(nameToRemove)) {
                    throw new NameNotFoundException(LocalizedStrings.ContextImpl_CAN_NOT_FIND_0.toLocalizedString(name));
                }
                throw new NotContextException(LocalizedStrings.ContextImpl_EXPECTED_CONTEXT_BUT_FOUND_0.toLocalizedString(boundObject));
            }
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(nameParser.parse(name));
    }

    private void checkIsDestroyed() throws NamingException {
        if (this.isDestroyed) {
            throw new NoPermissionException(LocalizedStrings.ContextImpl_CAN_NOT_INVOKE_OPERATIONS_ON_DESTROYED_CONTEXT.toLocalizedString());
        }
    }

    private void destroyInternal() {
        this.isDestroyed = true;
    }

    private Name getParsedName(Name name) throws NamingException {
        Name result = null;
        if (name instanceof CompositeName) {
            if (name.size() == 0) {
                result = nameParser.parse("");
            } else if (name.size() > 1) {
                throw new InvalidNameException(LocalizedStrings.ContextImpl_MULTIPLE_NAME_SYSTEMS_ARE_NOT_SUPPORTED.toLocalizedString());
            }
            result = nameParser.parse(name.get(0));
        } else {
            result = (Name)name.clone();
        }
        while (!result.isEmpty()) {
            if (result.get(0).length() == 0) {
                result.remove(0);
                continue;
            }
            if (result.get(result.size() - 1).length() != 0) break;
            result.remove(result.size() - 1);
        }
        for (int i = 1; i < result.size() - 1; ++i) {
            if (result.get(i).length() != 0) continue;
            throw new InvalidNameException(LocalizedStrings.ContextImpl_EMPTY_INTERMEDIATE_COMPONENTS_ARE_NOT_SUPPORTED.toLocalizedString());
        }
        return result;
    }

    String getCompoundStringName() throws NamingException {
        String compositeName = "";
        ContextImpl curCtx = this;
        while (!curCtx.isRootContext()) {
            compositeName = this.composeName(compositeName, curCtx.getAtomicName());
            curCtx = curCtx.getParentContext();
        }
        return compositeName;
    }

    ContextImpl getParentContext() {
        return this.parentCtx;
    }

    String getAtomicName() {
        return this.ctxName;
    }

    boolean isRootContext() {
        return this.getParentContext() == null;
    }

    private static class NamingEnumerationImpl
    implements NamingEnumeration {
        private Vector elements;
        private int currentElement;

        NamingEnumerationImpl(Vector elements) {
            this.elements = elements;
            this.currentElement = 0;
        }

        @Override
        public void close() {
            this.currentElement = 0;
            this.elements.clear();
        }

        @Override
        public boolean hasMore() {
            return this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.currentElement < this.elements.size()) {
                return true;
            }
            this.close();
            return false;
        }

        public Object next() {
            return this.nextElement();
        }

        @Override
        public Object nextElement() {
            if (this.hasMoreElements()) {
                return this.elements.get(this.currentElement++);
            }
            throw new NoSuchElementException();
        }
    }
}

