/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jndi;

import com.gemstone.gemfire.internal.jndi.ContextImpl;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class InitialContextFactoryImpl
implements InitialContextFactory {
    private static Map oldSystemProps = new HashMap();
    private static Context ctx;

    public synchronized Context getInitialContext(Hashtable environment) throws NamingException {
        if (ctx == null) {
            ctx = new ContextImpl();
        }
        return ctx;
    }

    public void setAsInitial() throws NamingException {
        String key2 = "java.naming.factory.initial";
        oldSystemProps.put(key2, System.getProperty(key2));
        key2 = "java.naming.factory.url.pkgs";
        oldSystemProps.put(key2, System.getProperty(key2));
        System.setProperty("java.naming.factory.initial", InitialContextFactoryImpl.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", "com.gemstone.gemfire.internal.jndi");
    }

    public static void revertSetAsInitial() {
        for (Map.Entry entry : oldSystemProps.entrySet()) {
            InitialContextFactoryImpl.restoreSystemProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void restoreSystemProperty(String key2, String value2) {
        if (value2 != null) {
            System.setProperty(key2, value2);
        } else {
            System.getProperties().remove(key2);
        }
    }
}

