/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jndi;

import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.datasource.AbstractDataSource;
import com.gemstone.gemfire.internal.datasource.ClientConnectionFactoryWrapper;
import com.gemstone.gemfire.internal.datasource.DataSourceCreateException;
import com.gemstone.gemfire.internal.datasource.DataSourceFactory;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.jta.TransactionManagerImpl;
import com.gemstone.gemfire.internal.jta.TransactionUtils;
import com.gemstone.gemfire.internal.jta.UserTransactionImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public class JNDIInvoker {
    private static Context ctx;
    private static TransactionManager transactionManager;
    private static String[][] knownJNDIManagers;
    private static final String WS_FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    private static List dataSourceList;
    private static Boolean IGNORE_JTA;

    public static void mapTransactions() {
        block19: {
            try {
                InternalDistributedSystem distSystem = InternalDistributedSystem.getAnyInstance();
                TransactionUtils.setLogWriter(((DistributedSystem)distSystem).getLogWriter().convertToLogWriterI18n());
                JNDIInvoker.cleanup();
                if (IGNORE_JTA.booleanValue()) {
                    return;
                }
                ctx = new InitialContext();
                JNDIInvoker.doTransactionLookup();
            }
            catch (NamingException ne) {
                LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
                if (ne instanceof NoInitialContextException) {
                    String exception = "JNDIInvoker::mapTransactions:: No application server context found, Starting GemFire JNDI Context Context ";
                    if (writer.finerEnabled()) {
                        writer.finer(exception);
                    }
                    try {
                        JNDIInvoker.initializeGemFireContext();
                        transactionManager = TransactionManagerImpl.getTransactionManager();
                        ctx.rebind("java:/TransactionManager", (Object)transactionManager);
                        if (writer.fineEnabled()) {
                            writer.fine("JNDIInvoker::mapTransactions::Bound TransactionManager to Context GemFire JNDI Tree");
                        }
                        UserTransactionImpl utx = new UserTransactionImpl();
                        ctx.rebind("java:/UserTransaction", (Object)utx);
                        if (writer.fineEnabled()) {
                            writer.fine("JNDIInvoker::mapTransactions::Bound Transaction to Context GemFire JNDI Tree");
                        }
                    }
                    catch (NamingException ne1) {
                        if (writer.infoEnabled()) {
                            writer.info(LocalizedStrings.JNDIInvoker_JNDIINVOKERMAPTRANSACTIONSNAMINGEXCEPTION_WHILE_BINDING_TRANSACTIONMANAGERUSERTRANSACTION_TO_GEMFIRE_JNDI_TREE);
                        }
                        break block19;
                    }
                    catch (SystemException se1) {
                        if (writer.infoEnabled()) {
                            writer.info(LocalizedStrings.JNDIInvoker_JNDIINVOKERMAPTRANSACTIONSSYSTEMEXCEPTION_WHILE_BINDING_USERTRANSACTION_TO_GEMFIRE_JNDI_TREE);
                        }
                        break block19;
                    }
                }
                if (!(ne instanceof NameNotFoundException)) break block19;
                String exception = "JNDIInvoker::mapTransactions:: No TransactionManager associated to Application server context, trying to bind GemFire TransactionManager";
                if (writer.finerEnabled()) {
                    writer.finer(exception);
                }
                try {
                    transactionManager = TransactionManagerImpl.getTransactionManager();
                    ctx.rebind("java:/TransactionManager", (Object)transactionManager);
                    if (writer.fineEnabled()) {
                        writer.fine("JNDIInvoker::mapTransactions::Bound TransactionManager to Application Server Context");
                    }
                    UserTransactionImpl utx = new UserTransactionImpl();
                    ctx.rebind("java:/UserTransaction", (Object)utx);
                    if (writer.fineEnabled()) {
                        writer.fine("JNDIInvoker::mapTransactions::Bound UserTransaction to Application Server Context");
                    }
                }
                catch (NamingException ne1) {
                    if (writer.infoEnabled()) {
                        writer.info(LocalizedStrings.JNDIInvoker_JNDIINVOKERMAPTRANSACTIONSNAMINGEXCEPTION_WHILE_BINDING_TRANSACTIONMANAGERUSERTRANSACTION_TO_APPLICATION_SERVER_JNDI_TREE);
                    }
                }
                catch (SystemException se1) {
                    if (!writer.infoEnabled()) break block19;
                    writer.info(LocalizedStrings.JNDIInvoker_JNDIINVOKERMAPTRANSACTIONSSYSTEMEXCEPTION_WHILE_BINDING_TRANSACTIONMANAGERUSERTRANSACTION_TO_APPLICATION_SERVER_JNDI_TREE);
                }
            }
        }
    }

    private static void cleanup() {
        if (transactionManager instanceof TransactionManagerImpl) {
            TransactionManagerImpl.refresh();
            transactionManager = null;
            try {
                if (ctx != null) {
                    ctx.unbind("java:/TransactionManager");
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        int len = dataSourceList.size();
        for (int i = 0; i < len; ++i) {
            if (dataSourceList.get(i) instanceof AbstractDataSource) {
                ((AbstractDataSource)dataSourceList.get(i)).clearUp();
                continue;
            }
            if (!(dataSourceList.get(i) instanceof ClientConnectionFactoryWrapper)) continue;
            ((ClientConnectionFactoryWrapper)dataSourceList.get(i)).clearUp();
        }
        dataSourceList.clear();
        IGNORE_JTA = Boolean.getBoolean("gemfire.ignoreJTA");
    }

    private static void doTransactionLookup() throws NamingException {
        Class<?> clazz;
        Object jndiObject = null;
        LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
        for (int i = 0; i < knownJNDIManagers.length; ++i) {
            String exception;
            block19: {
                try {
                    jndiObject = ctx.lookup(knownJNDIManagers[i][0]);
                }
                catch (NamingException e) {
                    String exception2 = "JNDIInvoker::doTransactionLookup::Couldn't lookup [" + knownJNDIManagers[i][0] + " (" + knownJNDIManagers[i][1] + ")]";
                    if (!writer.finerEnabled()) break block19;
                    writer.finer(exception2);
                }
            }
            if (jndiObject instanceof TransactionManager) {
                transactionManager = (TransactionManager)jndiObject;
                exception = "JNDIInvoker::doTransactionLookup::Found TransactionManager for " + knownJNDIManagers[i][1];
                if (writer.fineEnabled()) {
                    writer.fine(exception);
                }
                return;
            }
            exception = "JNDIInvoker::doTransactionLookup::Found TransactionManager of class " + (jndiObject == null ? "null" : jndiObject.getClass()) + " but is not of type javax.transaction.TransactionManager";
            if (!writer.fineEnabled()) continue;
            writer.fine(exception);
        }
        try {
            if (writer.finerEnabled()) {
                writer.finer("JNDIInvoker::doTransactionLookup::Trying WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
            }
            clazz = ClassPathLoader.getLatest().forName(WS_FACTORY_CLASS_5_1);
            if (writer.fineEnabled()) {
                writer.fine("JNDIInvoker::doTransactionLookup::Found WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
            }
        }
        catch (ClassNotFoundException ex) {
            try {
                if (writer.finerEnabled()) {
                    writer.finer("JNDIInvoker::doTransactionLookup::Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                }
                clazz = ClassPathLoader.getLatest().forName(WS_FACTORY_CLASS_5_0);
                if (writer.fineEnabled()) {
                    writer.fine("JNDIInvoker::doTransactionLookup::Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                }
            }
            catch (ClassNotFoundException ex2) {
                try {
                    clazz = ClassPathLoader.getLatest().forName(WS_FACTORY_CLASS_4);
                    String exception = "JNDIInvoker::doTransactionLookup::Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA";
                    if (writer.fineEnabled()) {
                        writer.fine(exception, ex);
                    }
                }
                catch (ClassNotFoundException ex3) {
                    if (writer.finerEnabled()) {
                        writer.finer("JNDIInvoker::doTransactionLookup::Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4");
                    }
                    throw new NoInitialContextException();
                }
            }
        }
        try {
            Method method = clazz.getMethod("getTransactionManager", null);
            transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            writer.warning(LocalizedStrings.JNDIInvoker_JNDIINVOKER_DOTRANSACTIONLOOKUP_FOUND_WEBSPHERE_TRANSACTIONMANAGER_FACTORY_CLASS_0_BUT_COULDNT_INVOKE_ITS_STATIC_GETTRANSACTIONMANAGER_METHOD, clazz.getName(), (Throwable)ex);
            throw new NameNotFoundException(LocalizedStrings.JNDIInvoker_JNDIINVOKER_DOTRANSACTIONLOOKUP_FOUND_WEBSPHERE_TRANSACTIONMANAGER_FACTORY_CLASS_0_BUT_COULDNT_INVOKE_ITS_STATIC_GETTRANSACTIONMANAGER_METHOD.toLocalizedString(clazz.getName()));
        }
    }

    private static void initializeGemFireContext() throws NamingException {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("java.naming.factory.initial", "com.gemstone.gemfire.internal.jndi.InitialContextFactoryImpl");
        ctx = new InitialContext(table);
    }

    public static void mapDatasource(Map map, List props) {
        block17: {
            String value2 = (String)map.get("type");
            String jndiName = "";
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            DataSource ds = null;
            try {
                jndiName = (String)map.get("jndi-name");
                if (value2.equals("PooledDataSource")) {
                    ds = DataSourceFactory.getPooledDataSource(map, props);
                    ctx.rebind("java:/" + jndiName, (Object)ds);
                    dataSourceList.add(ds);
                    if (writer.fineEnabled()) {
                        writer.fine("Bound java:/" + jndiName + " to Context");
                    }
                } else if (value2.equals("XAPooledDataSource")) {
                    ds = DataSourceFactory.getTranxDataSource(map, props);
                    ctx.rebind("java:/" + jndiName, (Object)ds);
                    dataSourceList.add(ds);
                    if (writer.fineEnabled()) {
                        writer.fine("Bound java:/" + jndiName + " to Context");
                    }
                } else if (value2.equals("SimpleDataSource")) {
                    ds = DataSourceFactory.getSimpleDataSource(map, props);
                    ctx.rebind("java:/" + jndiName, (Object)ds);
                    if (writer.fineEnabled()) {
                        writer.fine("Bound java:/" + jndiName + " to Context");
                    }
                } else if (value2.equals("ManagedDataSource")) {
                    ClientConnectionFactoryWrapper ds1 = DataSourceFactory.getManagedDataSource(map, props);
                    ctx.rebind("java:/" + jndiName, ds1.getClientConnFactory());
                    dataSourceList.add(ds1);
                    if (writer.fineEnabled()) {
                        writer.fine("Bound java:/" + jndiName + " to Context");
                    }
                } else {
                    String exception = "JNDIInvoker::mapDataSource::No correct type of DataSource";
                    if (writer.fineEnabled()) {
                        writer.fine(exception);
                    }
                    throw new DataSourceCreateException(exception);
                }
                ds = null;
            }
            catch (NamingException ne) {
                if (writer.infoEnabled()) {
                    writer.info(LocalizedStrings.JNDIInvoker_JNDIINVOKER_MAPDATASOURCE_0_WHILE_BINDING_1_TO_JNDI_CONTEXT, new Object[]{"NamingException", jndiName});
                }
            }
            catch (DataSourceCreateException dsce) {
                if (!writer.infoEnabled()) break block17;
                writer.info(LocalizedStrings.JNDIInvoker_JNDIINVOKER_MAPDATASOURCE_0_WHILE_BINDING_1_TO_JNDI_CONTEXT, new Object[]{"DataSourceCreateException", jndiName});
            }
        }
    }

    public static Context getJNDIContext() {
        return ctx;
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    static {
        knownJNDIManagers = new String[][]{{"java:/TransactionManager", "JBoss"}, {"java:comp/TransactionManager", "Cosminexus"}, {"java:appserver/TransactionManager", "GlassFish"}, {"java:pm/TransactionManager", "SunONE"}, {"java:comp/UserTransaction", "Orion, JTOM, BEA WebLogic"}, {"javax.transaction.TransactionManager", "BEA WebLogic"}};
        dataSourceList = new ArrayList();
        IGNORE_JTA = Boolean.getBoolean("gemfire.ignoreJTA");
    }
}

