/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.jta;

import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.jta.TransactionManagerImpl;
import com.gemstone.gemfire.internal.jta.TransactionUtils;
import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class UserTransactionImpl
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = 2994652455204901910L;
    private TransactionManager tm = null;
    private int storedTimeOut = TransactionManagerImpl.DEFAULT_TRANSACTION_TIMEOUT;

    public UserTransactionImpl() throws SystemException {
        this.tm = TransactionManagerImpl.getTransactionManager();
    }

    @Override
    public synchronized void begin() throws NotSupportedException, SystemException {
        LogWriterI18n log = InternalDistributedSystem.getLoggerI18n();
        if (log.fineEnabled()) {
            log.fine("UserTransactionImpl starting JTA transaction");
        }
        int temp = this.storedTimeOut;
        this.storedTimeOut = TransactionManagerImpl.DEFAULT_TRANSACTION_TIMEOUT;
        this.tm.begin();
        this.tm.setTransactionTimeout(temp);
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.tm.commit();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.tm.rollback();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    @Override
    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    @Override
    public void setTransactionTimeout(int timeOut) throws SystemException {
        if (timeOut < 0) {
            String exception = LocalizedStrings.UserTransactionImpl_USERTRANSACTIONIMPL_SETTRANSACTIONTIMEOUT_CANNOT_SET_A_NEGATIVE_TIME_OUT_FOR_TRANSACTIONS.toLocalizedString();
            LogWriterI18n writer = TransactionUtils.getLogWriterI18n();
            if (writer.fineEnabled()) {
                writer.fine(exception);
            }
            throw new SystemException(exception);
        }
        if (timeOut == 0) {
            timeOut = TransactionManagerImpl.DEFAULT_TRANSACTION_TIMEOUT;
        }
        if (this.tm.getTransaction() != null) {
            this.tm.setTransactionTimeout(timeOut);
        } else {
            this.storedTimeOut = timeOut;
        }
    }
}

