/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.licensing.ComponentType;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.licensing.LicenseEngine;
import com.gemstone.gemfire.internal.licensing.LicenseListener;
import java.io.File;
import java.util.Date;

public class ClientLicenseChecker
extends LicenseChecker {
    private final LicenseChecker licenseChecker;

    public ClientLicenseChecker(InternalDistributedSystem ids, File dir, LogWriter log, String serialNumber, LicenseChecker licenseChecker) {
        super(ids, dir, log, serialNumber, ComponentType.APPLICATION_CACHE, null);
        this.licenseChecker = licenseChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLicensedClient(Object identifier) {
        ClientLicenseChecker clientLicenseChecker = this;
        synchronized (clientLicenseChecker) {
            boolean performLogging;
            boolean bl = performLogging = !this.acquiredManagedLicenses();
            if (performLogging && this.getLogWriter().configEnabled()) {
                if (!"G04E0-MFK43-M8E1H-0ZARK-AV25A".equals(this.serialNumber)) {
                    this.getLogWriter().config("Acquiring " + this.getComponentType().getShortName() + " license for clients with serial number \"" + this.serialNumber + "\".");
                } else if (this.requestDynamicSerialNumber()) {
                    this.getLogWriter().config("Acquiring " + this.getComponentType().getShortName() + " license for clients dynamically from serial number file or vFabric License Server.");
                } else {
                    this.getLogWriter().config("Licensing for clients requires either an Application Cache Node serial number (specified with license-application-cache) or the Unlimited Client Upgrade.");
                }
            }
            this.getLicenseEngine().acquireManagedLicense(identifier);
            if (performLogging) {
                String msg;
                if (this.unlicensed() && !this.getSerialNumber().equals("")) {
                    msg = "The specified serial number \"" + this.getSerialNumber() + "\" for clients may be expired or invalid for " + this.getComponentType().getShortName() + " license.";
                    this.getLogWriter().config(msg);
                    for (LicenseListener listener : ClientLicenseChecker.getLicenseListeners()) {
                        try {
                            listener.serialNumberFailed(this.serialNumber);
                        }
                        catch (Exception e) {
                            this.getLogWriter().config("LicenseListener " + listener + " serialNumberFailed threw " + e.getMessage(), e);
                        }
                    }
                }
                if (this.getLogWriter().fineEnabled()) {
                    Date expiration;
                    Date date = expiration = this.unlicensed() ? null : this.getExpiration();
                    if (this.getLogWriter().fineEnabled()) {
                        this.getLogWriter().fine(this + " " + (this.unlicensed() ? "failed to activate license for clients " : (expiration == null ? "activated permanent " : "activated evaluation ") + "license for clients with quantity " + this.getQuantity()) + (expiration != null ? " which expires on " + expiration : ""));
                    }
                } else if (this.unlicensed() && this.getSerialNumber().equals("")) {
                    msg = "Failed to acquire any license for clients.";
                    this.getLogWriter().config(msg);
                }
                if (this.requestDynamicSerialNumber() && this.getLicenseEngine().isServerLicense()) {
                    this.getLogWriter().config("Using " + this.getComponentType().getShortName() + " license for clients acquired dynamically from serial number file or vFabric License Server.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLicensedClient(Object identifier) {
        ClientLicenseChecker clientLicenseChecker = this;
        synchronized (clientLicenseChecker) {
            this.getLicenseEngine().releaseManagedLicense(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkClientLimit(int clients) throws LicenseException {
        if (this.licenseChecker.allowsUnlimitedClients()) {
            return;
        }
        boolean passed = true;
        int clientLimit = this.getQuantity();
        if (this.getLogWriter().fineEnabled()) {
            if (this.licenseChecker.unlicensed()) {
                this.getLogWriter().fine("Checking " + clients + " clients against limit " + clientLimit + " allowed without a license for clients.");
            } else {
                this.getLogWriter().fine("Checking " + clients + " client licenses used against limit " + clientLimit + " allowed by your license for clients.");
            }
        }
        try {
            if (clients > clientLimit) {
                passed = false;
                String msg = null;
                msg = this.licenseChecker.unlicensed() ? "The number of clients, " + clients + ", exceeded the limit of " + clientLimit + " allowed without a license for clients." : "The number of client licenses used, " + clients + ", exceeded the limit of " + clientLimit + " allowed by your license for clients.";
                if (this.enforceLimits()) {
                    throw new LicenseException(msg);
                }
                this.logViolation(msg);
            }
        }
        finally {
            for (LicenseListener listener : LicenseChecker.getLicenseListeners()) {
                try {
                    listener.checkedClientLimit(passed, clientLimit, clients);
                }
                catch (Exception e) {
                    this.getLogWriter().config("LicenseListener " + listener + " checkedClientLimit threw " + e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void checkUnlicensedClientLimit(int clients) throws LicenseException {
        throw new UnsupportedOperationException("ClientLicenseChecker does not support default evaluation license.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        ClientLicenseChecker clientLicenseChecker = this;
        synchronized (clientLicenseChecker) {
            this.getLicenseEngine().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerialNumber() {
        ClientLicenseChecker clientLicenseChecker = this;
        synchronized (clientLicenseChecker) {
            if (this.serialNumber.equals("G04E0-MFK43-M8E1H-0ZARK-AV25A")) {
                return "";
            }
            return this.serialNumber;
        }
    }

    @Override
    void acquireLicense(LicenseEngine licenseEngine) throws LicenseException {
        throw new UnsupportedOperationException("ClientLicenseChecker only supports managed licenses for clients.");
    }

    @Override
    void releaseLicense(LicenseEngine licenseEngine) {
        throw new UnsupportedOperationException("ClientLicenseChecker only supports managed licenses for clients.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQuantity() {
        ClientLicenseChecker clientLicenseChecker = this;
        synchronized (clientLicenseChecker) {
            return this.unlicensed() ? 0 : this.getLicenseEngine().getQuantity();
        }
    }

    @Override
    boolean enforceLimits() {
        return false;
    }
}

