/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.licensing.ClientLicenseChecker;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientLicenseService {
    static final String TEST_LICENSE_EVERY_INSTANCE_PROPERTY = "gemfire.licensing.test.licenseEveryInstance";
    private final LicenseChecker licenseChecker;
    private final ClientLicenseChecker clientLicenseChecker;
    private final Map<Object, Count> clientMap;
    private final boolean licenseEveryInstance;
    private final AtomicInteger licensedClientCount = new AtomicInteger();

    public ClientLicenseService(Cache cache, boolean licenseClients) {
        InternalDistributedSystem ids;
        LicenseChecker lc;
        this.licenseEveryInstance = Boolean.getBoolean(TEST_LICENSE_EVERY_INSTANCE_PROPERTY);
        LicenseChecker licenseCheckerValue = null;
        ClientLicenseChecker clientLicenseCheckerValue = null;
        HashMap clientMapValue = null;
        if (licenseClients && !(lc = (ids = ((GemFireCacheImpl)cache).getDistributedSystem()).getLicenseChecker()).allowsUnlimitedClients()) {
            licenseCheckerValue = lc;
            if (!lc.unlicensed()) {
                String serialNumber = ids.getConfig().getLicenseApplicationCache();
                clientLicenseCheckerValue = new ClientLicenseChecker(ids, lc.getDirectory(), lc.getLogWriter(), serialNumber, lc);
                clientMapValue = new HashMap();
            }
        }
        this.licenseChecker = licenseCheckerValue;
        this.clientLicenseChecker = clientLicenseCheckerValue;
        this.clientMap = clientMapValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.clientLicenseChecker != null) {
            ClientLicenseService clientLicenseService = this;
            synchronized (clientLicenseService) {
                this.clientLicenseChecker.shutdown();
                this.clientMap.clear();
            }
        }
    }

    public void checkUnlicensedClientLimit() throws LicenseException {
        if (this.licenseChecker == null) {
            return;
        }
        this.licenseChecker.checkUnlicensedClientLimit(this.licensedClientCount.get() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incLicensedClientCount(Object identifier) {
        if (this.licenseChecker == null) {
            return;
        }
        if (this.clientMap == null) {
            this.licensedClientCount.incrementAndGet();
        } else {
            ClientLicenseService clientLicenseService = this;
            synchronized (clientLicenseService) {
                Count count = this.clientMap.get(identifier);
                if (count == null) {
                    count = new Count(1);
                    this.clientMap.put(identifier, count);
                    this.clientLicenseChecker.addLicensedClient(identifier);
                } else {
                    count.increment();
                }
                if (this.licenseEveryInstance) {
                    int instances = 0;
                    for (Object key2 : this.clientMap.keySet()) {
                        count = this.clientMap.get(key2);
                        instances += count.count;
                    }
                    this.clientLicenseChecker.checkClientLimit(instances);
                } else {
                    this.clientLicenseChecker.checkClientLimit(this.clientMap.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decLicensedClientCount(Object identifier) {
        if (this.licenseChecker == null) {
            return;
        }
        if (this.clientMap == null) {
            this.licensedClientCount.decrementAndGet();
        } else {
            ClientLicenseService clientLicenseService = this;
            synchronized (clientLicenseService) {
                Count count = this.clientMap.get(identifier);
                if (count != null && count.decrement()) {
                    this.clientMap.remove(identifier);
                    this.clientLicenseChecker.removeLicensedClient(identifier);
                }
            }
        }
    }

    LicenseChecker getLicenseChecker() {
        return this.licenseChecker;
    }

    ClientLicenseChecker getClientLicenseChecker() {
        return this.clientLicenseChecker;
    }

    int getLicensedClientCount() {
        return this.licensedClientCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Object, Count> getClientMapSnapshot() {
        ClientLicenseService clientLicenseService = this;
        synchronized (clientLicenseService) {
            return new HashMap<Object, Count>(this.clientMap);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("licenseEveryInstance=").append(this.licenseEveryInstance);
        sb.append(", licenseChecker=").append(this.licenseChecker);
        if (this.clientLicenseChecker != null) {
            sb.append(", clientLicenseChecker=").append(this.clientLicenseChecker);
            sb.append(", clientMap=").append(this.clientMap);
        } else {
            sb.append(", licensedClientCount=").append(this.licensedClientCount.get());
        }
        return sb.append("}").toString();
    }

    static class Count {
        int count;

        Count(int count) {
            this.count = count;
        }

        void increment() {
            ++this.count;
        }

        boolean decrement() {
            --this.count;
            return this.count < 1;
        }
    }
}

