/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.internal.licensing.ComponentType;
import com.gemstone.gemfire.internal.licensing.UnlicensedPeerLimiter;

public class LicenseContext {
    private static LicenseContext licenseContext = null;
    private final boolean acquireLicense;
    private final String serialNumber;
    private final ComponentType componentType;
    private final UnlicensedPeerLimiter unlicensedPeerLimiter;

    public static synchronized LicenseContext get() {
        return licenseContext;
    }

    public static synchronized void set(boolean acquireLicense, String serialNumber, ComponentType componentType, UnlicensedPeerLimiter unlicensedPeerLimiter) {
        licenseContext = new LicenseContext(acquireLicense, serialNumber, componentType, unlicensedPeerLimiter);
    }

    public static synchronized void clear() {
        licenseContext = null;
    }

    private LicenseContext(boolean acquireLicense, String serialNumber, ComponentType componentType, UnlicensedPeerLimiter unlicensedPeerLimiter) {
        this.acquireLicense = acquireLicense;
        this.serialNumber = serialNumber;
        this.componentType = componentType;
        this.unlicensedPeerLimiter = unlicensedPeerLimiter;
    }

    public boolean getAcquireLicense() {
        return this.acquireLicense;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public UnlicensedPeerLimiter getUnlicensedPeerLimiter() {
        return this.unlicensedPeerLimiter;
    }
}

