/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.licensing.CacheLicenseChecker;
import com.gemstone.gemfire.internal.licensing.ComponentType;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.licensing.ServerLicenseChecker;
import com.gemstone.gemfire.internal.licensing.VFabricLicenseEngine;
import com.gemstone.gemfire.internal.logging.PureLogWriter;
import com.springsource.vfabric.licensing.state.LicenseState;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import java.util.StringTokenizer;

public class LicenseTester {
    private static final String TYPE_ACN = "vf.gf.acn";
    private static final String TYPE_DMN = "vf.gf.dmn";
    private static final String TYPE_SQLF = "vf.sf";
    private static final String LICENSE_TESTER_CLIENT_STATE_FILE = System.getProperty("user.dir") + File.separator + "LicenseTester-license.cfg";
    private static final String LICENSE_TESTER_CLIENT_EVENTS_FILE = System.getProperty("user.dir") + File.separator + "LicenseTester-events.txt";
    private final String serialNumber;
    private final int logLevel;

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args[0] == null || args[0].trim().length() < 2) {
            LicenseTester.usage();
            return;
        }
        String serialNumber = args[0].trim();
        boolean verbose = false;
        String componentId = null;
        for (int i = 1; i < args.length; ++i) {
            if (args[i] == null || args[i].trim().length() <= 0) continue;
            StringTokenizer tokenizer = new StringTokenizer(args[i], "=");
            String command = null;
            String value2 = null;
            if (tokenizer.hasMoreTokens()) {
                command = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreTokens()) {
                value2 = tokenizer.nextToken();
            }
            if (command == null || value2 == null) {
                LicenseTester.usage();
                return;
            }
            if (command.equalsIgnoreCase("verbose") && value2.equalsIgnoreCase("true")) {
                verbose = true;
                continue;
            }
            if (command.equalsIgnoreCase("type")) {
                if (!value2.equalsIgnoreCase(TYPE_DMN) && !value2.equalsIgnoreCase(TYPE_ACN) && !value2.equalsIgnoreCase(TYPE_SQLF)) continue;
                componentId = value2.toLowerCase();
                continue;
            }
            LicenseTester.usage();
            return;
        }
        int logLevel = Integer.MAX_VALUE;
        if (verbose) {
            logLevel = 0;
            System.setProperty("gemfire.licensing.licensingClientLogVerbose", "true");
        }
        System.setProperty("gemfire.licensing.enableLicensingClientLog", "true");
        System.setProperty("gemfire.licensing.licensingClientStateFile", LICENSE_TESTER_CLIENT_STATE_FILE);
        System.setProperty("gemfire.licensing.licensingClientEventsFile", LICENSE_TESTER_CLIENT_EVENTS_FILE);
        LicenseTester tester = new LicenseTester(serialNumber, logLevel);
        tester.useSerialNumber(componentId);
    }

    static void usage() {
        System.out.println("Usage: com.gemstone.gemfire.internal.licensing.LicenseTester SERIAL-NUMBER type=ID [verbose=true | false]");
        System.out.println("SERIAL-NUMBER is dynamic | #####-#####-#####-#####-##### | <anything>");
        System.out.println("ID is vf.gf.acn | vf.gf.dmn | vf.sf");
    }

    LicenseTester(String serialNumber, int logLevel) {
        this.serialNumber = serialNumber;
        this.logLevel = logLevel;
    }

    void useSerialNumber(String componentId) throws Exception {
        File writableWorkingDir = DistributionConfig.DEFAULT_LICENSE_WORKING_DIR;
        PureLogWriter logWriter = new PureLogWriter(this.logLevel);
        boolean acn = false;
        boolean dmn = false;
        boolean sqlf = false;
        if (componentId != null) {
            acn = componentId.equals(TYPE_ACN);
            dmn = componentId.equals(TYPE_DMN);
            sqlf = componentId.equals(TYPE_SQLF);
        }
        if (acn) {
            System.out.println("Using component type vf.gf.acn");
            CacheLicenseChecker cacheLicenseChecker = new CacheLicenseChecker(null, writableWorkingDir, logWriter, this.serialNumber);
            this.checkLicense(cacheLicenseChecker);
        } else if (dmn) {
            System.out.println("Using component type vf.gf.dmn");
            ServerLicenseChecker serverLicenseChecker = new ServerLicenseChecker(null, writableWorkingDir, logWriter, this.serialNumber);
            this.checkLicense(serverLicenseChecker);
        } else if (sqlf) {
            System.out.println("Using component type vf.sf");
            Class<?> sqlfVersion = Class.forName("com.vmware.sqlfire.internal.SqlFireVersion");
            Method loadProperties = sqlfVersion.getMethod("loadProperties", new Class[0]);
            loadProperties.invoke(null, new Object[0]);
            ServerLicenseChecker serverLicenseChecker = new ServerLicenseChecker(null, writableWorkingDir, logWriter, this.serialNumber, ComponentType.SQLFIRE_DATASTORE, null);
            this.checkLicense(serverLicenseChecker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLicense(LicenseChecker licenseChecker) {
        if (this.serialNumber.equals("dynamic")) {
            int timeout = VFabricLicenseEngine.determineLicenseServerTimeout(null);
            System.out.println("\nAttempting to acquire license from vFabric License Server for " + licenseChecker.getComponentType().getLongName() + " within " + timeout / 1000 + " seconds.");
        } else {
            System.out.println("\nAttempting to use serial number \"" + this.serialNumber + "\" for " + licenseChecker.getComponentType().getLongName() + ".");
        }
        try {
            System.out.println("\nUsing " + licenseChecker + "\n");
            licenseChecker.acquireLicense();
            if (this.logLevel < Integer.MAX_VALUE) {
                System.out.println();
            }
            if ("G04E0-MFK43-M8E1H-0ZARK-AV25A".equals(this.serialNumber)) {
                System.out.println("Serial number \"" + this.serialNumber + "\" is the default evaluation serial number for VMware vFabric GemFire Data Management Node.");
                return;
            }
            if ("C10EH-H4LD1-48DKR-04AKK-2PHQF".equals(this.serialNumber)) {
                System.out.println("Serial number \"" + this.serialNumber + "\" is the default evaluation serial number for VMware vFabric Advanced.");
                return;
            }
            if (licenseChecker.unlicensed()) {
                if (this.serialNumber.equals("dynamic")) {
                    System.out.println("Failed to acquire license from vFabric License Server for " + licenseChecker.getComponentType().getLongName() + ".");
                } else {
                    System.out.println("Serial number \"" + this.serialNumber + "\" failed for " + licenseChecker.getComponentType().getShortName() + ". If the serial number is valid for the current release, it may have expired.");
                }
                return;
            }
            if (this.serialNumber.equals("dynamic")) {
                System.out.println("Dynamically acquired license from vFabric License Server for " + licenseChecker.getComponentType().getLongName() + ".");
            } else {
                System.out.println("Serial number \"" + this.serialNumber + "\" is valid for " + licenseChecker.getComponentType().getLongName() + ".");
            }
            System.out.println("quantity: " + licenseChecker.getQuantity());
            Date expiration = licenseChecker.getExpiration();
            System.out.println("expiration: " + (expiration == null ? "permanent" : expiration));
            if (expiration != null) {
                System.out.println("(Note: expiration may be floating or absolute.)");
            }
            System.out.println("isDefaultEvaluation: " + licenseChecker.isDefaultEvaluation());
            System.out.println("isExpired: " + licenseChecker.isExpired());
            System.out.println("isBridgeEnabled: " + licenseChecker.isBridgeEnabled());
            System.out.println("isWanEnabled: " + licenseChecker.isWanEnabled());
            System.out.println("allowsUnlimitedClients: " + licenseChecker.allowsUnlimitedClients());
            LicenseState licenseState = null;
            LicenseChecker licenseChecker2 = licenseChecker;
            synchronized (licenseChecker2) {
                licenseState = ((VFabricLicenseEngine)licenseChecker.getLicenseEngine()).getLicenseState();
            }
            System.out.println("componentId: " + licenseState.getComponentId());
            System.out.println("licenseType: " + licenseState.getLicenseType());
            System.out.println("totalAvailable: " + licenseState.getTotalAvailable());
            System.out.println("totalUsed: " + licenseState.getTotalUsed());
            Set<String> addons = licenseState.getAddonFeatures();
            System.out.println("addons: " + addons);
            if (licenseChecker.getComponentType() == ComponentType.DATA_MANAGEMENT) {
                System.out.println("clientQuantity: " + (licenseChecker.allowsUnlimitedClients() ? "unlimited" : "requires Application Cache Node or Unlimited Client Upgrade serial number"));
            }
            System.out.println("extendedParams: " + licenseState.getExtendedParameters());
            System.out.println("enforcement: " + licenseState.getEnforcement());
            System.out.println("licenseTimestamp: " + licenseState.getTimestamp());
        }
        finally {
            try {
                licenseChecker.releaseLicense();
            }
            catch (Throwable t) {}
            this.deleteFile(LICENSE_TESTER_CLIENT_STATE_FILE);
            this.deleteFile(LICENSE_TESTER_CLIENT_EVENTS_FILE);
        }
    }

    private void deleteFile(String fileName) {
        File file = new File(fileName);
        try {
            file.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

