/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.licensing;

import com.gemstone.gemfire.LogWriter;
import com.springsource.vfabric.licensing.log.LogFactory;
import com.springsource.vfabric.licensing.log.Logger;
import java.util.HashMap;
import java.util.Map;

public class LogWriterAdapter
implements LogFactory {
    static final String PREFIX = "Licensing Client: ";
    static final String CLIENT_1_1_CPUINFO_WARNING = "Could not open cpuinfo file /proc/cpuinfo";
    static final String CLIENT_1_2_CPUINFO_WARNING = "No cpuinfo file, cannot get cpu/core info on";
    static final String CLIENT_1_2_CPU_COUNT_WARNING = "Could not calculate cpu count on non-windows, non-linux system";
    static final Map<String, FILTER> FILTERS = new HashMap<String, FILTER>();
    private static final LogWriterAdapter instance;
    volatile LogWriter logWriter;
    volatile boolean verbose;

    static synchronized LogWriterAdapter getLogWriterAdapter(LogWriter logWriter, boolean verbose) {
        LogWriterAdapter.instance.logWriter = logWriter;
        LogWriterAdapter.instance.verbose = verbose;
        return instance;
    }

    static synchronized void shutdown() {
        LogWriterAdapter.instance.logWriter = null;
        LogWriterAdapter.instance.verbose = false;
    }

    static synchronized LogWriterAdapter getLogWriterAdapter() {
        return instance;
    }

    private LogWriterAdapter() {
    }

    private LogWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public Logger getLogger(Class<?> c) {
        return new AdapterLogger();
    }

    static FILTER filter(String msg) {
        if (msg == null) {
            return FILTER.NONE;
        }
        for (String string : FILTERS.keySet()) {
            if (!msg.contains(string) && !string.contains(msg)) continue;
            return FILTERS.get(string);
        }
        return FILTER.NONE;
    }

    static {
        FILTERS.put(CLIENT_1_1_CPUINFO_WARNING, FILTER.DEMOTE);
        FILTERS.put(CLIENT_1_2_CPUINFO_WARNING, FILTER.DEMOTE);
        FILTERS.put(CLIENT_1_2_CPU_COUNT_WARNING, FILTER.DEMOTE);
        instance = new LogWriterAdapter();
    }

    class AdapterLogger
    extends Logger {
        AdapterLogger() {
        }

        @Override
        public void debug(Object ... message) {
            if (!LogWriterAdapter.this.verbose) {
                return;
            }
            LogWriter logWriter = LogWriterAdapter.this.getLogWriter();
            if (logWriter == null) {
                return;
            }
            StringBuilder msgBuilder = new StringBuilder(LogWriterAdapter.PREFIX);
            Throwable throwable = null;
            for (Object msg : message) {
                if (msg instanceof String) {
                    switch (LogWriterAdapter.filter((String)msg)) {
                        case SUPPRESS: {
                            return;
                        }
                    }
                    msgBuilder.append(msg);
                    continue;
                }
                if (!(msg instanceof Throwable)) continue;
                throwable = (Throwable)msg;
            }
            logWriter.fine(msgBuilder.toString(), throwable);
        }

        @Override
        public void info(Object ... message) {
            if (!LogWriterAdapter.this.verbose) {
                return;
            }
            LogWriter logWriter = LogWriterAdapter.this.getLogWriter();
            if (logWriter == null) {
                return;
            }
            StringBuilder msgBuilder = new StringBuilder(LogWriterAdapter.PREFIX);
            Throwable throwable = null;
            for (Object msg : message) {
                if (msg instanceof String) {
                    switch (LogWriterAdapter.filter((String)msg)) {
                        case SUPPRESS: {
                            return;
                        }
                        case DEMOTE: {
                            this.debug(message);
                            return;
                        }
                    }
                    msgBuilder.append(msg);
                    continue;
                }
                if (!(msg instanceof Throwable)) continue;
                msgBuilder.append(": ").append(msg);
            }
            logWriter.info(msgBuilder.toString(), throwable);
        }

        @Override
        public void warn(Object ... message) {
            LogWriter logWriter = LogWriterAdapter.this.getLogWriter();
            if (logWriter == null) {
                return;
            }
            StringBuilder msgBuilder = new StringBuilder(LogWriterAdapter.PREFIX);
            Throwable throwable = null;
            for (Object msg : message) {
                if (msg instanceof String) {
                    switch (LogWriterAdapter.filter((String)msg)) {
                        case SUPPRESS: {
                            return;
                        }
                        case DEMOTE: {
                            this.debug(message);
                            return;
                        }
                    }
                    msgBuilder.append(msg);
                    continue;
                }
                if (!(msg instanceof Throwable)) continue;
                msgBuilder.append(": ").append(msg);
            }
            logWriter.warning(msgBuilder.toString(), throwable);
        }

        @Override
        public void error(Object ... message) {
            LogWriter logWriter = LogWriterAdapter.this.getLogWriter();
            if (logWriter == null) {
                return;
            }
            StringBuilder msgBuilder = new StringBuilder(LogWriterAdapter.PREFIX);
            Throwable throwable = null;
            for (Object msg : message) {
                if (msg instanceof String) {
                    switch (LogWriterAdapter.filter((String)msg)) {
                        case SUPPRESS: {
                            return;
                        }
                        case DEMOTE: {
                            this.debug(message);
                            return;
                        }
                    }
                    msgBuilder.append(msg);
                    continue;
                }
                if (!(msg instanceof Throwable)) continue;
                msgBuilder.append(": ").append(msg);
            }
            logWriter.error(msgBuilder.toString(), throwable);
        }
    }

    static enum FILTER {
        SUPPRESS,
        DEMOTE,
        NONE;

    }
}

