/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.logging;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.DateFormatter;
import com.gemstone.gemfire.internal.logging.LocalLogWriter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class LogFileParser {
    private static final boolean TRIM_TIMESTAMPS = Boolean.getBoolean("mergelogs.TRIM_TIMESTAMPS");
    private static final boolean NEWLINE_AFTER_HEADER = Boolean.getBoolean("mergelogs.NEWLINE_AFTER_HEADER");
    private static final boolean TRIM_NAMES = Boolean.getBoolean("mergelogs.TRIM_NAMES");
    private static final String FULL_THREAD_DUMP = "===== FULL THREAD DUMP ===============";
    private final String logFileName;
    private final String extLogFileName;
    private BufferedReader br;
    private boolean hasMoreEntries;
    private String timestamp;
    private StringBuffer sb;
    private boolean firstEntry = true;
    private final StringBuffer whiteFileName;
    private boolean suppressBlanks;

    public LogFileParser(String logFileName, BufferedReader br) {
        this(logFileName, br, false, false);
    }

    public LogFileParser(String logFileName, BufferedReader br, boolean tabOut, boolean suppressBlanks) {
        this.logFileName = logFileName;
        this.br = br;
        this.hasMoreEntries = true;
        this.timestamp = null;
        this.sb = new StringBuffer();
        this.suppressBlanks = suppressBlanks;
        this.whiteFileName = new StringBuffer();
        if (tabOut) {
            int i;
            int numTabs = (logFileName.length() + 2) / 8;
            for (i = 0; i < numTabs; ++i) {
                this.whiteFileName.append('\t');
            }
            for (i = (logFileName.length() + 2) % 8; i > 0; --i) {
                this.whiteFileName.append(' ');
            }
        }
        this.extLogFileName = this.logFileName != null ? this.logFileName + ": " : null;
    }

    public boolean hasMoreEntries() {
        return this.hasMoreEntries;
    }

    private String getTimestamp(String line) {
        int llen = line.length();
        String result = null;
        if (llen > 10 && line.charAt(0) == '[' && (line.charAt(1) == 'i' && line.charAt(2) == 'n' && line.charAt(3) == 'f' || line.charAt(1) == 'f' && line.charAt(2) == 'i' && line.charAt(3) == 'n' || line.charAt(1) == 'w' && line.charAt(2) == 'a' && line.charAt(3) == 'r' || line.charAt(1) == 'd' && line.charAt(2) == 'e' && line.charAt(3) == 'b' || line.charAt(1) == 't' && line.charAt(2) == 'r' && line.charAt(3) == 'a' || line.charAt(1) == 's' && line.charAt(2) == 'e' && line.charAt(3) == 'v' || line.charAt(1) == 'c' && line.charAt(2) == 'o' && line.charAt(3) == 'n' || line.charAt(1) == 'e' && line.charAt(2) == 'r' && line.charAt(3) == 'r' || line.charAt(1) == 's' && line.charAt(2) == 'e' && line.charAt(3) == 'c' && line.charAt(4) == 'u' && line.charAt(5) == 'r')) {
            int sidx;
            for (sidx = 4; sidx < llen && line.charAt(sidx) != ' '; ++sidx) {
            }
            int endIdx = sidx + 24;
            if (endIdx < llen) {
                result = line.substring(sidx + 1, endIdx + 1);
            }
        }
        return result;
    }

    public LogEntry getNextEntry() throws IOException {
        String lineStr;
        LogEntry entry = null;
        while (this.br.ready() && (lineStr = this.br.readLine()) != null) {
            String nextTimestamp;
            int llen;
            int lend;
            if (this.suppressBlanks || this.firstEntry) {
                for (lend = llen = lineStr.length(); lend > 1 && Character.isWhitespace(lineStr.charAt(lend - 1)); --lend) {
                }
                if (lend == 0) continue;
            }
            StringBuffer line = new StringBuffer(lineStr);
            if (lend != llen) {
                line.setLength(lend);
                llen = lend;
            }
            if ((nextTimestamp = this.getTimestamp(lineStr)) != null) {
                if (this.timestamp != null && TRIM_TIMESTAMPS) {
                    int idx;
                    int tsl = this.timestamp.length();
                    if (tsl > 0) {
                        int start = 5;
                        if (line.charAt(start) != ' ' && line.charAt(++start) != ' ' && line.charAt(++start) != ' ' && line.charAt(++start) != ' ') {
                            start = 0;
                        }
                        if (start > 0) {
                            int idx2;
                            line.delete(start + 25, start + 29);
                            line.delete(start, start + 11);
                            if (TRIM_NAMES && (idx2 = line.indexOf("<", 12)) > start + 13) {
                                line.delete(start + 13, idx2 - 1);
                            }
                        }
                    }
                    if (NEWLINE_AFTER_HEADER && (idx = line.indexOf("tid=")) > 0 && (idx = line.indexOf("]", idx + 4)) + 1 < line.length()) {
                        line.insert(idx + 1, "\n ");
                    }
                }
                if (this.timestamp != null) {
                    entry = new LogEntry(this.timestamp, this.sb.toString(), this.suppressBlanks);
                }
                this.timestamp = nextTimestamp;
                if (!this.firstEntry) {
                    this.sb = new StringBuffer(500);
                } else {
                    this.firstEntry = false;
                }
                if (this.extLogFileName != null) {
                    this.sb.append(this.extLogFileName);
                }
            } else if (line.indexOf(FULL_THREAD_DUMP) != -1) {
                String dump = lineStr;
                lineStr = this.br.readLine();
                if (lineStr == null) break;
                DateFormat df = DateFormatter.createDateFormat("E MMM d HH:mm:ss yyyy");
                df.setLenient(true);
                try {
                    Date date = df.parse(lineStr);
                    if (this.timestamp != null) {
                        entry = new LogEntry(this.timestamp, this.sb.toString());
                    }
                    df = DateFormatter.createDateFormat();
                    this.timestamp = df.format(date);
                    lineStr = dump;
                    this.sb = new StringBuffer();
                    if (this.extLogFileName != null) {
                        this.sb.append(this.extLogFileName);
                    }
                    this.sb.append("[dump ");
                    this.sb.append(this.timestamp);
                    this.sb.append("]\n\n");
                }
                catch (ParseException ex) {
                    this.sb.append(dump);
                }
            } else {
                this.sb.append(this.whiteFileName);
            }
            this.sb.append(line);
            this.sb.append("\n");
            if (entry == null) continue;
            return entry;
        }
        if (this.timestamp == null) {
            DateFormat df = DateFormatter.createDateFormat();
            this.timestamp = df.format(new Date());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            LocalLogWriter tempLogger = new LocalLogWriter(Integer.MIN_VALUE, pw);
            tempLogger.info(LocalizedStrings.LogFileParser_MISSING_TIME_STAMP);
            pw.flush();
            this.sb.insert(0, "\n\n");
            this.sb.insert(0, sw.toString().trim());
            this.sb.insert(0, this.extLogFileName);
        }
        entry = new LastLogEntry(this.timestamp, this.sb.toString());
        this.sb = null;
        this.hasMoreEntries = false;
        return entry;
    }

    public static void main(String[] args) throws Throwable {
        if (args.length < 1) {
            System.err.println(LocalizedStrings.LogFileParser_MISSING_LOG_FILE_NAME.toLocalizedString());
            System.exit(1);
        }
        String logFileName = args[0];
        BufferedReader br = new BufferedReader(new FileReader(logFileName));
        LogFileParser parser = new LogFileParser(logFileName, br, false, false);
        PrintWriter pw = new PrintWriter(System.out);
        while (parser.hasMoreEntries()) {
            LogEntry entry = parser.getNextEntry();
            entry.writeTo(pw);
        }
    }

    static class LastLogEntry
    extends LogEntry {
        public LastLogEntry(String timestamp, String contents) {
            super(timestamp, contents);
        }

        @Override
        public boolean isLast() {
            return true;
        }
    }

    static class LogEntry {
        private String timestamp;
        private String contents;
        private boolean suppressBlanks;

        public LogEntry(String timestamp, String contents) {
            this.timestamp = timestamp;
            this.contents = contents;
        }

        public LogEntry(String timestamp, String contents, boolean suppressBlanks) {
            this.timestamp = timestamp;
            this.contents = contents.trim();
            this.suppressBlanks = suppressBlanks;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        String getContents() {
            return this.contents;
        }

        public void writeTo(PrintWriter pw) {
            pw.println(this.contents);
            if (!this.suppressBlanks) {
                pw.println("");
            }
            pw.flush();
        }

        public boolean isLast() {
            return false;
        }
    }
}

